# coding=utf-8
# --------------------------------------------------------------------
# Copyright (C) 1991 - 2018 - EDF R&D - www.code-aster.org
# This file is part of code_aster.
#
# code_aster is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# code_aster is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with code_aster.  If not, see <http://www.gnu.org/licenses/>.
# --------------------------------------------------------------------

# person_in_charge: j-pierre.lefebvre at edf.fr

from code_aster.Cata.Syntax import *
from code_aster.Cata.DataStructure import *
from code_aster.Cata.Commons import *


DEFI_MATERIAU=OPER(nom="DEFI_MATERIAU",op=5,sd_prod=mater_sdaster,
                   fr=tr("Définition des paramètres décrivant le comportement d un matériau"),
                   reentrant='f:MATER',
       regles=(EXCLUS('ELAS','ELAS_FO','ELAS_FLUI','ELAS_ISTR','ELAS_ISTR_FO','ELAS_ORTH',
                      'ELAS_ORTH_FO','ELAS_COQUE','ELAS_COQUE_FO',
                      'ELAS_HYPER','ELAS_2NDG','ELAS_GLRC','ELAS_DHRC'),
               EXCLUS('THER','THER_FO','THER_ORTH','THER_NL','THER_HYDR','THER_COQUE','THER_COQUE_FO'),
               EXCLUS('ECRO_LINE','ECRO_LINE_FO','ECRO_PUIS','ECRO_COOK','ECRO_COOK_FO',),
               EXCLUS('ENDO_HETEROGENE'),
               EXCLUS('TAHERI','TAHERI_FO'),
               EXCLUS('ENDO_SCALAIRE','ENDO_SCALAIRE_FO'),
               EXCLUS('ENDO_FISS_EXP','ENDO_FISS_EXP_FO'),
               EXCLUS('ROUSSELIER','ROUSSELIER_FO'),
               EXCLUS('VISC_SINH','VISC_SINH_FO'),
               PRESENT_PRESENT('ROUSSELIER','TRACTION'),
               PRESENT_PRESENT('ROUSSELIER_FO','TRACTION'),
               EXCLUS('CIN1_CHAB','CIN1_CHAB_FO'),
               EXCLUS('CIN2_CHAB','CIN2_CHAB_FO'),
               EXCLUS('VISCOCHAB','VISCOCHAB_FO'),
               EXCLUS('LEMAITRE','LEMAITRE_FO','VISC_IRRA_LOG',
               'LEMA_SEUIL','LEMA_SEUIL_FO','LEMAITRE_IRRA',),
               EXCLUS('META_LEMA_ANI','META_LEMA_ANI_FO'),
               EXCLUS('VENDOCHAB','VENDOCHAB_FO'),
               EXCLUS('VISC_ENDO','VISC_ENDO_FO'),
               PRESENT_PRESENT('BPEL_ACIER','ELAS'),
               PRESENT_PRESENT('ETCC_ACIER','ELAS'),
               EXCLUS('ETCC_ACIER','BPEL_ACIER'),
               EXCLUS('ETCC_BETON','BPEL_BETON'),

               EXCLUS('RCCM','RCCM_FO'),
               EXCLUS('WEIBULL','WEIBULL_FO'),
               PRESENT_PRESENT('LAIGLE','ELAS'),
               PRESENT_PRESENT('LETK','ELAS'),
               PRESENT_PRESENT('LKR','ELAS'),
               PRESENT_PRESENT('DRUCK_PRAGER','ELAS'),
               PRESENT_PRESENT('VISC_DRUC_PRAG','ELAS'),
               PRESENT_PRESENT('ELAS_GONF','ELAS'),
               PRESENT_PRESENT('HOEK_BROWN','ELAS'),
               EXCLUS('MAZARS','MAZARS_FO'),
               PRESENT_PRESENT('JOINT_BA','ELAS'),
               PRESENT_PRESENT('CABLE','ELAS'),
               PRESENT_PRESENT('MOHR_COULOMB','ELAS'),
               PRESENT_PRESENT('ELAS_GLRC','GLRC_DM'),
               ),
           reuse=SIMP(statut='c', typ=CO),
           MATER      =SIMP(statut='f',typ=mater_sdaster),
#
# comportement élastique
#
           ELAS            =FACT(statut='f',
             E               =SIMP(statut='o',typ='R',val_min=0.E+0),
             NU              =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=0.5E+0),
             RHO             =SIMP(statut='f',typ='R'),
             ALPHA           =SIMP(statut='f',typ='R'),
             AMOR_ALPHA      =SIMP(statut='f',typ='R'),
             AMOR_BETA       =SIMP(statut='f',typ='R'),
             AMOR_HYST       =SIMP(statut='f',typ='R'),
             LONG_CARA       =SIMP(statut='f',typ='R',val_min= 0.E+0 ),
             COEF_AMOR       =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
           ),
           ELAS_FO         =FACT(statut='f',
             regles=(PRESENT_PRESENT('ALPHA','TEMP_DEF_ALPHA'),),
             E               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             TEMP_DEF_ALPHA  =SIMP(statut='f',typ='R'),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.),
             ALPHA           =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             AMOR_ALPHA      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_BETA       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_HYST       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K_DESSIC        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             B_ENDOGE        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             FONC_DESORP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             LONG_CARA       =SIMP(statut='f',typ='R',val_min= 0.E+0 ),
             COEF_AMOR       =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
           ),
           ELAS_FLUI       =FACT(statut='f',
             E               =SIMP(statut='o',typ='R'),
             NU              =SIMP(statut='o',typ='R'),
             RHO             =SIMP(statut='o',typ='R'),
             PROF_RHO_F_INT  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PROF_RHO_F_EXT  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COEF_MASS_AJOU  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ELAS_ISTR       =FACT(statut='f',
             E_L             =SIMP(statut='o',typ='R'),
             E_N             =SIMP(statut='o',typ='R'),
             NU_LT           =SIMP(statut='o',typ='R'),
             NU_LN           =SIMP(statut='o',typ='R'),
             G_LN            =SIMP(statut='o',typ='R'),
             RHO             =SIMP(statut='f',typ='R'),
             ALPHA_L         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             ALPHA_N         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           ELAS_ISTR_FO    =FACT(statut='f',
             regles=(
                      PRESENT_PRESENT('ALPHA_L','TEMP_DEF_ALPHA'),
                      PRESENT_PRESENT('ALPHA_N','TEMP_DEF_ALPHA'),
                    ),
             E_L             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             E_N             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_LT           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_LN           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_LN            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             TEMP_DEF_ALPHA  =SIMP(statut='f',typ='R'),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.),
             ALPHA_L         =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             ALPHA_N         =SIMP(statut='f',typ=(fonction_sdaster,formule)),
           ),
           ELAS_ORTH       =FACT(statut='f',
             E_L             =SIMP(statut='o',typ='R'),
             E_T             =SIMP(statut='o',typ='R'),
             E_N             =SIMP(statut='f',typ='R'),
             NU_LT           =SIMP(statut='o',typ='R'),
             NU_LN           =SIMP(statut='f',typ='R'),
             NU_TN           =SIMP(statut='f',typ='R'),
             G_LT            =SIMP(statut='o',typ='R'),
             G_LN            =SIMP(statut='f',typ='R'),
             G_TN            =SIMP(statut='f',typ='R'),
             RHO             =SIMP(statut='f',typ='R'),
             ALPHA_L         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             ALPHA_T         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             ALPHA_N         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             XT              =SIMP(statut='f',typ='R',defaut= 1. ),
             XC              =SIMP(statut='f',typ='R',defaut= 1. ),
             YT              =SIMP(statut='f',typ='R',defaut= 1. ),
             YC              =SIMP(statut='f',typ='R',defaut= 1. ),
             S_LT            =SIMP(statut='f',typ='R',defaut= 1. ),
             AMOR_ALPHA      =SIMP(statut='f',typ='R'),
             AMOR_BETA       =SIMP(statut='f',typ='R'),
             AMOR_HYST       =SIMP(statut='f',typ='R'),
           ),
           ELAS_ORTH_FO    =FACT(statut='f',
             regles=(
                      PRESENT_PRESENT('ALPHA_L','TEMP_DEF_ALPHA'),
                      PRESENT_PRESENT('ALPHA_N','TEMP_DEF_ALPHA'),
                      PRESENT_PRESENT('ALPHA_T','TEMP_DEF_ALPHA'),
                    ),
             E_L             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             E_T             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             E_N             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_LT           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_LN           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_TN           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_LT            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_LN            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_TN            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             TEMP_DEF_ALPHA  =SIMP(statut='f',typ='R'),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1. ),
             ALPHA_L         =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             ALPHA_T         =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             ALPHA_N         =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             AMOR_ALPHA      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_BETA       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_HYST       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ELAS_HYPER      =FACT(statut='f',
                                 regles=(UN_PARMI('K','NU'),),
             C10             =SIMP(statut='o',typ='R',
                                   fr=tr("Si C10 est le seul coefficient fourni, alors le matériau est Néo-Hookéen.")),
             C01             =SIMP(statut='f',typ='R',defaut=0.0,
                                   fr=tr("Si l'on fournit C01 en plus de C10, on obtient un matériau de type Mooney-Rivlin.")),
             C20             =SIMP(statut='f',typ='R',defaut=0.0,
                                   fr=tr("Si l'on fournit C20 en plus de C10 et C01, on obtient un matériau de type Signorini.")),
             K               =SIMP(statut='f',typ='R',fr=tr("Module de compressibilité.")),
             NU              =SIMP(statut='f',typ='R',val_min=-1.E+0,val_max=0.5E+0,fr=tr("Coefficient de Poisson.")),
             RHO             =SIMP(statut='f',typ='R',defaut=0.0,fr=tr("Masse volumique.")),
           ),
           ELAS_COQUE      =FACT(statut='f',
             regles=(EXCLUS('MEMB_L','M_LLLL',),
                     PRESENT_PRESENT('MEMB_L','MEMB_LT', 'MEMB_T','MEMB_G_LT','FLEX_L','FLEX_LT',
                                     'FLEX_T','FLEX_G_LT','CISA_L','CISA_T',),
                     PRESENT_PRESENT('M_LLLL','M_LLTT','M_LLLT','M_TTTT','M_TTLT','M_LTLT','F_LLLL',
                                     'F_LLTT','F_LLLT','F_TTTT','F_TTLT','F_LTLT','MF_LLLL',
                                     'MF_LLTT','MF_LLLT','MF_TTTT','MF_TTLT','MF_LTLT','MC_LLLZ',
                                     'MC_LLTZ','MC_TTLZ','MC_TTTZ','MC_LTLZ','MC_LTTZ','FC_LLLZ',
                                     'FC_LLTZ','FC_TTLZ','FC_TTTZ','FC_LTLZ','FC_LTTZ','C_LZLZ',
                                     'C_LZTZ','C_TZTZ'),),
             MEMB_L          =SIMP(statut='f',typ='R'),
             MEMB_LT         =SIMP(statut='f',typ='R'),
             MEMB_T          =SIMP(statut='f',typ='R'),
             MEMB_G_LT       =SIMP(statut='f',typ='R'),
             FLEX_L          =SIMP(statut='f',typ='R'),
             FLEX_LT         =SIMP(statut='f',typ='R'),
             FLEX_T          =SIMP(statut='f',typ='R'),
             FLEX_G_LT       =SIMP(statut='f',typ='R'),
             CISA_L          =SIMP(statut='f',typ='R'),
             CISA_T          =SIMP(statut='f',typ='R'),
             M_LLLL          =SIMP(statut='f',typ='R'),
             M_LLTT          =SIMP(statut='f',typ='R'),
             M_LLLT          =SIMP(statut='f',typ='R'),
             M_TTTT          =SIMP(statut='f',typ='R'),
             M_TTLT          =SIMP(statut='f',typ='R'),
             M_LTLT          =SIMP(statut='f',typ='R'),
             F_LLLL          =SIMP(statut='f',typ='R'),
             F_LLTT          =SIMP(statut='f',typ='R'),
             F_LLLT          =SIMP(statut='f',typ='R'),
             F_TTTT          =SIMP(statut='f',typ='R'),
             F_TTLT          =SIMP(statut='f',typ='R'),
             F_LTLT          =SIMP(statut='f',typ='R'),
             MF_LLLL         =SIMP(statut='f',typ='R'),
             MF_LLTT         =SIMP(statut='f',typ='R'),
             MF_LLLT         =SIMP(statut='f',typ='R'),
             MF_TTTT         =SIMP(statut='f',typ='R'),
             MF_TTLT         =SIMP(statut='f',typ='R'),
             MF_LTLT         =SIMP(statut='f',typ='R'),
             MC_LLLZ         =SIMP(statut='f',typ='R'),
             MC_LLTZ         =SIMP(statut='f',typ='R'),
             MC_TTLZ         =SIMP(statut='f',typ='R'),
             MC_TTTZ         =SIMP(statut='f',typ='R'),
             MC_LTLZ         =SIMP(statut='f',typ='R'),
             MC_LTTZ         =SIMP(statut='f',typ='R'),
             FC_LLLZ         =SIMP(statut='f',typ='R'),
             FC_LLTZ         =SIMP(statut='f',typ='R'),
             FC_TTLZ         =SIMP(statut='f',typ='R'),
             FC_TTTZ         =SIMP(statut='f',typ='R'),
             FC_LTLZ         =SIMP(statut='f',typ='R'),
             FC_LTTZ         =SIMP(statut='f',typ='R'),
             C_LZLZ          =SIMP(statut='f',typ='R'),
             C_LZTZ          =SIMP(statut='f',typ='R'),
             C_TZTZ          =SIMP(statut='f',typ='R'),
             RHO             =SIMP(statut='f',typ='R'),
             ALPHA           =SIMP(statut='f',typ='R'),
             ORDRE_PARAM     =SIMP(statut='c',typ='TXM', max='**', defaut=('MEMB_L','MEMB_LT','MEMB_T',
                             'MEMB_G_LT','FLEX_L','FLEX_LT','FLEX_T','FLEX_G_LT','CISA_L','CISA_T','M_LLLL',
                             'M_LLTT','M_LLLT','M_TTTT','M_TTLT','M_LTLT','F_LLLL','F_LLTT','F_LLLT','F_TTTT',
                             'F_TTLT','F_LTLT','MF_LLLL','MF_LLTT','MF_LLLT','MF_TTTT','MF_TTLT','MF_LTLT',
                             'MC_LLLZ','MC_LLTZ','MC_TTLZ','MC_TTTZ','MC_LTLZ','MC_LTTZ','FC_LLLZ','FC_LLTZ',
                             'FC_TTLZ','FC_TTTZ','FC_LTLZ','FC_LTTZ','C_LZLZ','C_LZTZ','C_TZTZ','RHO','ALPHA', )),
           ),
           ELAS_COQUE_FO   =FACT(statut='f',
             regles=(EXCLUS('MEMB_L','M_LLLL',),
                     PRESENT_PRESENT('MEMB_L','MEMB_LT','MEMB_T','MEMB_G_LT','FLEX_L','FLEX_LT',
                                     'FLEX_T','FLEX_G_LT','CISA_L','CISA_T',),
                     PRESENT_PRESENT('M_LLLL','M_LLTT','M_LLLT','M_TTTT','M_TTLT','M_LTLT','F_LLLL',
                                     'F_LLTT','F_LLLT','F_TTTT','F_TTLT','F_LTLT','MF_LLLL','MF_LLTT',
                                     'MF_LLLT','MF_TTTT','MF_TTLT','MF_LTLT','MC_LLLZ','MC_LLTZ',
                                     'MC_TTLZ','MC_TTTZ','MC_LTLZ','MC_LTTZ','FC_LLLZ','FC_LLTZ',
                                     'FC_TTLZ','FC_TTTZ','FC_LTLZ','FC_LTTZ','C_LZLZ','C_LZTZ','C_TZTZ'),),
             MEMB_L          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MEMB_LT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MEMB_T          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MEMB_G_LT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FLEX_L          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FLEX_LT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FLEX_T          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FLEX_G_LT       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CISA_L          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CISA_T          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_LLLL          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_LLTT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_LLLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_TTTT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_TTLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_LTLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_LLLL          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_LLTT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_LLLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_TTTT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_TTLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_LTLT          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_LLLL         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_LLTT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_LLLT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_TTTT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_TTLT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MF_LTLT         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_LLLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_LLTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_TTLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_TTTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_LTLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MC_LTTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_LLLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_LLTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_TTLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_TTTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_LTLZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FC_LTTZ         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_LZLZ          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_LZTZ          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_TZTZ          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALPHA           =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             ORDRE_PARAM     =SIMP(statut='c',typ='TXM', max='**', defaut=('MEMB_L','MEMB_LT','MEMB_T',
                             'MEMB_G_LT','FLEX_L','FLEX_LT','FLEX_T','FLEX_G_LT','CISA_L','CISA_T','M_LLLL',
                             'M_LLTT','M_LLLT','M_TTTT','M_TTLT','M_LTLT','F_LLLL','F_LLTT','F_LLLT','F_TTTT',
                             'F_TTLT','F_LTLT','MF_LLLL','MF_LLTT','MF_LLLT','MF_TTTT','MF_TTLT','MF_LTLT',
                             'MC_LLLZ','MC_LLTZ','MC_TTLZ','MC_TTTZ','MC_LTLZ','MC_LTTZ','FC_LLLZ','FC_LLTZ',
                             'FC_TTLZ','FC_TTTZ','FC_LTLZ','FC_LTTZ','C_LZLZ','C_LZTZ','C_TZTZ','RHO','ALPHA', )),
           ),
           ELAS_MEMBRANE     =FACT(statut='f',
             M_LLLL          =SIMP(statut='o',typ='R'),
             M_LLTT          =SIMP(statut='o',typ='R'),
             M_LLLT          =SIMP(statut='o',typ='R'),
             M_TTTT          =SIMP(statut='o',typ='R'),
             M_TTLT          =SIMP(statut='o',typ='R'),
             M_LTLT          =SIMP(statut='o',typ='R'),
             RHO             =SIMP(statut='f',typ='R'),
             ALPHA           =SIMP(statut='f',typ='R'),
           ),
           ELAS_2NDG        =FACT(statut='f',
             A1              =SIMP(statut='o',typ='R'),
             A2              =SIMP(statut='f',typ='R'),
             A3              =SIMP(statut='f',typ='R'),
             A4              =SIMP(statut='f',typ='R'),
             A5              =SIMP(statut='f',typ='R'),
           ),
           ELAS_GLRC        =FACT(statut='f',
             regles=(PRESENT_PRESENT('BT1','BT2'),),
             E_M             =SIMP(statut='o',typ='R',val_min=0.E+0),
             NU_M            =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=0.5+0),
             E_F             =SIMP(statut='f',typ='R',val_min=0.E+0),
             NU_F            =SIMP(statut='f',typ='R',val_min=0.E+0,val_max=0.5+0),
             BT1             =SIMP(statut='f',typ='R',val_min=0.E+0),
             BT2             =SIMP(statut='f',typ='R',val_min=0.E+0,val_max=0.5+0),
             RHO             =SIMP(statut='f',typ='R',val_min=0.E+0),
             ALPHA           =SIMP(statut='f',typ='R'),
             AMOR_ALPHA      =SIMP(statut='f',typ='R'),
             AMOR_BETA       =SIMP(statut='f',typ='R'),
             AMOR_HYST       =SIMP(statut='f',typ='R'),
           ),
           ELAS_GLRC_FO     =FACT(statut='f',
             regles=(PRESENT_PRESENT('ALPHA','TEMP_DEF_ALPHA'),
                     PRESENT_PRESENT('BT1','BT2'),),
             E_M             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_M            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             E_F             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU_F            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BT1             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BT2             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             TEMP_DEF_ALPHA  =SIMP(statut='f',typ='R'),
             ALPHA           =SIMP(statut='f',typ=(fonction_sdaster,formule)),
             AMOR_ALPHA      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_BETA       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AMOR_HYST       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ELAS_DHRC     =FACT(statut='f',
             A0            =SIMP(statut='o',typ='R',min=21,max=21),

             RHO             =SIMP(statut='f',typ='R',val_min=0.E+0),
             ALPHA           =SIMP(statut='f',typ='R'),
             AMOR_ALPHA      =SIMP(statut='f',typ='R'),
             AMOR_BETA       =SIMP(statut='f',typ='R'),
             AMOR_HYST       =SIMP(statut='f',typ='R'),
           ),
           CABLE           =FACT(statut='f',
             EC_SUR_E        =SIMP(statut='f',typ='R',defaut= 1.E-4 ),
           ),
#
# comportements mécanique non linéaire
# vérification du domaine de validité
           VERI_BORNE      =FACT(statut='f',
             regles=(ENSEMBLE('TEMP_MAXI','TEMP_MINI'),
                     ),
             EPSI_MAXI       =SIMP(statut='f',typ='R'),
             TEMP_MAXI       =SIMP(statut='f',typ='R'),
             TEMP_MINI       =SIMP(statut='f',typ='R'),
             VEPS_MAXI       =SIMP(statut='f',typ='R'),
           ),
           TRACTION        =FACT(statut='f',
             SIGM            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),

           ),
           ECRO_LINE       =FACT(statut='f',
             D_SIGM_EPSI     =SIMP(statut='o',typ='R',),
             SY              =SIMP(statut='o',typ='R',),
             SIGM_LIM        =SIMP(statut='f',typ='R'),
             EPSI_LIM        =SIMP(statut='f',typ='R'),
           ),
           ENDO_HETEROGENE   =FACT(statut='f',
             WEIBULL         =SIMP(statut='o',typ='R',),
             SY              =SIMP(statut='o',typ='R',),
             KI              =SIMP(statut='o',typ='R',),
             EPAI            =SIMP(statut='o',typ='R',),
             GR              =SIMP(statut='f',typ='R',defaut= 1.0),
           ),
           ECRO_LINE_FO    =FACT(statut='f',
             D_SIGM_EPSI     =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SY              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ECRO_PUIS       =FACT(statut='f',
             SY              =SIMP(statut='o',typ='R',),
             A_PUIS          =SIMP(statut='o',typ='R',val_min=0.0),
             N_PUIS          =SIMP(statut='o',typ='R',val_min=1.E-6),
           ),
           ECRO_PUIS_FO    =FACT(statut='f',
             SY              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_PUIS          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             N_PUIS          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ECRO_COOK       =FACT(statut='f',
             regles=(PRESENT_PRESENT('C','EPSP0'),
                     PRESENT_PRESENT('TROOM','TMELT','M_PUIS'),),
             A               =SIMP(statut='o',typ='R',val_min=0.0),
             B               =SIMP(statut='o',typ='R',val_min=0.0),
             C               =SIMP(statut='f',typ='R',val_min=0.0),
             N_PUIS          =SIMP(statut='o',typ='R',val_min=0.0),
             M_PUIS          =SIMP(statut='f',typ='R',val_min=0.0),
             EPSP0           =SIMP(statut='f',typ='R',val_min=1.E-6),
             TROOM           =SIMP(statut='f',typ='R',val_min=0.0),
             TMELT           =SIMP(statut='f',typ='R',val_min=0.0),
           ),
           ECRO_COOK_FO       =FACT(statut='f',
             regles=(PRESENT_PRESENT('C','EPSP0'),
                     PRESENT_PRESENT('TROOM','TMELT','M_PUIS'),),
             A               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C               =SIMP(statut='f',typ='R',val_min=0.0),
             N_PUIS          =SIMP(statut='o',typ='R',val_min=0.0),
             M_PUIS          =SIMP(statut='f',typ='R',val_min=0.0),
             EPSP0           =SIMP(statut='f',typ='R',val_min=1.E-6),
             TROOM           =SIMP(statut='f',typ='R',val_min=0.0),
             TMELT           =SIMP(statut='f',typ='R',val_min=0.0),
           ),
           BETON_ECRO_LINE =FACT(statut='f',
             D_SIGM_EPSI     =SIMP(statut='o',typ='R'),
             SYT             =SIMP(statut='o',typ='R'),
             SYC             =SIMP(statut='f',typ='R'),
           ),
           BETON_REGLE_PR =FACT(statut='f',
             D_SIGM_EPSI     =SIMP(statut='o',typ='R'),
             SYT             =SIMP(statut='o',typ='R'),
             SYC             =SIMP(statut='f',typ='R'),
             EPSC            =SIMP(statut='f',typ='R'),
             N               =SIMP(statut='f',typ='R'),
           ),
           ENDO_ORTH_BETON  =FACT(statut='f',
             ALPHA            =SIMP(statut='f',typ='R',defaut=0.9),
             K0               =SIMP(statut='o',typ='R'),
             K1               =SIMP(statut='o',typ='R'),
             K2               =SIMP(statut='f',typ='R',defaut=7.E-4),
             ECROB            =SIMP(statut='o',typ='R'),
             ECROD            =SIMP(statut='o',typ='R'),
           ),
           PRAGER          =FACT(statut='f',
             C               =SIMP(statut='o',typ='R'),
           ),
           PRAGER_FO       =FACT(statut='f',
             C               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           TAHERI          =FACT(statut='f',
             R_0             =SIMP(statut='o',typ='R'),
             ALPHA           =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
             A               =SIMP(statut='o',typ='R'),
             B               =SIMP(statut='o',typ='R'),
             C1              =SIMP(statut='o',typ='R'),
             C_INF           =SIMP(statut='o',typ='R'),
             S               =SIMP(statut='o',typ='R'),
           ),
           TAHERI_FO       =FACT(statut='f',
             R_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALPHA           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C1              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_INF           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             S               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ROUSSELIER      =FACT(statut='f',
             D               =SIMP(statut='o',typ='R'),
             SIGM_1          =SIMP(statut='o',typ='R'),
             PORO_INIT       =SIMP(statut='o',typ='R'),
             PORO_CRIT       =SIMP(statut='f',typ='R',defaut= 1. ),
             PORO_ACCE       =SIMP(statut='f',typ='R',defaut= 1. ),
             PORO_LIMI       =SIMP(statut='f',typ='R',defaut= 0.999 ),
             D_SIGM_EPSI_NORM=SIMP(statut='f',typ='R',defaut= 1. ),
             AN              =SIMP(statut='f',typ='R',defaut= 0. ),
             DP_MAXI         =SIMP(statut='f',typ='R',defaut= 0.1),
             BETA            =SIMP(statut='f',typ='R',defaut=0.85),
             PORO_TYPE       =SIMP(statut='f',typ='R',defaut=1.,fr=tr("choix de la modélisation de la porosité : 1 = IMPLICITE, 2 = EXPLICITE")),
           ),
           ROUSSELIER_FO   =FACT(statut='f',
             D               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_1          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PORO_INIT       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PORO_CRIT       =SIMP(statut='f',typ='R',defaut= 1. ),
             PORO_ACCE       =SIMP(statut='f',typ='R',defaut= 1. ),
             PORO_LIMI       =SIMP(statut='f',typ='R',defaut= 0.999 ),
             D_SIGM_EPSI_NORM=SIMP(statut='f',typ='R',defaut= 1. ),
             AN              =SIMP(statut='f',typ='R',defaut= 0. ),
             DP_MAXI         =SIMP(statut='f',typ='R',defaut= 0.1),
             BETA            =SIMP(statut='f',typ='R',defaut=0.85),
             PORO_TYPE       =SIMP(statut='f',typ='R',defaut=1.,fr=tr("choix de la modelisation de la porosite : 1 = IMPLICITE, 2 = EXPLICITE")),
           ),
           VISC_SINH      =FACT(statut='f',
             SIGM_0          =SIMP(statut='o',typ='R'),
             EPSI_0          =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
           ),
           VISC_SINH_FO      =FACT(statut='f',
             SIGM_0          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             EPSI_0          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           CIN1_CHAB  =FACT(statut='f',
             R_0             =SIMP(statut='o',typ='R'),
             R_I             =SIMP(statut='f',typ='R'),
             B               =SIMP(statut='f',typ='R',defaut= 0.0E+0),
             C_I             =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='f',typ='R',defaut= 1.0E+0),
             W               =SIMP(statut='f',typ='R',defaut= 0.0E+0),
             G_0             =SIMP(statut='o',typ='R'),
             A_I             =SIMP(statut='f',typ='R',defaut= 1.0E+0),
           ),
           CIN1_CHAB_FO  =FACT(statut='f',
             R_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             W               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           CIN2_CHAB  =FACT(statut='f',
             R_0             =SIMP(statut='o',typ='R'),
             R_I             =SIMP(statut='f',typ='R'),
             B               =SIMP(statut='f',typ='R',defaut= 0.E+0),
             C1_I            =SIMP(statut='o',typ='R'),
             C2_I            =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='f',typ='R',defaut= 1.),
             W               =SIMP(statut='f',typ='R',defaut= 0.E+0),
             G1_0            =SIMP(statut='o',typ='R'),
             G2_0            =SIMP(statut='o',typ='R'),
             A_I             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
           ),
           CIN2_CHAB_FO  =FACT(statut='f',
             R_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C1_I            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C2_I            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             W               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G1_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G2_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           CIN2_NRAD  =FACT(statut='f',
             DELTA1          =SIMP(statut='f',typ='R',defaut= 1.E+0,val_min=0.E+0, val_max=1.E+0),
             DELTA2          =SIMP(statut='f',typ='R',defaut= 1.E+0,val_min=0.E+0, val_max=1.E+0),
           ),
           MEMO_ECRO       =FACT(statut='f',
             MU              =SIMP(statut='o',typ='R'),
             Q_M             =SIMP(statut='o',typ='R'),
             Q_0             =SIMP(statut='o',typ='R'),
             ETA             =SIMP(statut='f',typ='R',defaut= 0.5E+0 ),
           ),
           MEMO_ECRO_FO        =FACT(statut='f',
             MU              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q_M             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ETA             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           VISCOCHAB       =FACT(statut='f',
             K_0             =SIMP(statut='o',typ='R'),
             A_K             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             A_R             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             K               =SIMP(statut='o',typ='R'),
             N               =SIMP(statut='o',typ='R'),
             ALP             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             B               =SIMP(statut='o',typ='R'),
             M_R             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             G_R             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             MU              =SIMP(statut='o',typ='R',defaut= 0.E+0 ),
             Q_M             =SIMP(statut='o',typ='R'),
             Q_0             =SIMP(statut='o',typ='R'),
             QR_0            =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             ETA             =SIMP(statut='f',typ='R',defaut= 0.5E+0 ),
             C1              =SIMP(statut='o',typ='R'),
             M_1             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             D1              =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             G_X1            =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             G1_0            =SIMP(statut='o',typ='R'),
             C2              =SIMP(statut='o',typ='R'),
             M_2             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             D2              =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             G_X2            =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             G2_0            =SIMP(statut='o',typ='R'),
             A_I             =SIMP(statut='f',typ='R',defaut= 1.E+0 ),
             ORDRE_PARAM     =SIMP(statut='c',typ='TXM', max='**', defaut=("K_0","A_K","A_R","K","N",
                              "ALP","B","M_R","G_R","MU","Q_M","Q_0","QR_0","ETA","C1","M_1","D1",
                              "G_X1","G1_0","C2","M_2","D2","G_X2","G2_0","A_I",)),
           ),
           VISCOCHAB_FO    =FACT(statut='f',
             K_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_K             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_R             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             N               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALP             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_R             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_R             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             MU              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q_M             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q_0             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             QR_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ETA             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C1              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_1             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D1              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_X1            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G1_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C2              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_2             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D2              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G_X2            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             G2_0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_I             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ORDRE_PARAM     =SIMP(statut='c',typ='TXM', max='**', defaut=("K_0","A_K","A_R","K","N",
                              "ALP","B","M_R","G_R","MU","Q_M","Q_0","QR_0","ETA","C1","M_1","D1",
                              "G_X1","G1_0","C2","M_2","D2","G_X2","G2_0","A_I",)),
           ),
           LEMAITRE        =FACT(statut='f',
             N               =SIMP(statut='o',typ='R'),
             UN_SUR_K        =SIMP(statut='o',typ='R'),
             UN_SUR_M        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           LEMAITRE_IRRA    =FACT(statut='f',
             N               =SIMP(statut='o',typ='R'),
             UN_SUR_K        =SIMP(statut='o',typ='R'),
             UN_SUR_M        =SIMP(statut='o',typ='R',),
             QSR_K           =SIMP(statut='o',typ='R',),
             BETA            =SIMP(statut='o',typ='R',),
             PHI_ZERO        =SIMP(statut='o',typ='R',),
             L               =SIMP(statut='o',typ='R',),
             GRAN_FO         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
          VISC_IRRA_LOG    =FACT(statut='f',
             A               =SIMP(statut='o',typ='R',),
             B               =SIMP(statut='o',typ='R',),
             CSTE_TPS        =SIMP(statut='o',typ='R',),
             ENER_ACT        =SIMP(statut='o',typ='R',),
           ),
          GRAN_IRRA_LOG    =FACT(statut='f',
             A               =SIMP(statut='o',typ='R',),
             B               =SIMP(statut='o',typ='R',),
             C               =SIMP(statut='o',typ='R',),
             CSTE_TPS        =SIMP(statut='o',typ='R',),
             ENER_ACT        =SIMP(statut='o',typ='R',),
             GRAN_FO         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
          LEMA_SEUIL   =FACT(statut='f',
             A               =SIMP(statut='o',typ='R',),
             S               =SIMP(statut='o',typ='R',),
           ),
          LEMA_SEUIL_FO=FACT(statut='f',
             A               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             S               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
         IRRAD3M=FACT(statut='f',
               R02      =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
               EPSI_U   =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
               RM       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
               AI0      =SIMP(statut='o',typ='R',val_min=0.0),
               ZETA_F   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
               ETAI_S   =SIMP(statut='o',typ='R',val_min=0.0),
               RG0      =SIMP(statut='o',typ='R',val_min=0.0),
               ALPHA    =SIMP(statut='o',typ='R',val_min=0.0),
               PHI0     =SIMP(statut='o',typ='R',val_min=0.0),
               KAPPA    =SIMP(statut='f',typ='R',val_min=0.0,defaut=0.8,val_max=1.0),
               ZETA_G   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
               TOLER_ET =SIMP(statut='f',typ='R',val_min=0.0,defaut=0.15 ),
         ),
           LEMAITRE_FO     =FACT(statut='f',
             N               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             UN_SUR_K        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             UN_SUR_M        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
             META_LEMA_ANI     =FACT(statut='f',
             regles=(PRESENT_PRESENT('F_MRR_RR','C_MRR_RR','F_MTT_TT','C_MTT_TT',
                                     'F_MZZ_ZZ','C_MZZ_ZZ','F_MRT_RT','C_MRT_RT',
                                     'F_MRZ_RZ','C_MRZ_RZ','F_MTZ_TZ','C_MTZ_TZ'),
                     PRESENT_PRESENT('F_MXX_XX','C_MXX_XX','F_MYY_YY','C_MYY_YY',
                                     'F_MZZ_ZZ','C_MZZ_ZZ','F_MXY_XY','C_MXY_XY',
                                     'F_MXZ_XZ','C_MXZ_XZ','F_MYZ_YZ','C_MYZ_YZ'),
                     EXCLUS('F_MRR_RR','F_MXX_XX'),),
             F1_A            =SIMP(statut='o',typ='R'),
             F2_A            =SIMP(statut='o',typ='R'),
             C_A             =SIMP(statut='o',typ='R'),
             F1_M            =SIMP(statut='o',typ='R'),
             F2_M            =SIMP(statut='o',typ='R'),
             C_M             =SIMP(statut='o',typ='R'),
             F1_N            =SIMP(statut='o',typ='R'),
             F2_N            =SIMP(statut='o',typ='R'),
             C_N             =SIMP(statut='o',typ='R'),
             F1_Q            =SIMP(statut='o',typ='R'),
             F2_Q            =SIMP(statut='o',typ='R'),
             C_Q             =SIMP(statut='o',typ='R'),
             F_MRR_RR        =SIMP(statut='f',typ='R'),
             C_MRR_RR        =SIMP(statut='f',typ='R'),
             F_MTT_TT        =SIMP(statut='f',typ='R'),
             C_MTT_TT        =SIMP(statut='f',typ='R'),
             F_MZZ_ZZ        =SIMP(statut='f',typ='R'),
             C_MZZ_ZZ        =SIMP(statut='f',typ='R'),
             F_MRT_RT        =SIMP(statut='f',typ='R'),
             C_MRT_RT        =SIMP(statut='f',typ='R'),
             F_MRZ_RZ        =SIMP(statut='f',typ='R'),
             C_MRZ_RZ        =SIMP(statut='f',typ='R'),
             F_MTZ_TZ        =SIMP(statut='f',typ='R'),
             C_MTZ_TZ        =SIMP(statut='f',typ='R'),
             F_MXX_XX        =SIMP(statut='f',typ='R'),
             C_MXX_XX        =SIMP(statut='f',typ='R'),
             F_MYY_YY        =SIMP(statut='f',typ='R'),
             C_MYY_YY        =SIMP(statut='f',typ='R'),
             F_MXY_XY        =SIMP(statut='f',typ='R'),
             C_MXY_XY        =SIMP(statut='f',typ='R'),
             F_MXZ_XZ        =SIMP(statut='f',typ='R'),
             C_MXZ_XZ        =SIMP(statut='f',typ='R'),
             F_MYZ_YZ        =SIMP(statut='f',typ='R'),
             C_MYZ_YZ        =SIMP(statut='f',typ='R'),
           ),
             META_LEMA_ANI_FO  =FACT(statut='f',
             regles=(PRESENT_PRESENT('F_MRR_RR','C_MRR_RR','F_MTT_TT','C_MTT_TT',
                                     'F_MZZ_ZZ','C_MZZ_ZZ','F_MRT_RT','C_MRT_RT',
                                     'F_MRZ_RZ','C_MRZ_RZ','F_MTZ_TZ','C_MTZ_TZ'),
                     PRESENT_PRESENT('F_MXX_XX','C_MXX_XX','F_MYY_YY','C_MYY_YY',
                                     'F_MZZ_ZZ','C_MZZ_ZZ','F_MXY_XY','C_MXY_XY',
                                     'F_MXZ_XZ','C_MXZ_XZ','F_MYZ_YZ','C_MYZ_YZ'),
                     EXCLUS('F_MRR_RR','F_MXX_XX'),),
             F1_A            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_A            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_A             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_M            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_M            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_M             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_N            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_N            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_N             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_Q            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_Q            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_Q             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MRR_RR        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MRR_RR        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MTT_TT        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MTT_TT        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MZZ_ZZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MZZ_ZZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MRT_RT        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MRT_RT        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MRZ_RZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MRZ_RZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MTZ_TZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MTZ_TZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MXX_XX        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MXX_XX        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MYY_YY        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MYY_YY        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MXY_XY        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MXY_XY        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MXZ_XZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MXZ_XZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_MYZ_YZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_MYZ_YZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ARME            =FACT(statut='f',
             KYE             =SIMP(statut='o',typ='R'),
             DLE             =SIMP(statut='o',typ='R'),
             KYP             =SIMP(statut='o',typ='R'),
             DLP             =SIMP(statut='o',typ='R'),
             KYG             =SIMP(statut='o',typ='R'),
           ),
           ASSE_CORN       =FACT(statut='f',
             NU_1            =SIMP(statut='o',typ='R'),
             MU_1            =SIMP(statut='o',typ='R'),
             DXU_1           =SIMP(statut='o',typ='R'),
             DRYU_1          =SIMP(statut='o',typ='R'),
             C_1             =SIMP(statut='o',typ='R'),
             NU_2            =SIMP(statut='o',typ='R'),
             MU_2            =SIMP(statut='o',typ='R'),
             DXU_2           =SIMP(statut='o',typ='R'),
             DRYU_2          =SIMP(statut='o',typ='R'),
             C_2             =SIMP(statut='o',typ='R'),
             KY              =SIMP(statut='o',typ='R'),
             KZ              =SIMP(statut='o',typ='R'),
             KRX             =SIMP(statut='o',typ='R'),
             KRZ             =SIMP(statut='o',typ='R'),
             R_P0            =SIMP(statut='f',typ='R',defaut= 1.E+4 ),
           ),
           DIS_CONTACT     =FACT(statut='f',
             RIGI_NOR        =SIMP(statut='f',typ='R' ),
             RIGI_TAN        =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             AMOR_NOR        =SIMP(statut='f',typ='R' ),
             AMOR_TAN        =SIMP(statut='f',typ='R' ),
             COULOMB         =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             DIST_1          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             DIST_2          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             JEU             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           ENDO_SCALAIRE   =FACT(statut='f',
             K               =SIMP(statut='o',typ='R',val_min=0.0),
             P               =SIMP(statut='o',typ='R',val_min=1.0),
             Q               =SIMP(statut='f',typ='R',defaut=0.0),
             M               =SIMP(statut='o',typ='R',),
             C_COMP          =SIMP(statut='f',typ='R',defaut=0.0),
             C_VOLU          =SIMP(statut='f',typ='R',defaut=1.0,val_min=0.0),
             COEF_RIGI_MINI  =SIMP(statut='f',typ='R',defaut=1.E-5),
           ),
           ENDO_SCALAIRE_FO =FACT(statut='f',
             K               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             P               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q               =SIMP(statut='f',typ='R',defaut=0.0),
             M               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_COMP          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_VOLU          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COEF_RIGI_MINI  =SIMP(statut='f',typ='R',defaut=1.E-5),
           ),
           ENDO_FISS_EXP    =FACT(statut='f',
             K               =SIMP(statut='o',typ='R',val_min=0.0),
             P               =SIMP(statut='o',typ='R',val_min=1.0),
             Q               =SIMP(statut='f',typ='R',defaut=0.0),
             M               =SIMP(statut='o',typ='R',),
             TAU             =SIMP(statut='o',typ='R'),
             SIG0            =SIMP(statut='o',typ='R'),
             BETA            =SIMP(statut='f',typ='R',defaut=0.1),
             REST_RIGIDITE   =SIMP(statut='o',typ='R',val_min=0.0),
             COEF_RIGI_MINI  =SIMP(statut='f',typ='R',defaut=1.E-5),
           ),
           ENDO_FISS_EXP_FO =FACT(statut='f',
             K               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             P               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             Q               =SIMP(statut='f',typ='R',defaut=0.0),
             M               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             TAU             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIG0            =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BETA            =SIMP(statut='f',typ='R',defaut=0.1),
             REST_RIGIDITE   =SIMP(statut='o',typ='R',val_min=0.0),
             COEF_RIGI_MINI  =SIMP(statut='f',typ='R',defaut=1.E-5),
           ),
           DIS_GRICRA    =FACT(statut='f',
             KN_AX       =SIMP(statut='o',typ='R' ),
             KT_AX       =SIMP(statut='o',typ='R' ),
             COUL_AX     =SIMP(statut='o',typ='R' ),
             F_SER       =SIMP(statut='f',typ='R' ),
             F_SER_FO    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ET_AX       =SIMP(statut='f',typ='R',defaut=1.e-7 ),
             ET_ROT      =SIMP(statut='f',typ='R',defaut=1.e-7 ),
             ANG1        =SIMP(statut='f',typ='R' ),
             ANG2        =SIMP(statut='f',typ='R' ),
             ANG3        =SIMP(statut='f',typ='R' ),
             PEN1        =SIMP(statut='f',typ='R' ),
             PEN2        =SIMP(statut='f',typ='R' ),
             PEN3        =SIMP(statut='f',typ='R' ),
             PEN4        =SIMP(statut='f',typ='R' ),
             ANG1_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ANG2_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ANG3_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PEN1_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PEN2_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PEN3_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PEN4_FO     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             regles=(EXCLUS('ANG1','ANG1_FO',),
                     UN_PARMI('ANG1','ANG1_FO',),
                     EXCLUS('F_SER','F_SER_FO',),
                     UN_PARMI('F_SER','F_SER_FO',),
                     PRESENT_PRESENT('ANG1','ANG2','ANG3','PEN1','PEN2','PEN3','PEN4'),
                     PRESENT_PRESENT('ANG1_FO','ANG2_FO','ANG3_FO','PEN1_FO','PEN2_FO','PEN3_FO','PEN4_FO'),
                                     ),
           ),
           BETON_DOUBLE_DP =FACT(statut='f',
             F_C             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_T             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COEF_BIAX       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ENER_COMP_RUPT  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ENER_TRAC_RUPT  =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COEF_ELAS_COMP  =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=100.E+0),
             LONG_CARA       =SIMP(statut='f',typ='R',val_min=0.E+0),
             ECRO_COMP_P_PIC =SIMP(statut='f',typ='TXM',defaut="LINEAIRE",into=("LINEAIRE","PARABOLE") ),
             ECRO_TRAC_P_PIC =SIMP(statut='f',typ='TXM',defaut="LINEAIRE",into=("LINEAIRE","EXPONENT") ),
           ),
         MAZARS=FACT(statut='f',
             EPSD0           =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='o',typ='R'),
             AC              =SIMP(statut='o',typ='R'),
             BC              =SIMP(statut='o',typ='R'),
             AT              =SIMP(statut='o',typ='R'),
             BT              =SIMP(statut='o',typ='R'),
             CHI             =SIMP(statut='f',typ='R',val_min=0.0E+0,val_max=1.0E+0),
             SIGM_LIM        =SIMP(statut='f',typ='R'),
             EPSI_LIM        =SIMP(statut='f',typ='R'),
           ),
         MAZARS_FO=FACT(statut='f',
             EPSD0           =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AC              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BC              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AT              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BT              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CHI             =SIMP(statut='f',typ='R'),
           ),
         JOINT_BA=FACT(statut='f',max=1,
             HPEN            =SIMP(statut='o',typ='R',defaut= 1.E+0,val_min=0.E+0),
             GTT             =SIMP(statut='o',typ='R',val_min=0.E+0),
             GAMD0           =SIMP(statut='o',typ='R',val_min=1.E-4,val_max=1.E-1),
             AD1             =SIMP(statut='o',typ='R',val_min=0.E+0),
             BD1             =SIMP(statut='o',typ='R',defaut= 5.E-1,val_min=1.E-1),
             GAMD2           =SIMP(statut='o',typ='R',val_min=1.E-4,val_max=1.E+0),
             AD2             =SIMP(statut='o',typ='R',val_min=0.E+0),
             BD2             =SIMP(statut='o',typ='R',defaut= 1.E+0,val_min=1.E-1),
             VIFROT          =SIMP(statut='o',typ='R',val_min=0.E+0),
             FA              =SIMP(statut='o',typ='R',val_min=0.E+0),
             FC              =SIMP(statut='o',typ='R',val_min=0.E+0),
             EPSTR0          =SIMP(statut='o',typ='R',val_min=1.E-4,val_max=1.E+0),
             ADN             =SIMP(statut='o',typ='R',val_min=0.E+0),
             BDN             =SIMP(statut='o',typ='R',defaut= 1.E+0,val_min=1.E-1),
           ),
          VENDOCHAB       =FACT(statut='f',
             SY              =SIMP(statut='o',typ='R',defaut= 0.E+0),
             ALPHA_D         =SIMP(statut='o',typ='R',defaut= 0.E+0),
             BETA_D          =SIMP(statut='o',typ='R',defaut= 0.E+0),
             R_D             =SIMP(statut='o',typ='R'),
             A_D             =SIMP(statut='o',typ='R'),
             K_D             =SIMP(statut='o',typ='R'),
           ),
           VENDOCHAB_FO    =FACT(statut='f',
             SY              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             ALPHA_D         =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BETA_D          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R_D             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_D             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             K_D             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
          HAYHURST     =FACT(statut='f',
             EPS0         =SIMP(statut='o',typ='R'),
             K            =SIMP(statut='o',typ='R'),
             H1           =SIMP(statut='o',typ='R'),
             H2           =SIMP(statut='o',typ='R'),
             DELTA1       =SIMP(statut='o',typ='R'),
             DELTA2       =SIMP(statut='o',typ='R'),
             H1ST         =SIMP(statut='o',typ='R'),
             H2ST         =SIMP(statut='o',typ='R'),
             KC           =SIMP(statut='f',typ='R',defaut=0.),
             BIGA         =SIMP(statut='o',typ='R'),
             SIG0         =SIMP(statut='o',typ='R'),
             ALPHAD       =SIMP(statut='f',typ='R',defaut=0.),
             S_EQUI_D     =SIMP(statut='f',typ='R',defaut=0.,into=(0.,1.) ),
           ),
           VISC_ENDO      =FACT(statut='f',
             SY              =SIMP(statut='o',typ='R',defaut= 0.E+0),
             R_D             =SIMP(statut='o',typ='R'),
             A_D             =SIMP(statut='o',typ='R'),
           ),
           VISC_ENDO_FO   =FACT(statut='f',
             SY              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             R_D             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_D             =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           PINTO_MENEGOTTO =FACT(statut='f',
             SY              =SIMP(statut='o',typ='R'),
             EPSI_ULTM       =SIMP(statut='o',typ='R'),
             SIGM_ULTM       =SIMP(statut='o',typ='R'),
             ELAN            =SIMP(statut='f',typ='R',defaut= 4. ),
             EPSP_HARD       =SIMP(statut='o',typ='R'),
             R_PM            =SIMP(statut='f',typ='R',defaut= 20. ),
             EP_SUR_E        =SIMP(statut='f',typ='R'),
             A1_PM           =SIMP(statut='f',typ='R',defaut= 18.5 ),
             A2_PM           =SIMP(statut='f',typ='R',defaut= 0.15 ),
             A6_PM           =SIMP(statut='f',typ='R',defaut= 620. ),
             C_PM            =SIMP(statut='f',typ='R',defaut= 0.5 ),
             A_PM            =SIMP(statut='f',typ='R',defaut= 6.0E-3 ),
           ),
           BPEL_BETON      =FACT(statut='f',
             PERT_FLUA       =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             PERT_RETR       =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           BPEL_ACIER      =FACT(statut='f',
            regles=(PRESENT_PRESENT('RELAX_1000','F_PRG',),
                     PRESENT_PRESENT('MU0_RELAX','F_PRG',),),
             RELAX_1000      =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             MU0_RELAX       =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             F_PRG           =SIMP(statut='f',typ='R'),
             FROT_COURB      =SIMP(statut='f',typ='R',defaut=0.E+0),
             FROT_LINE       =SIMP(statut='f',typ='R',defaut=0.E+0),
           ),
          ETCC_BETON      =FACT(statut='f',
            EP_BETON           =SIMP(statut='f',typ='R',val_min=0.E+0,defaut=0. ),
           ),
          ETCC_ACIER      =FACT(statut='f',
            regles=(PRESENT_PRESENT('RELAX_1000','F_PRG',),),
             F_PRG           =SIMP(statut='f',typ='R',val_min=0.E+0),
             COEF_FROT       =SIMP(statut='f',typ='R',defaut=0.E+0,val_min=0.E+0),
             PERT_LIGNE     =SIMP(statut='f',typ='R',defaut=0.E+0,val_min=0.E+0),
             RELAX_1000      =SIMP(statut='f',typ='R',defaut= 0.E+0,val_min=0.E+0 ),


           ),
           MOHR_COULOMB  =FACT(statut='f',
               PHI         =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=60.E+0,),
               ANGDIL      =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=60.E+0,),
               COHESION    =SIMP(statut='o',typ='R',val_min=0.E+0,),
             ),

           RANKINE  =FACT(statut='f',
               SIGMA_T    =SIMP(statut='o',typ='R',),
             ),

           CAM_CLAY      =FACT(statut='f',
             MU              =SIMP(statut='o',typ='R'),
             PORO            =SIMP(statut='o',typ='R'),
             LAMBDA          =SIMP(statut='o',typ='R'),
             KAPA            =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
             PRES_CRIT       =SIMP(statut='o',typ='R'),
             KCAM            =SIMP(statut='f',typ='R',val_min=0.E+0),
             PTRAC           =SIMP(statut='f',typ='R',val_max=0.E+0),
               regles=(PRESENT_PRESENT('PTRAC','KCAM',),),
           ),
           BARCELONE      =FACT(statut='f',
             MU              =SIMP(statut='o',typ='R'),
             PORO            =SIMP(statut='o',typ='R'),
             LAMBDA          =SIMP(statut='o',typ='R'),
             KAPA            =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
             PRES_CRIT       =SIMP(statut='o',typ='R'),
             PA            =SIMP(statut='o',typ='R'),
             R             =SIMP(statut='o',typ='R'),
             BETA          =SIMP(statut='o',typ='R'),
             KC            =SIMP(statut='o',typ='R'),
             PC0_INIT      =SIMP(statut='o',typ='R'),
             KAPAS         =SIMP(statut='o',typ='R'),
             LAMBDAS       =SIMP(statut='o',typ='R'),
             ALPHAB        =SIMP(statut='f',typ='R'),
           ),
           CJS             =FACT(statut='f',
             BETA_CJS        =SIMP(statut='o',typ='R'),
             RM              =SIMP(statut='o',typ='R'),
             N_CJS           =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             KP              =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             RC              =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             A_CJS           =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             B_CJS           =SIMP(statut='f',typ='R',defaut= 1.0E+25 ),
             C_CJS           =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             GAMMA_CJS       =SIMP(statut='o',typ='R'),
             MU_CJS          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             PCO             =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             PA              =SIMP(statut='o',typ='R'),
             Q_INIT          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
             R_INIT          =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           HUJEUX   =FACT(statut='f',
             N      =SIMP(statut='o',typ='R' ),
             BETA   =SIMP(statut='o',typ='R' ),
             B      =SIMP(statut='o',typ='R' ),
             D      =SIMP(statut='o',typ='R' ),
             PHI    =SIMP(statut='o',typ='R' ),
             ANGDIL =SIMP(statut='o',typ='R' ),
             PCO    =SIMP(statut='o',typ='R' ),
             PREF   =SIMP(statut='o',typ='R' ),
             ACYC   =SIMP(statut='o',typ='R' ),
             AMON   =SIMP(statut='o',typ='R' ),
             CCYC   =SIMP(statut='o',typ='R' ),
             CMON   =SIMP(statut='o',typ='R' ),
             RD_ELA =SIMP(statut='o',typ='R' ),
             RI_ELA =SIMP(statut='o',typ='R' ),
             RHYS   =SIMP(statut='o',typ='R' ),
             RMOB   =SIMP(statut='o',typ='R' ),
             XM     =SIMP(statut='o',typ='R' ),
             RD_CYC =SIMP(statut='o',typ='R' ),
             RI_CYC =SIMP(statut='o',typ='R' ),
             DILA   =SIMP(statut='o',typ='R' ),
             PTRAC  =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
           ),
           ECRO_ASYM_LINE  =FACT(statut='f',
             DC_SIGM_EPSI    =SIMP(statut='o',typ='R'),
             SY_C            =SIMP(statut='o',typ='R'),
             DT_SIGM_EPSI    =SIMP(statut='o',typ='R'),
             SY_T            =SIMP(statut='o',typ='R'),
           ),
           BETON_GRANGER      =FACT(statut='f',
                 J1              =SIMP(statut='f',typ='R'),
                 J2              =SIMP(statut='f',typ='R'),
                 J3              =SIMP(statut='f',typ='R'),
                 J4              =SIMP(statut='f',typ='R'),
                 J5              =SIMP(statut='f',typ='R'),
                 J6              =SIMP(statut='f',typ='R'),
                 J7              =SIMP(statut='f',typ='R'),
                 J8              =SIMP(statut='f',typ='R'),
                 TAUX_1          =SIMP(statut='f',typ='R'),
                 TAUX_2          =SIMP(statut='f',typ='R'),
                 TAUX_3          =SIMP(statut='f',typ='R'),
                 TAUX_4          =SIMP(statut='f',typ='R'),
                 TAUX_5          =SIMP(statut='f',typ='R'),
                 TAUX_6          =SIMP(statut='f',typ='R'),
                 TAUX_7          =SIMP(statut='f',typ='R'),
                 TAUX_8          =SIMP(statut='f',typ='R'),
           ),
           V_BETON_GRANGER    =FACT(statut='f',
                FONC_V          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           BETON_BURGER   =FACT(statut='f',
             K_RS            =SIMP(statut='o',typ='R'),
             ETA_RS          =SIMP(statut='o',typ='R'),
             KAPPA           =SIMP(statut='o',typ='R'),
             ETA_IS          =SIMP(statut='o',typ='R'),
             K_RD            =SIMP(statut='o',typ='R'),
             ETA_RD          =SIMP(statut='o',typ='R'),
             ETA_ID          =SIMP(statut='o',typ='R'),
             QSR_K           =SIMP(statut='o',typ='R'),
             TEMP_0_C        =SIMP(statut='o',typ='R'),
             ETA_FD          =SIMP(statut='f',typ='R'),
           ),
           BETON_UMLV   =FACT(statut='f',
             K_RS            =SIMP(statut='o',typ='R'),
             ETA_RS          =SIMP(statut='o',typ='R'),
             K_IS            =SIMP(statut='o',typ='R'),
             ETA_IS          =SIMP(statut='o',typ='R'),
             K_RD            =SIMP(statut='o',typ='R'),
             ETA_RD          =SIMP(statut='o',typ='R'),
             ETA_ID          =SIMP(statut='o',typ='R'),
             ETA_FD          =SIMP(statut='f',typ='R'),
           ),
           BETON_RAG    =FACT(statut='f',
             ACTIV_FL        =SIMP(statut='f',typ='R',defaut=1.0 ),
             K_RS            =SIMP(statut='o',typ='R'),
             K_IS            =SIMP(statut='o',typ='R'),
             ETA_RS          =SIMP(statut='o',typ='R'),
             ETA_IS          =SIMP(statut='o',typ='R'),
             K_RD            =SIMP(statut='o',typ='R'),
             K_ID            =SIMP(statut='o',typ='R'),
             ETA_RD          =SIMP(statut='o',typ='R'),
             ETA_ID          =SIMP(statut='o',typ='R'),
             EPS_0           =SIMP(statut='o',typ='R'),
             TAU_0           =SIMP(statut='o',typ='R'),
             EPS_FL_L        =SIMP(statut='f',typ='R',defaut=3.0e-2 ),
             ACTIV_LO        =SIMP(statut='f',typ='R',defaut=1.0 ),
             F_C             =SIMP(statut='o',typ='R'),
             F_T             =SIMP(statut='o',typ='R'),
             ANG_CRIT        =SIMP(statut='f',typ='R',defaut=8.594367 ),
             EPS_COMP        =SIMP(statut='o',typ='R'),
             EPS_TRAC        =SIMP(statut='o',typ='R'),
             LC_COMP         =SIMP(statut='o',typ='R',defaut=1.0  ),
             LC_TRAC         =SIMP(statut='o',typ='R',defaut=1.0  ),
             HYD_PRES        =SIMP(statut='f',typ='R',defaut=0.   ),
             A_VAN_GE        =SIMP(statut='f',typ='R',defaut=0.0  ),
             B_VAN_GE        =SIMP(statut='f',typ='R',defaut=1.9  ),
             BIOT_EAU        =SIMP(statut='o',typ='R',defaut=0.3  ),
             MODU_EAU        =SIMP(statut='o',typ='R',defaut=0.0  ),
             W_EAU_0         =SIMP(statut='o',typ='R'),
             BIOT_GEL        =SIMP(statut='o',typ='R'),
             MODU_GEL        =SIMP(statut='o',typ='R'),
             VOL_GEL         =SIMP(statut='o',typ='R'),
             AVANC_LI        =SIMP(statut='o',typ='R'),
             SEUIL_SR        =SIMP(statut='o',typ='R'),
             PARA_CIN        =SIMP(statut='o',typ='R'),
             ENR_AC_G        =SIMP(statut='o',typ='R'),
           ),

             PORO_BETON      =FACT(statut='f',
             HYDS            =SIMP(statut='o',typ='R'),
             F_C               =SIMP(statut='f',typ='R'),
             F_T              =SIMP(statut='f',typ='R'),
             EPS_COMP             =SIMP(statut='f',typ='R'),
             EPS_TRAC             =SIMP(statut='f',typ='R'),
             EKVP            =SIMP(statut='f',typ='R'),
             CBIO            =SIMP(statut='f',typ='R'),
             MODU_EAU        =SIMP(statut='f',typ='R'),
             SFLD            =SIMP(statut='f',typ='R'),
             MODU_GEL        =SIMP(statut='f',typ='R'),
             VOL_GEL         =SIMP(statut='f',typ='R'),
             PORO            =SIMP(statut='o',typ='R'),
             TKVP            =SIMP(statut='f',typ='R'),
             NRJA            =SIMP(statut='f',typ='R'),
             MSHR            =SIMP(statut='f',typ='R'),
             KD              =SIMP(statut='f',typ='R'),
             MU              =SIMP(statut='f',typ='R'),
             DT80            =SIMP(statut='o',typ='R'),
             STMP            =SIMP(statut='f',typ='R'),
             KTMP            =SIMP(statut='f',typ='R'),
             TREF            =SIMP(statut='f',typ='R'),
             Y1SY            =SIMP(statut='f',typ='R'),
             TAU1            =SIMP(statut='f',typ='R'),
             TAU2            =SIMP(statut='f',typ='R'),
             EKFL            =SIMP(statut='f',typ='R'),
             DFMX            =SIMP(statut='f',typ='R'),
             GFTL            =SIMP(statut='f',typ='R'),
             GFCL            =SIMP(statut='f',typ='R'),
             WREF            =SIMP(statut='f',typ='R'),
             TPHI            =SIMP(statut='f',typ='R'),
             ANG_CRIT        =SIMP(statut='f',typ='R'),
             SREF            =SIMP(statut='f',typ='R'),
             VREF            =SIMP(statut='f',typ='R'),
             VMAX            =SIMP(statut='f',typ='R'),
             KWB             =SIMP(statut='f',typ='R'),
             COVS            =SIMP(statut='f',typ='R'),
             ALUC            =SIMP(statut='f',typ='R'),
             SULC            =SIMP(statut='f',typ='R'),
             SILC            =SIMP(statut='f',typ='R'),
             TDEF            =SIMP(statut='f',typ='R'),
             TAAR            =SIMP(statut='f',typ='R'),
             SSAR            =SIMP(statut='f',typ='R'),
             SSDE            =SIMP(statut='f',typ='R'),
             VAAR            =SIMP(statut='f',typ='R'),
             VETT            =SIMP(statut='f',typ='R'),
             VVAR            =SIMP(statut='f',typ='R'),
             VVDE            =SIMP(statut='f',typ='R'),
             BAAR            =SIMP(statut='f',typ='R'),
             BDEF            =SIMP(statut='f',typ='R'),
             MAAR            =SIMP(statut='f',typ='R'),
             MDEF            =SIMP(statut='f',typ='R'),
             COTH            =SIMP(statut='f',typ='R'),
             CORG            =SIMP(statut='f',typ='R'),
             ID0             =SIMP(statut='f',typ='R'),
             ID1             =SIMP(statut='f',typ='R'),
             ID2             =SIMP(statut='f',typ='R'),
            ),

           GLRC_DM         =FACT(statut='f',max=1,
             GAMMA_T         =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=1.E+0),
             GAMMA_C         =SIMP(statut='f',typ='R',val_min=-1.E+0,val_max=1.E+0),
             GAMMA_F         =SIMP(statut='o',typ='R',val_min=-1.E+0,val_max=1.E+0),
             NYT             =SIMP(statut='o',typ='R',val_min=0.E+0),
             NYC             =SIMP(statut='f',typ='R'),
             MYF             =SIMP(statut='o',typ='R',val_min=0.E+0),
             ALPHA_C         =SIMP(statut='f',typ='R',val_min=1.E+0,defaut=1.E+0),
           ),
           DHRC            =FACT(statut='f',
             NYD           =SIMP(statut='o',typ='R',min=2,max=2),
             SCRIT         =SIMP(statut='o',typ='R',min=4,max=4),

             AA_C          =SIMP(statut='o',typ='R',min=42,max=42),
             AA_T          =SIMP(statut='o',typ='R',min=42,max=42),
             GA_C          =SIMP(statut='o',typ='R',min=42,max=42),
             GA_T          =SIMP(statut='o',typ='R',min=42,max=42),

             AB            =SIMP(statut='o',typ='R',min=24,max=24),
             GB            =SIMP(statut='o',typ='R',min=24,max=24),

             C0            =SIMP(statut='o',typ='R',min=8,max=8),
             AC            =SIMP(statut='o',typ='R',min=8,max=8),
             GC            =SIMP(statut='o',typ='R',min=8,max=8),

           ),
           CORR_ACIER   =FACT(statut='f',max=1,
             D_CORR           =SIMP(statut='o',typ='R'),
             ECRO_K           =SIMP(statut='o',typ='R'),
             ECRO_M           =SIMP(statut='o',typ='R'),
             SY              =SIMP(statut='o',typ='R'),
             ),
           CABLE_GAINE_FROT=FACT(statut='f',max=1,
             TYPE = SIMP(statut='o',typ='TXM',into=("FROTTANT","GLISSANT","ADHERENT")),
             b_glissant =BLOC(condition="""equal_to("TYPE", 'GLISSANT')""",
                                    fr=tr("Loi cable gaine glissante"),
                     FROT_LINE         =SIMP(statut='c',typ='R',defaut= 0.0,),
                     FROT_COURB       =SIMP(statut='c',typ='R',defaut= 0.0,),
             ),
             b_adherent =BLOC(condition="""equal_to("TYPE", 'ADHERENT')""",
                                    fr=tr("Loi cable gaine adherent"),
                     FROT_LINE         =SIMP(statut='c',typ='R',defaut= -1.0,),
                     FROT_COURB       =SIMP(statut='c',typ='R',defaut= 0.0,),
             ),
             b_frottant =BLOC(condition="""equal_to("TYPE", 'FROTTANT')""",
                                    fr=tr("Loi cable gaine frottant"),
                     FROT_LINE         =SIMP(statut='o',typ='R',defaut= 0.0,),
                     FROT_COURB       =SIMP(statut='o',typ='R',defaut= 0.0,),
             ),
             PENA_LAGR       =SIMP(statut='o',typ='R',val_min=0.E+0),
             ),

# Discrets non-linéaires : début
         DIS_ECRO_CINE  =FACT(statut='f',
            fr=tr("Loi pour les discrets avec écrouissage cinématique."),
            regles=(PRESENT_PRESENT('LIMY_DX','KCIN_DX',),PRESENT_PRESENT('PUIS_DX','LIMU_DX',),
                    PRESENT_PRESENT('LIMY_DY','KCIN_DY',),PRESENT_PRESENT('PUIS_DY','LIMU_DY',),
                    PRESENT_PRESENT('LIMY_DZ','KCIN_DZ',),PRESENT_PRESENT('PUIS_DZ','LIMU_DZ',),
                    PRESENT_PRESENT('LIMY_RX','KCIN_RX',),PRESENT_PRESENT('PUIS_RX','LIMU_RX',),
                    PRESENT_PRESENT('LIMY_RY','KCIN_RY',),PRESENT_PRESENT('PUIS_RY','LIMU_RY',),
                    PRESENT_PRESENT('LIMY_RZ','KCIN_RZ',),PRESENT_PRESENT('PUIS_RZ','LIMU_RZ',),),
            LIMY_DX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Effort limite élastique suivant l'axe local x de l'élément.")),
            LIMY_DY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Effort limite élastique suivant l'axe local y de l'élément.")),
            LIMY_DZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Effort limite élastique suivant l'axe local z de l'élément.")),
            LIMY_RX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Moment limite élastique suivant l'axe local x de l'élément.")),
            LIMY_RY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Moment limite élastique suivant l'axe local y de l'élément.")),
            LIMY_RZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Moment limite élastique suivant l'axe local z de l'élément.")),
            KCIN_DX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Raideur suivant l'axe local x de l'élément.")),
            KCIN_DY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Raideur suivant l'axe local y de l'élément.")),
            KCIN_DZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Raideur suivant l'axe local z de l'élément.")),
            KCIN_RX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Raideur suivant l'axe local Rx de l'élément.")),
            KCIN_RY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Raideur suivant l'axe local Ry de l'élément.")),
            KCIN_RZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Raideur suivant l'axe local Rz de l'élément.")),
            LIMU_DX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Effort limite suivant l'axe local x de l'élément.")),
            LIMU_DY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Effort limite suivant l'axe local y de l'élément.")),
            LIMU_DZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Effort limite suivant l'axe local z de l'élément.")),
            LIMU_RX =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Moment limite suivant l'axe local x de l'élément.")),
            LIMU_RY =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Moment limite suivant l'axe local y de l'élément.")),
            LIMU_RZ =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Moment limite suivant l'axe local z de l'élément.")),
            PUIS_DX =SIMP(statut='f',typ='R',val_min = 1.0,
               fr=tr("Coefficient de non-linéarité suivant l'axe local x de l'élément.")),
            PUIS_DY =SIMP(statut='f',typ='R',val_min = 1.0,
               fr=tr("Coefficient de non-linéarité suivant l'axe local y de l'élément.")),
            PUIS_DZ =SIMP(statut='f',typ='R',val_min = 1.0,
               fr=tr("Coefficient de non-linéarité suivant l'axe local z de l'élément.")),
            PUIS_RX =SIMP(statut='f',typ='R',val_min = 1.0,
               fr=tr("Coefficient de non-linéarité suivant l'axe local Rx de l'élément.")),
            PUIS_RY =SIMP(statut='f',typ='R',val_min = 1.0,
               fr=tr("Coefficient de non-linéarité suivant l'axe local Ry de l'élément.")),
            PUIS_RZ =SIMP(statut='f',typ='R',val_min = 1.0,
               fr=tr("Coefficient de non-linéarité suivant l'axe local Rz de l'élément.")),
         ),
         DIS_VISC =FACT(statut='f',
            fr=tr("Loi pour un discret de type visqueux : Zener Généralisé."),
            regles=(UN_PARMI('K1','UNSUR_K1'),
                    UN_PARMI('K2','UNSUR_K2'),
                    UN_PARMI('K3','UNSUR_K3'), ),
            K1          =SIMP(statut='f',typ='R',val_min = 1.0E-08,
               fr=tr("Raideur en série avec les 2 autres branches.")),
            K2          =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Raideur en parallèle de la branche visqueuse.")),
            K3          =SIMP(statut='f',typ='R',val_min = 1.0E-08,
               fr=tr("Raideur dans la branche visqueuse.")),
            UNSUR_K1    =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Souplesse en série avec les 2 autres branches.")),
            UNSUR_K2    =SIMP(statut='f',typ='R',val_min = 1.0E-08,
               fr=tr("Souplesse en parallèle de la branche visqueuse.")),
            UNSUR_K3    =SIMP(statut='f',typ='R',val_min = 0.0,
               fr=tr("Souplesse dans la branche visqueuse.")),
            C           =SIMP(statut='o',typ='R',val_min = 1.0E-08,
               fr=tr("'Raideur' de la partie visqueuse.")),
            PUIS_ALPHA  =SIMP(statut='o',typ='R',val_min = 1.0E-08, val_max=1.0, defaut=0.5,
               fr=tr("Puissance de la loi visqueuse ]0.0, 1.0] .")),
         ),
         DIS_ECRO_TRAC =FACT(statut='f',
            fr=tr("Loi pour un discret avec écrouissage isotrope ."),
            FX=SIMP(statut='o',typ=(fonction_sdaster),
               fr=tr("Comportement en fonction du déplacement relatif."),),
        ),
         DIS_BILI_ELAS  =FACT(statut='f',
            fr=tr("Loi bi-linéaire pour les discrets."),
            regles=(PRESENT_PRESENT('KDEB_DX','KFIN_DX','FPRE_DX',),
                    PRESENT_PRESENT('KDEB_DY','KFIN_DY','FPRE_DY',),
                    PRESENT_PRESENT('KDEB_DZ','KFIN_DZ','FPRE_DZ',),),
            KDEB_DX =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr=tr("Raideur début suivant l'axe local x de l'élément.")),
            KDEB_DY =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr=tr("Raideur début suivant l'axe local y de l'élément.")),
            KDEB_DZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr=tr("Raideur début  suivant l'axe local z de l'élément.")),
            KFIN_DX =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr=tr("Raideur fin l'axe local x de l'élément.")),
            KFIN_DY =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr=tr("Raideur fin l'axe local y de l'élément.")),
            KFIN_DZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),
               fr=tr("Raideur fin l'axe local z de l'élément.")),
            FPRE_DX =SIMP(statut='f',typ='R',
               fr=tr("Effort de préserrage suivant l'axe local x de l'élément.")),
            FPRE_DY =SIMP(statut='f',typ='R',
               fr=tr("Effort de préserrage suivant l'axe local y de l'élément.")),
            FPRE_DZ =SIMP(statut='f',typ='R',
               fr=tr("Effort de préserrage suivant l'axe local z de l'élément.")),
         ),
# Discrets non-linéaires : fin
#
# comportement thermique
#
           THER_NL         =FACT(statut='f',
             regles=(UN_PARMI('BETA','RHO_CP', ),),
             LAMBDA          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BETA            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO_CP          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           THER_HYDR       =FACT(statut='f',
             LAMBDA          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             BETA            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             AFFINITE        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CHALHYDR        =SIMP(statut='o',typ='R'),
           ),
           THER            =FACT(statut='f',
             LAMBDA          =SIMP(statut='o',typ='R'),
             RHO_CP          =SIMP(statut='f',typ='R'),
           ),
           THER_FO         =FACT(statut='f',
             LAMBDA          =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO_CP          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           THER_ORTH       =FACT(statut='f',
             LAMBDA_L        =SIMP(statut='o',typ='R'),
             LAMBDA_T        =SIMP(statut='o',typ='R'),
             LAMBDA_N        =SIMP(statut='f',typ='R'),
             RHO_CP          =SIMP(statut='f',typ='R'),
           ),
           THER_COQUE      =FACT(statut='f',
             COND_LMM        =SIMP(statut='o',typ='R'),
             COND_TMM        =SIMP(statut='o',typ='R'),
             COND_LMP        =SIMP(statut='o',typ='R'),
             COND_TMP        =SIMP(statut='o',typ='R'),
             COND_LPP        =SIMP(statut='o',typ='R'),
             COND_TPP        =SIMP(statut='o',typ='R'),
             COND_LSI        =SIMP(statut='o',typ='R'),
             COND_TSI        =SIMP(statut='o',typ='R'),
             COND_NMM        =SIMP(statut='o',typ='R'),
             COND_NMP        =SIMP(statut='o',typ='R'),
             COND_NPP        =SIMP(statut='o',typ='R'),
             COND_NSI        =SIMP(statut='o',typ='R'),
             CMAS_MM         =SIMP(statut='f',typ='R'),
             CMAS_MP         =SIMP(statut='f',typ='R'),
             CMAS_PP         =SIMP(statut='f',typ='R'),
             CMAS_SI         =SIMP(statut='f',typ='R'),
           ),
           THER_COQUE_FO   =FACT(statut='f',
             COND_LMM        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_TMM        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_LMP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_TMP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_LPP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_TPP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_LSI        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_TSI        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_NMM        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_NMP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_NPP        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COND_NSI        =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CMAS_MM         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CMAS_MP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CMAS_PP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CMAS_SI         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           SECH_GRANGER    =FACT(statut='f',
             A               =SIMP(statut='o',typ='R'),
             B               =SIMP(statut='o',typ='R'),
             QSR_K           =SIMP(statut='o',typ='R'),
             TEMP_0_C        =SIMP(statut='o',typ='R'),
           ),
           SECH_MENSI      =FACT(statut='f',
             A               =SIMP(statut='o',typ='R'),
             B               =SIMP(statut='o',typ='R'),
           ),
           SECH_BAZANT     =FACT(statut='f',
             D1              =SIMP(statut='o',typ='R'),
             ALPHA_BAZANT    =SIMP(statut='o',typ='R'),
             N               =SIMP(statut='o',typ='R'),
             FONC_DESORP     =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           SECH_NAPPE      =FACT(statut='f',
             FONCTION        =SIMP(statut='o',typ=(nappe_sdaster,formule)),
           ),
#
# comportement métallurgique
#
           META_ACIER      =FACT(statut='f',
             TRC             =SIMP(statut='o',typ=(table_sdaster) ),
             AR3             =SIMP(statut='o',typ='R'),
             ALPHA           =SIMP(statut='o',typ='R'),
             MS0             =SIMP(statut='o',typ='R'),
             AC1             =SIMP(statut='o',typ='R'),
             AC3             =SIMP(statut='o',typ='R'),
             TAUX_1          =SIMP(statut='o',typ='R'),
             TAUX_3          =SIMP(statut='o',typ='R'),
             LAMBDA0         =SIMP(statut='f',typ='R'),
             QSR_K           =SIMP(statut='f',typ='R'),
             D10             =SIMP(statut='f',typ='R'),
             WSR_K           =SIMP(statut='f',typ='R'),
           ),
           META_ZIRC       =FACT(statut='f',
             TDEQ            =SIMP(statut='o',typ='R'),
             N               =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='o',typ='R'),
             T1C             =SIMP(statut='o',typ='R'),
             T2C             =SIMP(statut='o',typ='R'),
             AC              =SIMP(statut='o',typ='R'),
             M               =SIMP(statut='o',typ='R'),
             QSR_K           =SIMP(statut='o',typ='R'),
             T1R             =SIMP(statut='o',typ='R'),
             T2R             =SIMP(statut='o',typ='R'),
             AR              =SIMP(statut='o',typ='R'),
             BR              =SIMP(statut='o',typ='R'),
           ),
           DURT_META       =FACT(statut='f',
             F1_DURT         =SIMP(statut='o',typ='R'),
             F2_DURT         =SIMP(statut='o',typ='R'),
             F3_DURT         =SIMP(statut='o',typ='R'),
             F4_DURT         =SIMP(statut='o',typ='R'),
             C_DURT          =SIMP(statut='o',typ='R'),
           ),
           ELAS_META       =FACT(statut='f',
             E               =SIMP(statut='o',typ='R'),
             NU              =SIMP(statut='o',typ='R'),
             F_ALPHA         =SIMP(statut='o',typ='R'),
             C_ALPHA         =SIMP(statut='o',typ='R'),
             PHASE_REFE      =SIMP(statut='o',typ='TXM',into=("CHAUD","FROID")),
             EPSF_EPSC_TREF  =SIMP(statut='o',typ='R'),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.0E+0),
             F1_SY           =SIMP(statut='f',typ='R'),
             F2_SY           =SIMP(statut='f',typ='R'),
             F3_SY           =SIMP(statut='f',typ='R'),
             F4_SY           =SIMP(statut='f',typ='R'),
             C_SY            =SIMP(statut='f',typ='R'),
             SY_MELANGE      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_S_VP         =SIMP(statut='f',typ='R'),
             F2_S_VP         =SIMP(statut='f',typ='R'),
             F3_S_VP         =SIMP(statut='f',typ='R'),
             F4_S_VP         =SIMP(statut='f',typ='R'),
             C_S_VP          =SIMP(statut='f',typ='R' ),
             S_VP_MELANGE    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           ELAS_META_FO    =FACT(statut='f',
             regles=(
                      PRESENT_PRESENT('F_ALPHA','TEMP_DEF_ALPHA'),
                      PRESENT_PRESENT('C_ALPHA','TEMP_DEF_ALPHA'),
                    ),
             E               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             NU              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F_ALPHA         =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_ALPHA         =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PHASE_REFE      =SIMP(statut='o',typ='TXM',into=("CHAUD","FROID")),
             EPSF_EPSC_TREF  =SIMP(statut='o',typ='R'),
             TEMP_DEF_ALPHA  =SIMP(statut='f',typ='R'),
             PRECISION       =SIMP(statut='f',typ='R',defaut= 1.0E+0),
             F1_SY           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_SY           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_SY           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_SY           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_SY            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SY_MELANGE      =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_S_VP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_S_VP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_S_VP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_S_VP         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_S_VP          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             S_VP_MELANGE    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           META_ECRO_LINE  =FACT(statut='f',
             F1_D_SIGM_EPSI  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_D_SIGM_EPSI  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_D_SIGM_EPSI  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_D_SIGM_EPSI  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_D_SIGM_EPSI   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           META_TRACTION   =FACT(statut='f',
             SIGM_F1         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_F2         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_F3         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_F4         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_C          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           META_VISC_FO    =FACT(statut='f',
             F1_ETA          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_N            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_C            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F1_M            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_ETA          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_N            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_C            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_M            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_ETA          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_N            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_C            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_M            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_ETA          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_N            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_C            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_M            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_ETA           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_N             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_C             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             C_M             =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           META_PT         =FACT(statut='f',
             F1_K            =SIMP(statut='f',typ='R'),
             F2_K            =SIMP(statut='f',typ='R'),
             F3_K            =SIMP(statut='f',typ='R'),
             F4_K            =SIMP(statut='f',typ='R'),
             F1_D_F_META     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F2_D_F_META     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F3_D_F_META     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             F4_D_F_META     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           META_RE         =FACT(statut='f',
             C_F1_THETA      =SIMP(statut='f',typ='R'),
             C_F2_THETA      =SIMP(statut='f',typ='R'),
             C_F3_THETA      =SIMP(statut='f',typ='R'),
             C_F4_THETA      =SIMP(statut='f',typ='R'),
             F1_C_THETA      =SIMP(statut='f',typ='R'),
             F2_C_THETA      =SIMP(statut='f',typ='R'),
             F3_C_THETA      =SIMP(statut='f',typ='R'),
             F4_C_THETA      =SIMP(statut='f',typ='R'),
           ),
#
# comportement fluide
#
           FLUIDE          =FACT(statut='f',
             regles=(EXCLUS('CELE_C','CELE_R'),),
             RHO             =SIMP(statut='o',typ='R'),
             PESA_Z          =SIMP(statut='f',typ='R',min=1,max=1),
             CELE_C          =SIMP(statut='f',typ='C'),
             CELE_R          =SIMP(statut='f',typ='R'),
           ),
# =================================================================================
# COMPORTEMENT THERMO_HYDRO_MECANIQUE
# LES DONNEES NECESSAIRES A LA DEFINITION DU MATERIAU SONT DEPENDANTES
# DE LA LOI DE COUPLAGE THM DE LA RELATION
# LE COMPORTEMENT DE COUPLAGE COMP_THM N EST VALABLE QUE POUR LES LOIS
# DE COUPLAGE : LIQU_SATU,LIQU_GAZ,GAZ,LIQU_GAZ_ATM,LIQU_VAPE_GAZ,LIQU_VAPE
# ET LIQU_AD_GAZ_VAPE
# LA CORRESPONDANCE AVEC LES VARIABLES CACHEES EST LA SUIVANTE :
# 1 -->  LIQU_SATU
# 2 -->  GAZ
# 3 -->  LIQU_VAPE
# 4 -->  LIQU_VAPE_GAZ
# 5 -->  LIQU_GAZ
# 6 -->  LIQU_GAZ_ATM
# 9 -->  LIQU_AD_GAZ_VAPE
# 10 -->  LIQU_AD_GAZ
# =================================================================================
           COMP_THM        = SIMP(statut='f', typ='TXM',
                                  into = ( "LIQU_SATU"     ,
                                           "LIQU_GAZ"      ,
                                           "GAZ"           ,
                                           "LIQU_GAZ_ATM"  ,
                                           "LIQU_VAPE_GAZ" ,
                                           "LIQU_VAPE"     ,
                                           "LIQU_AD_GAZ_VAPE" ,
                                           "LIQU_AD_GAZ" ,
                                          ) ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_SATU -------------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU -----------------------------------------------
# =================================================================================
           b_liqusatu      = BLOC(condition = """equal_to("COMP_THM", 'LIQU_SATU') """,
                                 fr=tr("Paramètres nécessaires pour une loi de couplage de type LIQU_SATU"),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1          = SIMP(statut='o',typ='R'),
                                           PORO          = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP          = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE2          = SIMP(statut='f',typ='R'),
                                           PRES_VAPE     = SIMP(statut='f',typ='R'),
                                           DEGR_SATU     = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 1.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
                                  regles = (EXCLUS('BIOT_COEF','BIOT_N',),
                                            PRESENT_PRESENT('BIOT_N','BIOT_L',),
                                            PRESENT_PRESENT('BIOT_T','BIOT_L','BIOT_N',),

                                            EXCLUS('PERM_IN','PERM_END','PERMIN_L',),
                                            PRESENT_ABSENT('PERMIN_N','PERMIN_T',),
                                            PRESENT_PRESENT('PERMIN_N','PERMIN_L',),
                                            PRESENT_PRESENT('PERMIN_T','PERMIN_L',),


                                            EXCLUS('LAMB_T','LAMB_TL',),
                                            PRESENT_ABSENT('LAMB_TN','LAMB_TT',),
                                            PRESENT_PRESENT('LAMB_TN','LAMB_TL',),
                                            PRESENT_PRESENT('LAMB_TT','LAMB_TL',),


                                            EXCLUS('D_LB_T','D_LB_TL',),
                                            PRESENT_ABSENT('D_LB_TN','D_LB_TT',),
                                            PRESENT_PRESENT('D_LB_TN','D_LB_TL',),

                                            EXCLUS('LAMB_CT','LAMB_C_L',),
                                            PRESENT_ABSENT('LAMB_C_N','LAMB_C_T',),
                                            PRESENT_PRESENT('LAMB_C_N','LAMB_C_L',),
                                            PRESENT_PRESENT('LAMB_C_T','LAMB_C_L',),

                                            EXCLUS('PERMIN_L','BIOT_COEF'),
                                            EXCLUS('PERMIN_L','LAMB_T'),
                                            PRESENT_PRESENT('BIOT_L','PERMIN_L',),
                                            PRESENT_PRESENT('BIOT_T','PERMIN_T',),
                                            PRESENT_PRESENT('LAMB_TN','PERMIN_N',),
                                            PRESENT_PRESENT('LAMB_TL','PERMIN_L',),
                                            PRESENT_PRESENT('LAMB_TT','PERMIN_T',),

                                            ),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO           = SIMP(statut='o',typ='R'),
                                           BIOT_COEF     = SIMP(statut='f',typ='R'),
                                           BIOT_L        = SIMP(statut='f',typ='R'),
                                           BIOT_N        = SIMP(statut='f',typ='R'),
                                           BIOT_T        = SIMP(statut='f',typ='R'),
                                           PESA_X        = SIMP(statut='o',typ='R'),
                                           PESA_Y        = SIMP(statut='o',typ='R'),
                                           PESA_Z        = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP          = SIMP(statut='f',typ='R'),
                                           PERM_IN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_L    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_N    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_T    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT     = SIMP(statut='f',typ='R'),
                                           LAMB_C_L   = SIMP(statut='f',typ='R'),
                                           LAMB_C_N   = SIMP(statut='f',typ='R'),
                                           LAMB_C_T   = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ         = SIMP(statut='f',typ='R'),
                                           EMMAG           = SIMP(statut='f',typ='R'),
                                           SATU_PRES       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU=SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO           = SIMP(statut='o',typ='R'),
                                           UN_SUR_K      = SIMP(statut='o',typ='R'),
                                           VISC          = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP   = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CP            = SIMP(statut='f',typ='R'),
                                         ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_GAZ         =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_VAPE_GAZ    =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_GAZ --------------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_GAZ --------------------------------------
# =================================================================================
           b_liqugaz      = BLOC(condition = """equal_to("COMP_THM", 'LIQU_GAZ') """,
                                 fr=tr("Paramètres nécessaires pour une loi de couplage de type LIQU_GAZ"),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PRE2             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           PRES_VAPE        = SIMP(statut='f',typ='R'),
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 5.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
                                  regles = (EXCLUS('BIOT_COEF','BIOT_N',),
                                            PRESENT_PRESENT('BIOT_N','BIOT_L',),
                                            PRESENT_PRESENT('BIOT_T','BIOT_L','BIOT_N',),
                                            EXCLUS('PERM_IN','PERM_END','PERMIN_L',),
                                            PRESENT_ABSENT('PERMIN_N','PERMIN_T',),
                                            PRESENT_PRESENT('PERMIN_N','PERMIN_L',),
                                            PRESENT_PRESENT('PERMIN_T','PERMIN_L',),
                                            EXCLUS('LAMB_T','LAMB_TL',),
                                            PRESENT_ABSENT('LAMB_TN','LAMB_TT',),
                                            PRESENT_PRESENT('LAMB_TN','LAMB_TL',),
                                            PRESENT_PRESENT('LAMB_TT','LAMB_TL',),
                                            EXCLUS('D_LB_T','D_LB_TL',),
                                            PRESENT_ABSENT('D_LB_TN','D_LB_TT',),
                                            PRESENT_PRESENT('D_LB_TN','D_LB_TL',),
                                            PRESENT_PRESENT('D_LB_TT','D_LB_TL',),
                                            EXCLUS('LAMB_CT','LAMB_C_L',),
                                            PRESENT_ABSENT('LAMB_C_N','LAMB_C_T',),
                                            PRESENT_PRESENT('LAMB_C_N','LAMB_C_L',),
                                            PRESENT_PRESENT('LAMB_C_T','LAMB_C_L',),

                                            EXCLUS('PERMIN_L','BIOT_COEF'),
                                            EXCLUS('PERMIN_L','LAMB_T'),
                                            PRESENT_PRESENT('BIOT_L','PERMIN_L',),
                                            PRESENT_PRESENT('BIOT_T','PERMIN_T',),
                                            PRESENT_PRESENT('LAMB_TN','PERMIN_N',),
                                            PRESENT_PRESENT('LAMB_TL','PERMIN_L',),
                                            PRESENT_PRESENT('LAMB_TT','PERMIN_T',),
                                           ENSEMBLE('SATU_PRES','D_SATU_PRES','PERM_LIQU','D_PERM_LIQU_SATU',
                                                            'PERM_GAZ','D_PERM_SATU_GAZ','D_PERM_PRES_GAZ',),
                                           ENSEMBLE('VG_N','VG_SR','VG_PR','VG_SMAX','VG_SATUR',),
                                           UN_PARMI('VG_N','SATU_PRES'),
                                           ),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='f',typ='R'),
                                           BIOT_L           = SIMP(statut='f',typ='R'),
                                           BIOT_N           = SIMP(statut='f',typ='R'),
                                           BIOT_T           = SIMP(statut='f',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---Van Genhuchten et Muallen-----------------------------------------------------------------------------

                                           VG_N    = SIMP(statut='f',typ='R'),
                                           VG_SR    = SIMP(statut='f',typ='R'),
                                           VG_PR   = SIMP(statut='f',typ='R'),
                                           VG_SMAX = SIMP(statut='f',typ='R'),
                                           VG_SATUR = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
#
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP          = SIMP(statut='f',typ='R'),
                                           PERM_IN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_L    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_N    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_T    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT     = SIMP(statut='f',typ='R'),
                                           LAMB_C_L   = SIMP(statut='f',typ='R'),
                                           LAMB_C_N   = SIMP(statut='f',typ='R'),
                                           LAMB_C_T   = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG           = SIMP(statut='f',typ='R'),
                                           FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL        = SIMP(statut='o',typ='R'),
                                           VISC            = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP     = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP              = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_VAPE_GAZ    =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE GAZ -------------------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_GAZ ------------------------------------------------
# =================================================================================
           b_gaz          = BLOC(condition = """equal_to("COMP_THM", 'GAZ') """,
                                 fr=tr("Paramètres nécessaires pour une loi de couplage de type GAZ"),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='o',typ='R'),
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE2             = SIMP(statut='f',typ='R'),
                                           PRES_VAPE        = SIMP(statut='f',typ='R'),
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 2.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
                                  regles = (EXCLUS('BIOT_COEF','BIOT_N',),
                                            PRESENT_PRESENT('BIOT_N','BIOT_L',),
                                            PRESENT_PRESENT('BIOT_T','BIOT_L','BIOT_N',),
                                            EXCLUS('PERM_IN','PERM_END','PERMIN_L',),
                                            PRESENT_ABSENT('PERMIN_N','PERMIN_T',),
                                            PRESENT_PRESENT('PERMIN_N','PERMIN_L',),
                                            PRESENT_PRESENT('PERMIN_T','PERMIN_L',),
                                            EXCLUS('LAMB_T','LAMB_TL',),
                                            PRESENT_ABSENT('LAMB_TN','LAMB_TT',),
                                            PRESENT_PRESENT('LAMB_TN','LAMB_TL',),
                                            PRESENT_PRESENT('LAMB_TT','LAMB_TL',),
                                            EXCLUS('D_LB_T','D_LB_TL',),
                                            PRESENT_ABSENT('D_LB_TN','D_LB_TT',),
                                            PRESENT_PRESENT('D_LB_TN','D_LB_TL',),
                                            PRESENT_PRESENT('D_LB_TT','D_LB_TL',),
                                            EXCLUS('LAMB_CT','LAMB_C_L',),
                                            PRESENT_ABSENT('LAMB_C_N','LAMB_C_T',),
                                            PRESENT_PRESENT('LAMB_C_N','LAMB_C_L',),
                                            PRESENT_PRESENT('LAMB_C_T','LAMB_C_L',),
                                            EXCLUS('PERMIN_L','BIOT_COEF'),
                                            EXCLUS('PERMIN_L','LAMB_T'),
                                            PRESENT_PRESENT('BIOT_L','PERMIN_L',),
                                            PRESENT_PRESENT('BIOT_T','PERMIN_T',),
                                            PRESENT_PRESENT('LAMB_TN','PERMIN_N',),
                                            PRESENT_PRESENT('LAMB_TL','PERMIN_L',),
                                            PRESENT_PRESENT('LAMB_TT','PERMIN_T',),
                                            ),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='f',typ='R'),
                                           BIOT_L           = SIMP(statut='f',typ='R'),
                                           BIOT_N           = SIMP(statut='f',typ='R'),
                                           BIOT_T           = SIMP(statut='f',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP          = SIMP(statut='f',typ='R'),
                                           PERM_IN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_L    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_N    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_T    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT     = SIMP(statut='f',typ='R'),
                                           LAMB_C_L   = SIMP(statut='f',typ='R'),
                                           LAMB_C_N   = SIMP(statut='f',typ='R'),
                                           LAMB_C_T   = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG           = SIMP(statut='f',typ='R'),
                                           SATU_PRES       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU       =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU=SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_LIQU        =FACT(statut='f',
             RHO             =SIMP(statut='f',typ='R'),
             UN_SUR_K        =SIMP(statut='f',typ='R'),
             ALPHA           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             COEF_HENRY      =SIMP(statut='f',typ='R'),
           ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_VAPE_GAZ    =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_GAZ_ATM ----------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_GAZ --------------------------------------
# =================================================================================
           b_liqugazatm   = BLOC(condition = """equal_to("COMP_THM", 'LIQU_GAZ_ATM') """,
                                 fr=tr("Paramètres nécessaires pour une loi de couplage de type LIQU_GAZ_ATM"),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE2             = SIMP(statut='f',typ='R'),
                                           PRES_VAPE        = SIMP(statut='f',typ='R'),
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 6.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
                                  regles = (EXCLUS('BIOT_COEF','BIOT_N',),
                                            PRESENT_PRESENT('BIOT_N','BIOT_L',),
                                            PRESENT_PRESENT('BIOT_T','BIOT_L','BIOT_N',),
                                            EXCLUS('PERM_IN','PERM_END','PERMIN_L',),
                                            PRESENT_ABSENT('PERMIN_N','PERMIN_T',),
                                            PRESENT_PRESENT('PERMIN_N','PERMIN_L',),
                                            PRESENT_PRESENT('PERMIN_T','PERMIN_L',),
                                            EXCLUS('LAMB_T','LAMB_TL',),
                                            PRESENT_ABSENT('LAMB_TN','LAMB_TT',),
                                            PRESENT_PRESENT('LAMB_TN','LAMB_TL',),
                                            PRESENT_PRESENT('LAMB_TT','LAMB_TL',),
                                            EXCLUS('D_LB_T','D_LB_TL',),
                                            PRESENT_ABSENT('D_LB_TN','D_LB_TT',),
                                            PRESENT_PRESENT('D_LB_TN','D_LB_TL',),
                                            PRESENT_PRESENT('D_LB_TT','D_LB_TL',),
                                            EXCLUS('LAMB_CT','LAMB_C_L',),
                                            PRESENT_ABSENT('LAMB_C_N','LAMB_C_T',),
                                            PRESENT_PRESENT('LAMB_C_N','LAMB_C_L',),
                                            PRESENT_PRESENT('LAMB_C_T','LAMB_C_L',),
                                            EXCLUS('PERMIN_L','BIOT_COEF'),
                                            EXCLUS('PERMIN_L','LAMB_T'),
                                            PRESENT_PRESENT('BIOT_L','PERMIN_L',),
                                            PRESENT_PRESENT('BIOT_T','PERMIN_T',),
                                            PRESENT_PRESENT('LAMB_TN','PERMIN_N',),
                                            PRESENT_PRESENT('LAMB_TL','PERMIN_L',),
                                            PRESENT_PRESENT('LAMB_TT','PERMIN_T',),
                                            ),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='f',typ='R'),
                                           BIOT_L           = SIMP(statut='f',typ='R'),
                                           BIOT_N           = SIMP(statut='f',typ='R'),
                                           BIOT_T           = SIMP(statut='f',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP          = SIMP(statut='f',typ='R'),
                                           PERM_IN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_L    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_N    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_T    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT     = SIMP(statut='f',typ='R'),
                                           LAMB_C_L   = SIMP(statut='f',typ='R'),
                                           LAMB_C_N   = SIMP(statut='f',typ='R'),
                                           LAMB_C_T   = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
             EMMAG           = SIMP(statut='f',typ='R'),
             R_GAZ           =SIMP(statut='f',typ='R'),
             PERM_GAZ        =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_PERM_SATU_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_PERM_PRES_GAZ =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='f',
                                           MASS_MOL         = SIMP(statut='f',typ='R'),
                                           VISC             = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_VAPE_GAZ    =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
                                 ),

# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_AD_GAZ -------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_GAZ,  THM_AIR_DISSOUS---------
# =================================================================================
           b_liquadgaz  = BLOC(condition = """equal_to("COMP_THM", 'LIQU_AD_GAZ') """,
                                 fr=tr("Paramètres nécessaires pour une loi de couplage de type LIQU_AD_GAZ"),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PRE2             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
                                           PRES_VAPE        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 10.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
                                  regles = (EXCLUS('BIOT_COEF','BIOT_N',),
                                            PRESENT_PRESENT('BIOT_N','BIOT_L',),
                                            PRESENT_PRESENT('BIOT_T','BIOT_L','BIOT_N',),
                                            EXCLUS('PERM_IN','PERM_END','PERMIN_L',),
                                            PRESENT_ABSENT('PERMIN_N','PERMIN_T',),
                                            PRESENT_PRESENT('PERMIN_N','PERMIN_L',),
                                            PRESENT_PRESENT('PERMIN_T','PERMIN_L',),
                                            EXCLUS('LAMB_T','LAMB_TL',),
                                            PRESENT_ABSENT('LAMB_TN','LAMB_TT',),
                                            PRESENT_PRESENT('LAMB_TN','LAMB_TL',),
                                            PRESENT_PRESENT('LAMB_TT','LAMB_TL',),
                                            EXCLUS('D_LB_T','D_LB_TL',),
                                            PRESENT_ABSENT('D_LB_TN','D_LB_TT',),
                                            PRESENT_PRESENT('D_LB_TN','D_LB_TL',),
                                            PRESENT_PRESENT('D_LB_TT','D_LB_TL',),
                                            EXCLUS('LAMB_CT','LAMB_C_L',),
                                            PRESENT_ABSENT('LAMB_C_N','LAMB_C_T',),
                                            PRESENT_PRESENT('LAMB_C_N','LAMB_C_L',),
                                            PRESENT_PRESENT('LAMB_C_T','LAMB_C_L',),
                                            EXCLUS('PERMIN_L','BIOT_COEF'),
                                            EXCLUS('PERMIN_L','LAMB_T'),
                                            PRESENT_PRESENT('BIOT_L','PERMIN_L',),
                                            PRESENT_PRESENT('BIOT_T','PERMIN_T',),
                                            PRESENT_PRESENT('LAMB_TN','PERMIN_N',),
                                            PRESENT_PRESENT('LAMB_TL','PERMIN_L',),
                                            PRESENT_PRESENT('LAMB_TT','PERMIN_T',),
                                           ENSEMBLE('SATU_PRES','D_SATU_PRES','PERM_LIQU','D_PERM_LIQU_SATU',
                                                            'PERM_GAZ','D_PERM_SATU_GAZ','D_PERM_PRES_GAZ',),
                                           ENSEMBLE('VG_N','VG_SR','VG_PR','VG_SMAX','VG_SATUR',),
                                           UN_PARMI('VG_N','SATU_PRES'),
                                           ),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='f',typ='R'),
                                           BIOT_L           = SIMP(statut='f',typ='R'),
                                           BIOT_N           = SIMP(statut='f',typ='R'),
                                           BIOT_T           = SIMP(statut='f',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---Van Genhuchten et Muallen-----------------------------------------------------------------------------
                                           VG_N     = SIMP(statut='f',typ='R'),
                                           VG_SR    = SIMP(statut='f',typ='R'),
                                           VG_PR    = SIMP(statut='f',typ='R'),
                                           VG_SMAX  = SIMP(statut='f',typ='R'),
                                           VG_SATUR = SIMP(statut='f',typ='R'),
#
                                           FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP          = SIMP(statut='f',typ='R'),
                                           PERM_IN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_L    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_N    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_T    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT     = SIMP(statut='f',typ='R'),
                                           LAMB_C_L     = SIMP(statut='f',typ='R'),
                                           LAMB_C_N     = SIMP(statut='f',typ='R'),
                                           LAMB_C_T     = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG            = SIMP(statut='f',typ='R'),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
#
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CP               = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                             ),
# =================================================================================
# --- MOT-CLE FACULTATIF ---------------------------------------------------------
# =================================================================================
                             THM_VAPE_GAZ = FACT(statut='f',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           CP               = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES CACHEES -------------------------------------------
# ---------------------------------------------------------------------------------
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_AIR_DISS = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='o',typ='R'),
                                           COEF_HENRY       = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ),
                                 ),

# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_VAPE_GAZ ---------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_GAZ, THM_VAPE_GAZ ------------------------
# =================================================================================
           b_liquvapegaz  = BLOC(condition = """equal_to("COMP_THM", 'LIQU_VAPE_GAZ') """,
                                 fr=tr("Paramètres nécessaires pour une loi de couplage de type LIQU_VAPE_GAZ"),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PRE2             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
                                           PRES_VAPE        = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 4.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='f',typ='R'),
                                           BIOT_L           = SIMP(statut='f',typ='R'),
                                           BIOT_N           = SIMP(statut='f',typ='R'),
                                           BIOT_T           = SIMP(statut='f',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---Van Genhuchten et Muallen-----------------------------------------------------------------------------

                                           VG_N     = SIMP(statut='f',typ='R'),
                                           VG_SR    = SIMP(statut='f',typ='R'),
                                           VG_PR    = SIMP(statut='f',typ='R'),
                                           VG_SMAX  = SIMP(statut='f',typ='R'),
                                           VG_SATUR = SIMP(statut='f',typ='R'),
#
                                           FICKV_T          = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP          = SIMP(statut='f',typ='R'),
                                           PERM_IN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_L    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_N    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_T    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT     = SIMP(statut='f',typ='R'),
                                           LAMB_C_L     = SIMP(statut='f',typ='R'),
                                           LAMB_C_N     = SIMP(statut='f',typ='R'),
                                           LAMB_C_T     = SIMP(statut='f',typ='R'),
#
                                  regles = (EXCLUS('BIOT_COEF','BIOT_N',),
                                            PRESENT_PRESENT('BIOT_N','BIOT_L',),
                                            PRESENT_PRESENT('BIOT_T','BIOT_L','BIOT_N',),
                                            EXCLUS('PERM_IN','PERM_END','PERMIN_L',),
                                            PRESENT_ABSENT('PERMIN_N','PERMIN_T',),
                                            PRESENT_PRESENT('PERMIN_N','PERMIN_L',),
                                            PRESENT_PRESENT('PERMIN_T','PERMIN_L',),
                                            EXCLUS('LAMB_T','LAMB_TL',),
                                            PRESENT_ABSENT('LAMB_TN','LAMB_TT',),
                                            PRESENT_PRESENT('LAMB_TN','LAMB_TL',),
                                            PRESENT_PRESENT('LAMB_TT','LAMB_TL',),
                                            EXCLUS('D_LB_T','D_LB_TL',),
                                            PRESENT_ABSENT('D_LB_TN','D_LB_TT',),
                                            PRESENT_PRESENT('D_LB_TN','D_LB_TL',),
                                            PRESENT_PRESENT('D_LB_TT','D_LB_TL',),
                                            EXCLUS('LAMB_CT','LAMB_C_L',),
                                            PRESENT_ABSENT('LAMB_C_N','LAMB_C_T',),
                                            PRESENT_PRESENT('LAMB_C_N','LAMB_C_L',),
                                            PRESENT_PRESENT('LAMB_C_T','LAMB_C_L',),
                                            EXCLUS('PERMIN_L','BIOT_COEF'),
                                            EXCLUS('PERMIN_L','LAMB_T'),
                                            PRESENT_PRESENT('BIOT_L','PERMIN_L',),
                                            PRESENT_PRESENT('BIOT_T','PERMIN_T',),
                                            PRESENT_PRESENT('LAMB_TN','PERMIN_N',),
                                            PRESENT_PRESENT('LAMB_TL','PERMIN_L',),
                                            PRESENT_PRESENT('LAMB_TT','PERMIN_T',),

                                            ENSEMBLE('SATU_PRES','D_SATU_PRES','PERM_LIQU','D_PERM_LIQU_SATU',
                                                            'PERM_GAZ','D_PERM_SATU_GAZ','D_PERM_PRES_GAZ',),
                                            ENSEMBLE('VG_N','VG_SR','VG_PR','VG_SMAX','VG_SATUR',),
                                            UN_PARMI('VG_N','SATU_PRES'),
                                           ),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVE   ----------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG            = SIMP(statut='f',typ='R'),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_VAPE_GAZ = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           CP               = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_AD_GAZ_VAPE -------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_GAZ, THM_VAPE_GAZ THM_AIR_DISSOUS---------
# =================================================================================
           b_liquadvape  = BLOC(condition = """equal_to("COMP_THM", 'LIQU_AD_GAZ_VAPE') """,
                                 fr=tr("Paramètres nécessaires pour une loi de couplage de type LIQU_AD_GAZ_VAPE"),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PRE2             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
                                           PRES_VAPE        = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 9.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='f',typ='R'),
                                           BIOT_L           = SIMP(statut='f',typ='R'),
                                           BIOT_N           = SIMP(statut='f',typ='R'),
                                           BIOT_T           = SIMP(statut='f',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---Van Genhuchten et Muallen-----------------------------------------------------------------------------
                                           VG_N     = SIMP(statut='f',typ='R'),
                                           VG_SR    = SIMP(statut='f',typ='R'),
                                           VG_PR    = SIMP(statut='f',typ='R'),
                                           VG_SMAX  = SIMP(statut='f',typ='R'),
                                           VG_SATUR = SIMP(statut='f',typ='R'),
#
                                           FICKV_T          = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP          = SIMP(statut='f',typ='R'),
                                           PERM_IN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_L    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_N    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_T    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT     = SIMP(statut='f',typ='R'),
                                           LAMB_C_L   = SIMP(statut='f',typ='R'),
                                           LAMB_C_N   = SIMP(statut='f',typ='R'),
                                           LAMB_C_T   = SIMP(statut='f',typ='R'),
#
                                  regles = (EXCLUS('BIOT_COEF','BIOT_N',),
                                            PRESENT_PRESENT('BIOT_N','BIOT_L',),
                                            PRESENT_PRESENT('BIOT_T','BIOT_L','BIOT_N',),
                                            EXCLUS('PERM_IN','PERM_END','PERMIN_L',),
         PRESENT_ABSENT('PERMIN_N','PERMIN_T',),
                                            PRESENT_PRESENT('PERMIN_N','PERMIN_L',),
                                            PRESENT_PRESENT('PERMIN_T','PERMIN_L',),
                                            EXCLUS('LAMB_T','LAMB_TL',),
         PRESENT_PRESENT('LAMB_TT','PERMIN_T',),
         PRESENT_ABSENT('LAMB_TN','LAMB_TT',),
                                            PRESENT_PRESENT('LAMB_TN','LAMB_TL',),
                                            PRESENT_PRESENT('LAMB_TT','LAMB_TL',),
                                            EXCLUS('D_LB_T','D_LB_TL',),
         PRESENT_ABSENT('D_LB_TN','D_LB_TT',),
                                            PRESENT_PRESENT('D_LB_TN','D_LB_TL',),
                                            PRESENT_PRESENT('D_LB_TT','D_LB_TL',),
                                            EXCLUS('LAMB_CT','LAMB_C_L',),
         PRESENT_ABSENT('LAMB_C_N','LAMB_C_T',),
                                            PRESENT_PRESENT('LAMB_C_N','LAMB_C_L',),
                                            PRESENT_PRESENT('LAMB_C_T','LAMB_C_L',),
                                            EXCLUS('PERMIN_L','BIOT_COEF'),
                                            EXCLUS('PERMIN_L','LAMB_T'),
         PRESENT_PRESENT('BIOT_L','PERMIN_L',),
         PRESENT_PRESENT('BIOT_T','PERMIN_T',),
                                            PRESENT_PRESENT('LAMB_TN','PERMIN_N',),
                                            PRESENT_PRESENT('LAMB_TL','PERMIN_L',),
                                            PRESENT_PRESENT('LAMB_TT','PERMIN_T',),
                                            ENSEMBLE('SATU_PRES','D_SATU_PRES','PERM_LIQU','D_PERM_LIQU_SATU',
                                                            'PERM_GAZ','D_PERM_SATU_GAZ','D_PERM_PRES_GAZ',),
                                            ENSEMBLE('VG_N','VG_SR','VG_PR','VG_SMAX','VG_SATUR',),
                                            UN_PARMI('VG_N','SATU_PRES'),
                                           ),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG            = SIMP(statut='f',typ='R'),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
#
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_GAZ    = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_VAPE_GAZ = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           CP               = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_AIR_DISS = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           CP               = SIMP(statut='o',typ='R'),
                                           COEF_HENRY       = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ),
                                 ),
# =================================================================================
# --- LOI DE COUPLAGE DE TYPE LIQU_VAPE -------------------------------------------
# =================================================================================
# --- PRESENCE OBLIGATOIRE DES MOT-CLES SUIVANT : ---------------------------------
# --- THM_INIT, THM_DIFFU, THM_LIQU, THM_VAPE_GAZ ---------------------------------
# =================================================================================
           b_liquvape  = BLOC(condition = """equal_to("COMP_THM", 'LIQU_VAPE') """,
                                 fr=tr("Paramètres nécessaires pour une loi de couplage de type LIQU_VAPE"),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_INIT   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE1             = SIMP(statut='o',typ='R'),
                                           PORO             = SIMP(statut='o',typ='R'),
                                           PRES_VAPE        = SIMP(statut='o',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           TEMP             = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           PRE2             = SIMP(statut='f',typ='R'),
                                           DEGR_SATU        = SIMP(statut='f',typ='R'),
# ---------------------------------------------------------------------------------
# -------------------   DONNEE CACHEE ---------------------------------------------
# ---------------------------------------------------------------------------------
                                           COMP_THM         = SIMP(statut='c',typ='R',defaut= 3.0,),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_DIFFU  = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           R_GAZ            = SIMP(statut='o',typ='R'),
                                           RHO              = SIMP(statut='o',typ='R'),
                                           BIOT_COEF        = SIMP(statut='f',typ='R'),
                                           BIOT_L           = SIMP(statut='f',typ='R'),
                                           BIOT_N           = SIMP(statut='f',typ='R'),
                                           BIOT_T           = SIMP(statut='f',typ='R'),
                                           PESA_X           = SIMP(statut='o',typ='R'),
                                           PESA_Y           = SIMP(statut='o',typ='R'),
                                           PESA_Z           = SIMP(statut='o',typ='R'),
                                           SATU_PRES        = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_SATU_PRES      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_LIQU        = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_LIQU_SATU = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_GAZ         = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_SATU_GAZ  = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_PERM_PRES_GAZ  = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES FACULTATIVES   ------------------------------------
# ---------------------------------------------------------------------------------
                                           PESA_MULT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           CP          = SIMP(statut='f',typ='R'),
                                           PERM_IN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_L    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_N    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERMIN_T    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           PERM_END    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_PHI    = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_T      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TL     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TN     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_TT     = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_LB_S      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           LAMB_CT     = SIMP(statut='f',typ='R'),
                                           LAMB_C_L   = SIMP(statut='f',typ='R'),
                                           LAMB_C_N   = SIMP(statut='f',typ='R'),
                                           LAMB_C_T   = SIMP(statut='f',typ='R'),
#
                                  regles = (EXCLUS('BIOT_COEF','BIOT_N',),
                                            PRESENT_PRESENT('BIOT_N','BIOT_L',),
                                            PRESENT_PRESENT('BIOT_T','BIOT_L','BIOT_N',),
                                            EXCLUS('PERM_IN','PERM_END','PERMIN_L',),
                                            PRESENT_ABSENT('PERMIN_N','PERMIN_T',),
                                            PRESENT_PRESENT('PERMIN_N','PERMIN_L',),
                                            PRESENT_PRESENT('PERMIN_T','PERMIN_L',),
                                            EXCLUS('LAMB_T','LAMB_TL',),
                                            PRESENT_ABSENT('LAMB_TN','LAMB_TT',),
                                            PRESENT_PRESENT('LAMB_TN','LAMB_TL',),
                                            PRESENT_PRESENT('LAMB_TT','LAMB_TL',),
                                            EXCLUS('D_LB_T','D_LB_TL',),
                                            PRESENT_ABSENT('D_LB_TN','D_LB_TT',),
                                            PRESENT_PRESENT('D_LB_TN','D_LB_TL',),
                                            PRESENT_PRESENT('D_LB_TT','D_LB_TL',),
                                            EXCLUS('LAMB_CT','LAMB_C_L',),
                                            PRESENT_ABSENT('LAMB_C_N','LAMB_C_T',),
                                            PRESENT_PRESENT('LAMB_C_N','LAMB_C_L',),
                                            PRESENT_PRESENT('LAMB_C_T','LAMB_C_L',),
                                            EXCLUS('PERMIN_L','BIOT_COEF'),
                                            EXCLUS('PERMIN_L','LAMB_T'),
                                            PRESENT_PRESENT('BIOT_L','PERMIN_L',),
                                            PRESENT_PRESENT('BIOT_T','PERMIN_T',),
                                            PRESENT_PRESENT('LAMB_TN','PERMIN_N',),
                                            PRESENT_PRESENT('LAMB_TL','PERMIN_L',),
                                            PRESENT_PRESENT('LAMB_TT','PERMIN_T',),

                                            ENSEMBLE('SATU_PRES','D_SATU_PRES','PERM_LIQU','D_PERM_LIQU_SATU',
                                                            'PERM_GAZ','D_PERM_SATU_GAZ','D_PERM_PRES_GAZ',),
                                           ),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES INUTILES   ----------------------------------------
# ---------------------------------------------------------------------------------
                                           EMMAG            = SIMP(statut='f',typ='R'),
                                           FICKV_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PV         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_PG         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKV_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FV_PG          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_T          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PA         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_PL         = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           FICKA_S          = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_FA_T           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ) ,
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_LIQU   = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           RHO              = SIMP(statut='o',typ='R'),
                                           UN_SUR_K         = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
# ---------------------------------------------------------------------------------
# -------------------   DONNEES NECESSAIRE SI THERMIQUE   -------------------------
# ---------------------------------------------------------------------------------
                                           ALPHA            = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           CP               = SIMP(statut='f',typ='R'),
                                             ),
# =================================================================================
# --- MOT-CLE OBLIGATOIRE ---------------------------------------------------------
# =================================================================================
                             THM_VAPE_GAZ = FACT(statut='o',
# ---------------------------------------------------------------------------------
# -------------------   DONNEES OBLIGATOIRE   -------------------------------------
# ---------------------------------------------------------------------------------
                                           MASS_MOL         = SIMP(statut='o',typ='R'),
                                           CP               = SIMP(statut='o',typ='R'),
                                           VISC             = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                           D_VISC_TEMP      = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
                                             ),
# =================================================================================
# --- MOT-CLE INUTILE -------------------------------------------------------------
# =================================================================================
           THM_GAZ         =FACT(statut='f',
             MASS_MOL        =SIMP(statut='f',typ='R'),
             CP              =SIMP(statut='f',typ='R'),
             VISC            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_VISC_TEMP     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
                                 ),
# courbes et coefficients associés à la fatigue et au dommage
#
           FATIGUE         =FACT(statut='f',
             regles=(PRESENT_ABSENT('WOHLER','A_BASQUIN','BETA_BASQUIN'),
                     PRESENT_ABSENT('WOHLER','A0','A1','A2','A3','SL'),
                     PRESENT_ABSENT('A_BASQUIN','A0','A1','A2','A3','SL'),
                     ENSEMBLE('A_BASQUIN','BETA_BASQUIN'),
                     ENSEMBLE('A0','A1','A2','A3','SL'),
                     PRESENT_PRESENT('A0','E_REFE'),
                     ENSEMBLE('D0','TAU0'),),
             WOHLER          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_BASQUIN       =SIMP(statut='f',typ='R'),
             BETA_BASQUIN    =SIMP(statut='f',typ='R'),
             A0              =SIMP(statut='f',typ='R'),
             A1              =SIMP(statut='f',typ='R'),
             A2              =SIMP(statut='f',typ='R'),
             A3              =SIMP(statut='f',typ='R'),
             SL              =SIMP(statut='f',typ='R'),
             MANSON_COFFIN   =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             E_REFE          =SIMP(statut='f',typ='R'),
             D0              =SIMP(statut='f',typ='R'),
             TAU0            =SIMP(statut='f',typ='R'),
           ),
           DOMMA_LEMAITRE  =FACT(statut='f',
             S               =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             EPSP_SEUIL      =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             EXP_S           =SIMP(statut='f',typ='R',val_min=0.0E0,defaut=1.0),
           ),
           CISA_PLAN_CRIT  =FACT(statut='f',
             CRITERE       =SIMP(statut='o',typ='TXM',into=("MATAKE_MODI_AC",
                                                            "DANG_VAN_MODI_AC",
                                                            "DANG_VAN_MODI_AV",
                                                            "MATAKE_MODI_AV",
                                                            "FATESOCI_MODI_AV",
                                                            ) ),

             b_critere_matake =BLOC(condition="""equal_to("CRITERE", 'MATAKE_MODI_AC') or equal_to("CRITERE", 'MATAKE_MODI_AV')""",
                         fr=tr("Cisaillement plan critique critère de matake pour les cas amplitude constante et amplitude variable"),
               MATAKE_A         =SIMP(statut='o',typ='R'),
               MATAKE_B         =SIMP(statut='o',typ='R'),
               COEF_FLEX_TORS   =SIMP(statut='o',typ='R',val_min=1.0E0,val_max=1.7321E0),
             ),

             b_critere_dang_van =BLOC(condition="""(equal_to("CRITERE", 'DANG_VAN_MODI_AC') or equal_to("CRITERE", 'DANG_VAN_MODI_AV'))""",
                                 fr=tr("Critère de Dang Van modifié pour les cas amplitude constante et amplitude variable"),
               D_VAN_A            =SIMP(statut='o',typ='R'),
               D_VAN_B            =SIMP(statut='o',typ='R'),
               COEF_CISA_TRAC     =SIMP(statut='o',typ='R',val_min=1.0E0,val_max=1.7321E0),
             ),

             b_critere_fate_soci =BLOC(condition="""equal_to("CRITERE", 'FATESOCI_MODI_AV')""",
                               fr=tr("Critère de Fatemi et Socie, en élasticité ou élastoplasticité, pour le cas amplitude variable"),
               FATSOC_A           =SIMP(statut='o',typ='R'),
               COEF_CISA_TRAC     =SIMP(statut='o',typ='R',val_min=1.0E0,val_max=1.7321E0),
             ),
           ),


           THM_RUPT       =FACT(statut='f',
             OUV_FICT        =SIMP(statut='o',typ='R'),
             UN_SUR_N        =SIMP(statut='f',typ='R',defaut= 0.),
           ),
#
# autres comportements ...
#
           WEIBULL         =FACT(statut='f',
             M               =SIMP(statut='o',typ='R'),
             VOLU_REFE       =SIMP(statut='o',typ='R'),
             SIGM_REFE       =SIMP(statut='o',typ='R'),
             SEUIL_EPSP_CUMU =SIMP(statut='f',typ='R',defaut= 1.0E-6),
           ),
           WEIBULL_FO      =FACT(statut='f',
             M               =SIMP(statut='o',typ='R'),
             VOLU_REFE       =SIMP(statut='o',typ='R'),
             SIGM_CNV        =SIMP(statut='o',typ='R'),
             SIGM_REFE       =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SEUIL_EPSP_CUMU =SIMP(statut='f',typ='R',defaut= 1.0E-6),
           ),
           NON_LOCAL       =FACT(statut='f',
             regles=(AU_MOINS_UN('LONG_CARA','C_GONF','C_GRAD_VARI','PENA_LAGR',),),
             LONG_CARA       =SIMP(statut='f',typ='R'),
             C_GRAD_VARI     =SIMP(statut='f',typ='R'),
             PENA_LAGR       =SIMP(statut='f',typ='R',defaut= 1.0E3),
             C_GONF          =SIMP(statut='f',typ='R'),
             COEF_RIGI_MINI  =SIMP(statut='f',typ='R'),
           ),
           RUPT_FRAG       =FACT(statut='f',
             GC              =SIMP(statut='o',typ='R'),
             SIGM_C          =SIMP(statut='f',typ='R'),
             PENA_ADHERENCE  =SIMP(statut='f',typ='R',val_min=1.E-12,val_max=1.E+0),
             PENA_CONTACT    =SIMP(statut='f',typ='R',defaut=1.),
             PENA_LAGR       =SIMP(statut='f',typ='R',defaut=1.0E2,val_min=1.01E+0),
             RIGI_GLIS       =SIMP(statut='f',typ='R',defaut=1.0E1),
             CINEMATIQUE     =SIMP(statut='f',typ='TXM',defaut="UNILATER",into=("UNILATER","GLIS_1D","GLIS_2D")),
           ),
           RUPT_FRAG_FO   =FACT(statut='f',
             GC              =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SIGM_C          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PENA_ADHERENCE  =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PENA_CONTACT    =SIMP(statut='f',typ='R',defaut=1.),
             PENA_LAGR       =SIMP(statut='f',typ='R',defaut=1.0E2,val_min=1.01E+0),
             RIGI_GLIS       =SIMP(statut='f',typ='R',defaut=1.0E1),
             CINEMATIQUE     =SIMP(statut='f',typ='TXM',defaut="UNILATER",into=("UNILATER","GLIS_1D","GLIS_2D")),
           ),
           CZM_LAB_MIX    =FACT(statut='f',
             SIGM_C          =SIMP(statut='o',typ='R',              val_min=1.E-100),
             GLIS_C          =SIMP(statut='o',typ='R',              val_min=1.E-100),
             ALPHA           =SIMP(statut='f',typ='R',  defaut=0.5, val_min=1.E-3),
             BETA            =SIMP(statut='f',typ='R',  defaut=1.,  val_min=0.),
             PENA_LAGR       =SIMP(statut='f',typ='R',  defaut=100.,val_min=1.01E+0),
             CINEMATIQUE     =SIMP(statut='f',typ='TXM',defaut="GLIS_1D",into=("UNILATER","GLIS_1D","GLIS_2D")),
           ),
           RUPT_DUCT       =FACT(statut='f',
             GC              =SIMP(statut='o',typ='R'),
             SIGM_C          =SIMP(statut='o',typ='R'),
             COEF_EXTR       =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=9.99E-1),
             COEF_PLAS       =SIMP(statut='o',typ='R',val_min=0.E+0,val_max=9.99E-1),
             PENA_LAGR       =SIMP(statut='f',typ='R',defaut=1.0E2,val_min=1.01E+0),
             RIGI_GLIS       =SIMP(statut='f',typ='R',defaut=1.0E1),
           ),
           JOINT_MECA_RUPT  =FACT(statut='f',
             regles=(EXCLUS('PRES_FLUIDE','PRES_CLAVAGE'),
                     EXCLUS('PRES_FLUIDE','SCIAGE'),
                     PRESENT_PRESENT('RHO_FLUIDE','VISC_FLUIDE','OUV_MIN'),
                     PRESENT_ABSENT('PRES_FLUIDE','RHO_FLUIDE','VISC_FLUIDE','OUV_MIN'),
                     PRESENT_ABSENT('PRES_CLAVAGE','RHO_FLUIDE','VISC_FLUIDE','OUV_MIN'),
                     PRESENT_ABSENT('SCIAGE','RHO_FLUIDE','VISC_FLUIDE','OUV_MIN'),
                     PRESENT_ABSENT('RHO_FLUIDE','PRES_FLUIDE','PRES_CLAVAGE','SCIAGE'),
                     PRESENT_ABSENT('VISC_FLUIDE','PRES_FLUIDE','PRES_CLAVAGE','SCIAGE'),
                     PRESENT_ABSENT('OUV_MIN','PRES_FLUIDE','PRES_CLAVAGE','SCIAGE'),
                     ),
             K_N             =SIMP(statut='o',typ='R',val_min=1.E-12),
             K_T             =SIMP(statut='f',typ='R',val_min=1.E-12),
             SIGM_MAX        =SIMP(statut='o',typ='R',val_min=0.),
             ALPHA           =SIMP(statut='f',typ='R',defaut=1., val_min=0., val_max=2.),
             PENA_RUPTURE    =SIMP(statut='f',typ='R',val_min=1.E-12,val_max=10.E+0),
             PENA_CONTACT    =SIMP(statut='f',typ='R',defaut=1.,val_min=1.E-12),
             PRES_FLUIDE     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             PRES_CLAVAGE    =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SCIAGE          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO_FLUIDE      =SIMP(statut='f',typ='R',val_min=0.),
             VISC_FLUIDE     =SIMP(statut='f',typ='R',val_min=1.E-20),
             OUV_MIN         =SIMP(statut='f',typ='R',val_min=1.E-15),
           ),
           JOINT_MECA_FROT   =FACT(statut='f',
             regles=(
                     EXCLUS('PRES_FLUIDE','SCIAGE'),
                     PRESENT_PRESENT('RHO_FLUIDE','VISC_FLUIDE','OUV_MIN'),
                     PRESENT_ABSENT('PRES_FLUIDE','RHO_FLUIDE','VISC_FLUIDE','OUV_MIN'),
                     PRESENT_ABSENT('SCIAGE','RHO_FLUIDE','VISC_FLUIDE','OUV_MIN'),
                     PRESENT_ABSENT('RHO_FLUIDE','PRES_FLUIDE'),
                     PRESENT_ABSENT('VISC_FLUIDE','PRES_FLUIDE'),
                     PRESENT_ABSENT('OUV_MIN','PRES_FLUIDE'),
                     ),
             K_N             =SIMP(statut='o',typ='R',val_min=1.E-12),
             K_T             =SIMP(statut='f',typ='R',val_min=1.E-12),
             AMOR_NOR        =SIMP(statut='f',typ='R',val_min=0.),
             AMOR_TAN        =SIMP(statut='f',typ='R',val_min=0.),
             COEF_AMOR       =SIMP(statut='f',typ='R',val_min=0.),
             MU              =SIMP(statut='o',typ='R',val_min=1.E-3),
             PENA_TANG       =SIMP(statut='f',typ='R',val_min=0.),
             ADHESION        =SIMP(statut='f',typ='R',defaut=0., val_min=0.),
             PRES_FLUIDE     =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SCIAGE          =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             RHO_FLUIDE      =SIMP(statut='f',typ='R',val_min=0.),
             VISC_FLUIDE     =SIMP(statut='f',typ='R',val_min=1.E-20),
             OUV_MIN         =SIMP(statut='f',typ='R',val_min=1.E-15),
           ),
           RCCM            =FACT(statut='f',
             regles=(ENSEMBLE('A_AMORC','B_AMORC','D_AMORC','R_AMORC'),),
             SY_02           =SIMP(statut='f',typ='R'),
             SM              =SIMP(statut='f',typ='R'),
             SU              =SIMP(statut='f',typ='R'),
             SC              =SIMP(statut='f',typ='R'),
             SH              =SIMP(statut='f',typ='R'),
             N_KE            =SIMP(statut='f',typ='R'),
             M_KE            =SIMP(statut='f',typ='R'),
             A_AMORC         =SIMP(statut='f',typ='R'),
             B_AMORC         =SIMP(statut='f',typ='R'),
             D_AMORC         =SIMP(statut='f',typ='R'),
             R_AMORC         =SIMP(statut='f',typ='R'),
           ),
           RCCM_FO         =FACT(statut='f',
             regles=(ENSEMBLE('A_AMORC','B_AMORC','D_AMORC','R_AMORC'),),
             SY_02           =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SM              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             SU              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             S               =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             N_KE            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             M_KE            =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             A_AMORC         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             B_AMORC         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
             D_AMORC         =SIMP(statut='f',typ='R'),
             R_AMORC         =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
           LAIGLE          =FACT(statut='f',
             GAMMA_ULT       =SIMP(statut='o',typ='R'),
             GAMMA_E         =SIMP(statut='o',typ='R'),
             M_ULT           =SIMP(statut='o',typ='R'),
             M_E             =SIMP(statut='o',typ='R'),
             A_E             =SIMP(statut='o',typ='R'),
             M_PIC           =SIMP(statut='o',typ='R'),
             A_PIC           =SIMP(statut='o',typ='R'),
             ETA             =SIMP(statut='o',typ='R'),
             SIGMA_C         =SIMP(statut='o',typ='R'),
             GAMMA           =SIMP(statut='o',typ='R'),
             KSI             =SIMP(statut='o',typ='R'),
             GAMMA_CJS       =SIMP(statut='o',typ='R'),
             SIGMA_P1        =SIMP(statut='o',typ='R'),
             PA              =SIMP(statut='o',typ='R'),
           ),
           LETK          =FACT(statut='f',
             PA         =SIMP(statut='o',typ='R',fr=tr("pression atmospherique")),
             NELAS      =SIMP(statut='o',typ='R',fr=tr("exposant de la loi de variation des modules K et G")),
             SIGMA_C    =SIMP(statut='o',typ='R',fr=tr("résistance en compression simple ")),
             H0_EXT     =SIMP(statut='o',typ='R',fr=tr("parametre pilotant la résistance en extension")),
             GAMMA_CJS  =SIMP(statut='o',typ='R',fr=tr("parametre de forme du critere ds le plan déviatoire entre 0 et 1.")),
             XAMS       =SIMP(statut='o',typ='R',fr=tr("parametre non nul intervenant dans les lois d'écrouissage pre pic")),
             ETA        =SIMP(statut='o',typ='R',fr=tr("parametre non nul intervenant dans les lois d'écrouissage post pic")),
             A_0        =SIMP(statut='o',typ='R',fr=tr("a de la limite d'élasticité initiale")),
             A_E        =SIMP(statut='o',typ='R',fr=tr("a de la limite de clivage ou seuil intermédiaire")),
             A_PIC      =SIMP(statut='o',typ='R',fr=tr("a du seuil de pic")),
             S_0        =SIMP(statut='o',typ='R',fr=tr("s de la limite d'élasticité initiale")),
             M_0        =SIMP(statut='o',typ='R',fr=tr("m de la limite d'élasticité initiale")),
             M_E        =SIMP(statut='o',typ='R',fr=tr("m de la limite de clivage ou seuil intermédiaire")),
             M_PIC      =SIMP(statut='o',typ='R',fr=tr("m du seuil de pic")),
             M_ULT      =SIMP(statut='o',typ='R',fr=tr("m du seuil residuel")),
             XI_ULT     =SIMP(statut='o',typ='R',fr=tr("niveau d écrouissage pour atteindre le seuil résiduel")),
             XI_E       =SIMP(statut='o',typ='R',fr=tr("niveau d écrouissage pour atteindre le seuil de clivage")),
             XI_PIC     =SIMP(statut='o',typ='R',fr=tr("niveau d écrouissage pour atteindre le seuil de pic")),
             MV_MAX     =SIMP(statut='o',typ='R',fr=tr("m du seuil viscoplastique maximal")),
             XIV_MAX    =SIMP(statut='o',typ='R',fr=tr("niveau d écrouissage pour atteindre le seuil viscoplastique maximal")),
             A          =SIMP(statut='o',typ='R',fr=tr("parametre carcaterisant l amplitude de la vitesse de fluage")),
             N          =SIMP(statut='o',typ='R',fr=tr("parametre intervenant dans la formule pilotant la cinetique de fluage")),
             SIGMA_P1   =SIMP(statut='o',typ='R',fr=tr("SIG min de l intersection du seuil de pic et intermediaire ")),
             MU0_V      =SIMP(statut='o',typ='R',fr=tr("relatif à l angle de dilatance des mecanismes pre pic et viscoplastique")),
             XI0_V      =SIMP(statut='o',typ='R',fr=tr("relatif à l angle de dilatance des mecanismes pre pic et viscoplastique")),
             MU1        =SIMP(statut='o',typ='R',fr=tr("relatif à l angle de dilatance du mecanisme post pic ")),
             XI1        =SIMP(statut='o',typ='R',fr=tr("relatif à l angle de dilatance du mecanisme post pic ")),
           ),
           LKR            =FACT(statut='f',
             PA           =SIMP(statut='o',typ='R',fr="pression atmospherique"),
             NELAS        =SIMP(statut='f',typ='R',defaut=0.,fr="exposant de la loi de variation des modules K et G"),
             SIGMA_C      =SIMP(statut='o',typ='R',fr="resistance en compression simple "),
             BETA         =SIMP(statut='f',typ='R',defaut=1.5,fr="parametre de forme du critere ds le plan deviatoire"),
             GAMMA        =SIMP(statut='f',typ='R',defaut=0.,fr="parametre de forme du critere ds le plan deviatoire entre 0 et 1."),
             V_1          =SIMP(statut='o',typ='R',val_min=1.,fr="parametre strict. sup. a 1 controlant la cinetique d'ecrouissage pre-pic"),
             V_2          =SIMP(statut='o',typ='R',val_min=1.,fr="parametre strict. sup. a 1 controlant la cinetique d'ecrouissage post-pic"),
             A_2          =SIMP(statut='o',typ='R',val_min=.5,val_max=1.,fr="a de la limite de clivage ou seuil intermediaire"),
             M_0          =SIMP(statut='o',typ='R',fr="m de la limite d'elasticite initiale a temperature ambiante"),
             M_1          =SIMP(statut='o',typ='R',fr="m du seuil de pic a temperature ambiante"),
             Q_I          =SIMP(statut='o',typ='R',fr="ordonnee de l'intersection des seuils de pic, de clivage et residuel a temperature ambiante"),
             XI_1         =SIMP(statut='o',typ='R',fr="niveau d'ecrouissage pour atteindre le seuil de pic"),
             XI_2         =SIMP(statut='o',typ='R',fr="niveau d'ecrouissage pour atteindre le seuil de clivage"),
             XI_5         =SIMP(statut='o',typ='R',fr="niveau d ecrouissage pour atteindre le seuil viscoplastique maximal"),
             F_P          =SIMP(statut='f',typ='R',defaut=.1,val_min=-1.,val_max=1.,fr="parametre controlant l'abscisse du seuil caracteristique"),
             A            =SIMP(statut='o',typ='R',fr="parametre caracterisant l'amplitude de la vitesse de fluage"),
             N            =SIMP(statut='o',typ='R',fr="parametre intervenant dans la formule pilotant la cinetique de fluage"),
             RHO_1        =SIMP(statut='o',typ='R',fr="relatif à l angle de dilatance"),
             RHO_2        =SIMP(statut='o',typ='R',fr="relatif à l angle de dilatance"),
             RHO_4        =SIMP(statut='o',typ='R',fr="relatif à l angle de dilatance"),
             R_Q          =SIMP(statut='f',typ='R',defaut=0.,fr="controle l'evolution de qi avec T"),
             R_M          =SIMP(statut='f',typ='R',defaut=0.,fr="controle l'evolution de m0, m1 et s0 avec T"),
             R_S          =SIMP(statut='f',typ='R',defaut=0.,fr="controle l'evolution de s1 avec T"),
             R_X1         =SIMP(statut='f',typ='R',defaut=0.,fr="controle l'evolution de xi1 avec T"),
             R_X2         =SIMP(statut='f',typ='R',defaut=0.,fr="controle l'evolution de xi2 avec T"),
             R_X5         =SIMP(statut='f',typ='R',defaut=0.,fr="controle l'evolution de xi5 avec T"),
             Z            =SIMP(statut='f',typ='R',defaut=0.,fr="controle l'evolution de av avec T"),
             COUPLAGE_P_VP=SIMP(statut='f',typ='R',defaut=1.,into=(0.,1.),fr="couplage entre les deux mecanismes"),
           ),
           DRUCK_PRAGER  =FACT(statut='f',
             ALPHA           =SIMP(statut='o',typ='R'),
             SY              =SIMP(statut='o',typ='R'),
             P_ULTM          =SIMP(statut='o',typ='R'),
             ECROUISSAGE = SIMP(statut='o',typ='TXM',into=("LINEAIRE","PARABOLIQUE")),
             b_lineaire =BLOC(condition="""equal_to("ECROUISSAGE", 'LINEAIRE')""",
                                    fr=tr("Loi de comportement de type Drucker Prager avec un ecrouissage lineaire"),
                    H               =SIMP(statut='o',typ='R'),
                    TYPE_DP         =SIMP(statut='c',typ='R',defaut= 1.0,),
             ),
             b_parabolique =BLOC(condition="""equal_to("ECROUISSAGE", 'PARABOLIQUE')""",
                                    fr=tr("Loi de comportement de type Drucker Prager avec un ecrouissage parabolique"),
                    SY_ULTM         =SIMP(statut='o',typ='R'),
                    TYPE_DP         =SIMP(statut='c',typ='R',defaut= 2.0,),
             ),
             DILAT           =SIMP(statut='f',typ='R',defaut=0.0),
           ),

           VISC_DRUC_PRAG          =FACT(statut='f',
             PREF       =SIMP(statut='o',typ='R',fr=tr("pression de reference")),
             A          =SIMP(statut='o',typ='R',fr=tr("parametre carcaterisant l amplitude de la vitesse de fluage")),
             N          =SIMP(statut='o',typ='R',fr=tr("parametre intervenant dans la formule pilotant la cinetique de fluage")),
             P_PIC      =SIMP(statut='o',typ='R',fr=tr("niveau d ecrouissage pour atteindre le seuil de pic")),
             P_ULT      =SIMP(statut='o',typ='R',fr=tr("niveau d ecrouissage pour atteindre le seuil utime")),
             ALPHA_0    =SIMP(statut='o',typ='R',fr=tr("parametre d ecrouissage relatif à la cohesion au seuil d elasticite")),
             ALPHA_PIC  =SIMP(statut='o',typ='R',fr=tr("parametre d ecrouissage relatif à la cohesion au seuil de pic")),
             ALPHA_ULT  =SIMP(statut='o',typ='R',fr=tr("parametre d ecrouissage relatif à la cohesion au seuil ultime")),
             R_0        =SIMP(statut='o',typ='R',fr=tr("parametre d ecrouissage correspondant au seuil d'elasticite")),
             R_PIC      =SIMP(statut='o',typ='R',fr=tr("parametre d ecrouissage correspondant au seuil de pic")),
             R_ULT      =SIMP(statut='o',typ='R',fr=tr("parametre d ecrouissage correspondant au seuil ultime")),
             BETA_0     =SIMP(statut='o',typ='R',fr=tr("parametre d ecrouissage relatif à la dilatance au seuil d elasticite")),
             BETA_PIC   =SIMP(statut='o',typ='R',fr=tr("parametre d ecrouissage relatif à la dilatance au seuil de pic")),
             BETA_ULT   =SIMP(statut='o',typ='R',fr=tr("parametre d ecrouissage relatif à la dilatance au seuil ultime")),
           ),
             HOEK_BROWN          =FACT(statut='f',
             GAMMA_RUP       =SIMP(statut='o',typ='R'),
             GAMMA_RES       =SIMP(statut='o',typ='R'),
             S_END           =SIMP(statut='o',typ='R'),
             S_RUP           =SIMP(statut='o',typ='R'),
             M_END           =SIMP(statut='o',typ='R'),
             M_RUP           =SIMP(statut='o',typ='R'),
             BETA            =SIMP(statut='o',typ='R'),
             ALPHAHB         =SIMP(statut='o',typ='R'),
             PHI_RUP         =SIMP(statut='o',typ='R'),
             PHI_RES         =SIMP(statut='o',typ='R'),
             PHI_END         =SIMP(statut='f',typ='R'),
           ),
             ELAS_GONF             =FACT(statut='f',
             BETAM           =SIMP(statut='o',typ='R'),
             PREF            =SIMP(statut='o',typ='R'),
           ),
             JOINT_BANDIS         =FACT(statut='f',
             K                =SIMP(statut='o',typ='R'),
             DMAX             =SIMP(statut='o',typ='R'),
             GAMMA            =SIMP(statut='o',typ='R'),
             KT               =SIMP(statut='f',typ='R',defaut = 1.E12),
           ),
####  MONOCRISTAL

           MONO_VISC1      =FACT(statut='f',
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             N               =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='o',typ='R'),
             C               =SIMP(statut='o',typ='R'),
           ),
           MONO_VISC2      =FACT(statut='f',
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             N               =SIMP(statut='o',typ='R'),
             K               =SIMP(statut='o',typ='R'),
             C               =SIMP(statut='o',typ='R'),
             D               =SIMP(statut='o',typ='R'),
             A               =SIMP(statut='o',typ='R'),
           ),
           MONO_ISOT1      =FACT(statut='f',
              regles=(UN_PARMI('H','H1'),
                      PRESENT_PRESENT('H1','H2','H3','H4'),
                      PRESENT_ABSENT('H','H1','H2','H3','H4','H5','H6'),
                      ),
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECRO_ISOT",),),
             R_0             =SIMP(statut='o',typ='R'),
             Q               =SIMP(statut='o',typ='R'),
             B               =SIMP(statut='o',typ='R'),
             H               =SIMP(statut='f',typ='R'),
             H1              =SIMP(statut='f',typ='R'),
             H2              =SIMP(statut='f',typ='R'),
             H3              =SIMP(statut='f',typ='R'),
             H4              =SIMP(statut='f',typ='R'),
             H5              =SIMP(statut='f',typ='R'),
             H6              =SIMP(statut='f',typ='R'),
           ),
           MONO_ISOT2      =FACT(statut='f',
              regles=(UN_PARMI('H','H1'),
                      PRESENT_PRESENT('H1','H2','H3','H4'),
                      PRESENT_ABSENT('H','H1','H2','H3','H4','H5','H6'),
                      ),
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECRO_ISOT",),),
             R_0             =SIMP(statut='o',typ='R'),
             Q1              =SIMP(statut='o',typ='R'),
             B1              =SIMP(statut='o',typ='R'),
             H               =SIMP(statut='f',typ='R'),
             H1              =SIMP(statut='f',typ='R'),
             H2              =SIMP(statut='f',typ='R'),
             H3              =SIMP(statut='f',typ='R'),
             H4              =SIMP(statut='f',typ='R'),
             H5              =SIMP(statut='f',typ='R'),
             H6              =SIMP(statut='f',typ='R'),
             Q2              =SIMP(statut='o',typ='R'),
             B2              =SIMP(statut='o',typ='R'),
           ),
           MONO_CINE1      =FACT(statut='f',
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECRO_CINE",),),
             D               =SIMP(statut='o',typ='R'),
           ),
           MONO_CINE2      =FACT(statut='f',
             TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECRO_CINE",),),
             D               =SIMP(statut='o',typ='R'),
             GM              =SIMP(statut='o',typ='R'),
             PM              =SIMP(statut='o',typ='R'),
             C               =SIMP(statut='o',typ='R'),
           ),
           MONO_DD_KR      =FACT(statut='f',
              regles=(UN_PARMI('H','H1'),
                      PRESENT_PRESENT('H1','H2','H3','H4'),
                      PRESENT_ABSENT('H','H1','H2','H3','H4','H5','H6'),
                      ),
            # TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             K               =SIMP(statut='o',typ='R',fr=tr("Constante de Boltzmann, en eV/K")),
             TAUR            =SIMP(statut='o',typ='R',fr=tr("Contraintes de cisaillement à T=0K, en unite de contraintes")),
             TAU0            =SIMP(statut='o',typ='R',fr=tr("Contraintes critique initiale de cisaillement, en unite de contraintes")),
             GAMMA0          =SIMP(statut='o',typ='R',fr=tr("Vitesse d ecoulement initiale")),
             DELTAG0         =SIMP(statut='o',typ='R',fr=tr("Gain d energie lie au franchissement d obstacle")),
             BSD             =SIMP(statut='o',typ='R',fr=tr("fonction de la taille du grain B/D")),
             GCB             =SIMP(statut='o',typ='R',fr=tr("distance critique d'annihilation GC/B")),
             KDCS            =SIMP(statut='o',typ='R',fr=tr("Parametre relatif à la direction principale de la dislocation")),
             P               =SIMP(statut='o',typ='R',fr=tr("Parametre materiau dépendant de la forme de l'obstacle")),
             Q               =SIMP(statut='o',typ='R',fr=tr("Parametre materiau dépendant de la forme de l'obstacle")),
             H               =SIMP(statut='f',typ='R'),
             H1              =SIMP(statut='f',typ='R'),
             H2              =SIMP(statut='f',typ='R'),
             H3              =SIMP(statut='f',typ='R'),
             H4              =SIMP(statut='f',typ='R'),
             H5              =SIMP(statut='f',typ='R'),
             H6              =SIMP(statut='f',typ='R'),
           ),
           MONO_DD_CFC      =FACT(statut='f',
             regles=(UN_PARMI('H','H1'),
                     PRESENT_PRESENT('H1','H2','H3','H4','H5'),
                     PRESENT_ABSENT('H','H1','H2','H3','H4','H5'),
                     ),
             #TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             GAMMA0          =SIMP(statut='f',typ='R',defaut=0.001,fr=tr("Vitesse d ecoulement initiale en s**-1")),
             TAU_F           =SIMP(statut='o',typ='R',fr=tr("Contraintes , en unite de contraintes ex 20 MPa")),
             A               =SIMP(statut='f',typ='R',defaut=0.13,fr=tr("paramètre A, sans unité")),
             B               =SIMP(statut='f',typ='R',defaut=0.005,fr=tr("paramètre B, sans unité")),
             N               =SIMP(statut='f',typ='R',defaut=200.,fr=tr("paramètre n, sans unité")),
             Y               =SIMP(statut='o',typ='R',fr=tr("paramète Y, en unité de longueur ex 2.5 A")),
             ALPHA           =SIMP(statut='f',typ='R',defaut=0.35,fr=tr("ecrouissage, paramètre alpha")),
             BETA            =SIMP(statut='o',typ='R',fr=tr("ecrouissage, paramètre b, en unite de longueur")),
             RHO_REF         =SIMP(statut='o',typ='R',fr=tr("ecrouissage, paramètre rho_ref, en unité de longueur **-2")),
             H               =SIMP(statut='f',typ='R'),
             H1              =SIMP(statut='f',typ='R',defaut=0.124,fr=tr("matrice d'interaction, terme a*"),),
             H2              =SIMP(statut='f',typ='R',defaut=0.625,fr=tr("matrice d'interaction, terme a_colineaire"),),
             H3              =SIMP(statut='f',typ='R',defaut=0.137,fr=tr("matrice d'interaction, terme a_glissile"),),
             H4              =SIMP(statut='f',typ='R',defaut=0.122,fr=tr("matrice d'interaction, terme a_Lomer"),),
             H5              =SIMP(statut='f',typ='R',defaut=0.07,fr=tr("matrice d'interaction, terme a_Hirth"),),
           ),

           MONO_DD_CFC_IRRA      =FACT(statut='f',
             regles=(UN_PARMI('H','H1'),
                     PRESENT_PRESENT('H1','H2','H3','H4','H5'),
                     PRESENT_ABSENT('H','H1','H2','H3','H4','H5'),
                     ),
             #TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             GAMMA0          =SIMP(statut='f',typ='R',defaut=0.001,fr=tr("Vitesse d ecoulement initiale en s**-1")),
             TAU_F           =SIMP(statut='o',typ='R',fr=tr("Contraintes , en unite de contraintes ex 20 MPa")),
             A               =SIMP(statut='f',typ='R',defaut=0.13,fr=tr("paramètre A, sans unité")),
             B               =SIMP(statut='f',typ='R',defaut=0.005,fr=tr("paramètre B, sans unité")),
             N               =SIMP(statut='f',typ='R',defaut=200.,fr=tr("paramètre n, sans unité")),
             Y               =SIMP(statut='o',typ='R',fr=tr("paramète Y, en unité de longueur ex 2.5 A")),
             ALPHA           =SIMP(statut='f',typ='R',defaut=0.35,fr=tr("ecrouissage, paramètre alpha")),
             BETA            =SIMP(statut='o',typ='R',fr=tr("ecrouissage, paramètre b, en unite de longueur")),
             RHO_REF         =SIMP(statut='o',typ='R',fr=tr("ecrouissage, paramètre rho_ref, en unité de longueur **-2")),
             H               =SIMP(statut='f',typ='R'),
             H1              =SIMP(statut='f',typ='R',defaut=0.124,fr=tr("matrice d'interaction, terme a*"),),
             H2              =SIMP(statut='f',typ='R',defaut=0.625,fr=tr("matrice d'interaction, terme a_colineaire"),),
             H3              =SIMP(statut='f',typ='R',defaut=0.137,fr=tr("matrice d'interaction, terme a_glissile"),),
             H4              =SIMP(statut='f',typ='R',defaut=0.122,fr=tr("matrice d'interaction, terme a_Lomer"),),
             H5              =SIMP(statut='f',typ='R',defaut=0.07,fr=tr("matrice d'interaction, terme a_Hirth"),),

             DZ_IRRA         =SIMP(statut='o',typ='R',val_min=0.E+0,fr=tr("Parametre dzeta pour irradiation")),
             XI_IRRA         =SIMP(statut='o',typ='R',val_min=0.E+0,fr=tr("Parametre xi pour irradiation")),
             RHO_VOID        =SIMP(statut='o',typ='R',fr=tr("Parametre rho_voids pour irradiation")),
             PHI_LOOP        =SIMP(statut='o',typ='R',fr=tr("Parametre phi_loops pour irradiation")),
             ALP_VOID        =SIMP(statut='o',typ='R',fr=tr("Parametre alpha_voids pour irradiation")),
             ALP_LOOP        =SIMP(statut='o',typ='R',fr=tr("Parametre alpha_loops pour irradiation")),
             RHO_SAT         =SIMP(statut='o',typ='R',fr=tr("Parametre rho_sat*b*b pour irradiation")),
             PHI_SAT         =SIMP(statut='o',typ='R',fr=tr("Parametre phi_sat pour irradiation")),

           ),

           MONO_DD_FAT      =FACT(statut='f',
             regles=(UN_PARMI('H','H1'),
                     PRESENT_PRESENT('H1','H2','H3','H4','H5'),
                     PRESENT_ABSENT('H','H1','H2','H3','H4','H5'),
                     ),
             #TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             GAMMA0          =SIMP(statut='o',typ='R',fr=tr("Vitesse d ecoulement initiale en s**-1")),
             TAU_F           =SIMP(statut='o',typ='R',fr=tr("Contraintes , en unite de contraintes ex 20 MPa")),
             BETA            =SIMP(statut='o',typ='R',fr=tr("ecrouissage, paramètre b, en unite de longueur")),
             N               =SIMP(statut='o',typ='R',fr=tr("paramètre n, sans unite")),
             UN_SUR_D        =SIMP(statut='o',typ='R',fr=tr("paramètre 1/D, en unite de 1/longueur")),
             GC0             =SIMP(statut='o',typ='R',fr=tr("paramètre GC0, en unite de longueur")),
             K               =SIMP(statut='o',typ='R',fr=tr("paramètre K, sans unite")),
             H               =SIMP(statut='f',typ='R'),
             H1              =SIMP(statut='f',typ='R',defaut=0.124,fr=tr("matrice d'interaction, terme a*"),),
             H2              =SIMP(statut='f',typ='R',defaut=0.625,fr=tr("matrice d'interaction, terme a_colineaire"),),
             H3              =SIMP(statut='f',typ='R',defaut=0.137,fr=tr("matrice d'interaction, terme a_glissile"),),
             H4              =SIMP(statut='f',typ='R',defaut=0.122,fr=tr("matrice d'interaction, terme a_Lomer"),),
             H5              =SIMP(statut='f',typ='R',defaut=0.07,fr=tr("matrice d'interaction, terme a_Hirth"),),
           ),

          MONO_DD_CC      =FACT(statut='f',
             #TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             B               =SIMP(statut='o',typ='R',fr=tr("parametre B, en unite de longueur")),
             GH               =SIMP(statut='o',typ='R',fr=tr("parametre H, en unite de 1/temps")),
             DELTAG0         =SIMP(statut='o',typ='R',fr=tr("energie d'activation, en unite d'energie (eV ou J)")),
             TAU_0           =SIMP(statut='o',typ='R',fr=tr("contrainte ultime, en unite de contraintes ")),
             TAU_F           =SIMP(statut='o',typ='R',fr=tr("seuil en contrainte , en unite de contraintes")),
             GAMMA0          =SIMP(statut='o',typ='R',fr=tr("Vitesse d ecoulement initiale en s**-1")),
             N               =SIMP(statut='o',typ='R',fr=tr("parametre n, sans unite")),
             RHO_MOB         =SIMP(statut='o',typ='R',fr=tr("densite de dislocations mobiles, en unite de longueur **-2")),
             D               =SIMP(statut='o',typ='R',fr=tr("parametre D, en unite de longueur")),
             D_LAT           =SIMP(statut='o',typ='R',fr=tr("parametre D_LAT, en unite de longueur")),
             Y_AT            =SIMP(statut='o',typ='R',fr=tr("parametre Y_AT, en unite de longueur")),
             K_F             =SIMP(statut='o',typ='R',fr=tr("Parametre K_F")),
             K_SELF          =SIMP(statut='o',typ='R',fr=tr("Parametre K_SELF")),
             K_BOLTZ         =SIMP(statut='o',typ='R',fr=tr("Constante de Boltzmann, en eV/K")),
             H1              =SIMP(statut='o',typ='R',fr=tr("Parametre a_self")),
             H2              =SIMP(statut='o',typ='R',fr=tr("Parametre a_coli")),
             H3              =SIMP(statut='o',typ='R',fr=tr("Parametre a_ncol")),
             H4              =SIMP(statut='f',typ='R',defaut=0.),
             H5              =SIMP(statut='f',typ='R',defaut=0.),
             H6              =SIMP(statut='f',typ='R',defaut=0.),
             DEPDT           =SIMP(statut='f',typ='R',defaut=0.,fr=tr("parametre dEps/dT pour le calcul de DeltaG")),
             MU_MOY          =SIMP(statut='f',typ='R'),
           ),

          MONO_DD_CC_IRRA =FACT(statut='f',
             #TYPE_PARA       =SIMP(statut='f',typ='TXM',into=("ECOU_VISC",),),
             B               =SIMP(statut='o',typ='R',fr=tr("parametre B, en unite de longueur")),
             GH               =SIMP(statut='o',typ='R',fr=tr("parametre H, en unite de 1/temps")),
             DELTAG0         =SIMP(statut='o',typ='R',fr=tr("Gain d energie lie au franchissement d obstacle")),
             TAU_0           =SIMP(statut='o',typ='R',fr=tr("Contraintes , en unite de contraintes ex 20 MPa")),
             TAU_F           =SIMP(statut='o',typ='R',fr=tr("Contraintes , en unite de contraintes ex 20 MPa")),
             GAMMA0          =SIMP(statut='o',typ='R',fr=tr("Vitesse d ecoulement initiale en s**-1")),
             N               =SIMP(statut='o',typ='R',fr=tr("parametre n, sans unite")),
             RHO_MOB         =SIMP(statut='o',typ='R',fr=tr("densite de dislocations mobiles, en unite de longueur **-2")),
             D               =SIMP(statut='o',typ='R',fr=tr("parametre D, en unite de longueur")),
             D_LAT           =SIMP(statut='o',typ='R',fr=tr("parametre D_LAT, en unite de longueur")),
             Y_AT            =SIMP(statut='o',typ='R',fr=tr("parametre Y_AT, en unite de longueur")),
             K_F             =SIMP(statut='o',typ='R',fr=tr("Parametre K_F")),
             K_SELF          =SIMP(statut='o',typ='R',fr=tr("Parametre K_SELF")),
             K_BOLTZ         =SIMP(statut='o',typ='R',fr=tr("Constante de Boltzmann, en eV/K")),
             H1              =SIMP(statut='o',typ='R',fr=tr("Parametre a_self")),
             H2              =SIMP(statut='o',typ='R',fr=tr("Parametre a_coli")),
             H3              =SIMP(statut='o',typ='R',fr=tr("Parametre a_ncol")),
             H4              =SIMP(statut='f',typ='R',defaut=0.),
             H5              =SIMP(statut='f',typ='R',defaut=0.),
             H6              =SIMP(statut='f',typ='R',defaut=0.),
             DEPDT           =SIMP(statut='f',typ='R',defaut=0.,fr=tr("parametre dEps/dT pour le calcul de DeltaG")),
             A_IRRA          =SIMP(statut='o',typ='R',fr=tr("Parametre a_loops pour irradiation")),
             XI_IRRA         =SIMP(statut='o',typ='R',fr=tr("Parametre xi pour irradiation")),
             MU_MOY          =SIMP(statut='f',typ='R'),
           ),


####  FIN MONOCRISTAL

### MFRONT
           MFRONT  =FACT(statut='f',
             LISTE_COEF =SIMP(statut='f',typ='R',min=2,max='**'),
           ),

           MFRONT_FO   =FACT(statut='f',
             LISTE_COEF =SIMP(statut='f',typ=(fonction_sdaster,formule), min=2,max='**'),
           ),
### MFRONT

### UMAT
           UMAT  =FACT(statut='f',
             LISTE_COEF =SIMP(statut='f',typ='R',min=2,max='**'),
           ),

           UMAT_FO   =FACT(statut='f',
             LISTE_COEF =SIMP(statut='f',typ=(fonction_sdaster,formule), min=2,max='**'),
           ),
### UMAT

### CRITERE DE RUPTURE
           CRIT_RUPT      =FACT(statut='f',
             SIGM_C           =SIMP(statut='o',typ='R',fr=tr("contrainte critique")),
             COEF             =SIMP(statut='o',typ='R',fr=tr("E=E/COEF,si la contrainte principale max est atteinte dans l'element")),
           ),
#
### RESTAURATION D'ECROUISSAGE (ANNEALING)
           REST_ECRO      =FACT(statut='f',
             FONC_MULT =SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule)),
           ),
#

           INFO            =SIMP(statut='f',typ='I',defaut=1,into=(1,2) ),
           
           translation={
              "DEFI_MATERIAU": "Define a material",
              "ALPHA" : "Thermal expansion coeficient",
              "AMOR_ALPHA": "Stiffness damping",
              "AMOR_BETA": "Mass damping" ,
              "ELAS": "Linear isotropic elasticity",
              "THER": "Isotropic heat conduction",
              "AMOR_HYST": "Hysteretic damping",
              "LAMBDA": "Thermal conductivity",
              "RHO_CP": "Volumetric heat capacity",
           },
           **C_MFRONT_OFFICIAL()
)
