# coding=utf-8
# --------------------------------------------------------------------
# Copyright (C) 1991 - 2017 - EDF R&D - www.code-aster.org
# This file is part of code_aster.
#
# code_aster is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# code_aster is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with code_aster.  If not, see <http://www.gnu.org/licenses/>.
# --------------------------------------------------------------------

# person_in_charge: mickael.abbas at edf.fr
from code_aster.Cata.Syntax import *
from code_aster.Cata.DataStructure import *
from code_aster.Cata.Commons import *


AFFE_CHAR_MECA=OPER(nom="AFFE_CHAR_MECA",op=   7,sd_prod=char_meca,
                    fr=tr("Affectation de charges et conditions aux limites mécaniques constantes"),
                     reentrant='n',
         regles=(AU_MOINS_UN('EVOL_CHAR','PESANTEUR','ROTATION','DDL_IMPO','DDL_POUTRE','FACE_IMPO',
                             'CHAMNO_IMPO','ARETE_IMPO',
                             'LIAISON_DDL','LIAISON_OBLIQUE','LIAISON_GROUP','LIAISON_MAIL',
                             'LIAISON_CYCL','LIAISON_SOLIDE','LIAISON_ELEM','LIAISON_UNIF',
                             'LIAISON_CHAMNO','LIAISON_RBE3','LIAISON_INTERF','LIAISON_PROJ',
                             'VECT_ASSE',
                             'FORCE_NODALE','FORCE_FACE','FORCE_ARETE','FORCE_CONTOUR','FORCE_INTERNE',
                             'PRE_SIGM','PRES_REP','EFFE_FOND','PRE_EPSI','FORCE_POUTRE','FORCE_TUYAU',
                             'FORCE_COQUE','LIAISON_COQUE','RELA_CINE_BP','FORCE_ELEC','INTE_ELEC',
                             'IMPE_FACE','VITE_FACE','ONDE_FLUI','FLUX_THM_REP','FORCE_SOL',),
                         ),
         VERI_NORM       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
         MODELE          =SIMP(statut='o',typ=(modele_sdaster) ),
         EVOL_CHAR       =SIMP(statut='f',fr=tr("Champ de pression issu d'un autre calcul"),
                               typ=evol_char,min=1,max=1),

         PESANTEUR       =FACT(statut='f',max=1,fr=tr("Champ de pesanteur"),
            GROUP_MA         =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            MAILLE           =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
            GRAVITE          =SIMP(statut='o',typ='R',min=1,max=1),
            DIRECTION        =SIMP(statut='o',typ='R',min=3,max=3),),


         ROTATION        =FACT(statut='f', max=1,
             fr=tr("Définition d'un chargement de rotation"),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(), max='**'),
             MAILLE          =SIMP(statut='c',typ=ma, validators=NoRepeat(),max='**'),
             SANS_GROUP_MA   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             SANS_MAILLE     =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             VITESSE         =SIMP(statut='o', typ='R',min=1,max=1),
             AXE             =SIMP(statut='o', typ='R',min=2, max=3),
             CENTRE          =SIMP(statut='f',typ='R',min=2, max=3),
             b_rotation_tout=BLOC(condition="""(not exists("GROUP_MA")) and (not exists("MAILLE"))""",
                       TOUT     = SIMP(statut='f',typ='TXM',into=("OUI",),defaut="OUI",),),),

         DDL_IMPO        =FACT(statut='f',max='**',
             fr=tr("Impose à des noeuds une ou plusieurs valeurs de déplacement (ou de certaines grandeurs asscociées)"),
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                     AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI',
                                 'TEMP','PRE1','PRE2','UI2','UI3','VI2','VI3','WI2','WI3','UO2',
                                 'UO3','VO2','VO3','WO2','WO3','UI4','UI5','VI4','VI5','WI4',
                                 'WI5','UO4','UO5','VO4','VO5','WO4','WO5','UI6','UO6','VI6',
                                 'VO6','WI6','WO6','WO','WI1','WO1','GONF','LIAISON',
                                 'H1X','H1Y','H1Z','H1PRE1','H2X','H2Y','H2Z','H2PRE1','H3X','H3Y','H3Z','H3PRE1','H4X',
                                 'H4Y','H4Z','K1','K2','K3',
                                 'PRE_FLU','LAG_FLI','LAG_FLS','LAGS_C','LAGS_F1','LAGS_F2',
                                 'PR2_FLU','LA2_FLI','LA2_FLS','LAG2_C','LAG2_F1','LAG2_F2',
                                 'PR3_FLU','LA3_FLI','LA3_FLS','LAG3_C','LAG3_F1','LAG3_F2',
                                 'LAG4_C','LAG4_F1','LAG4_F2',
                                 'V11','V12','V13','V21','V22','V23','V31','V32','V33',
                                 'PRES11','PRES12','PRES13','PRES21','PRES22','PRES23','PRES31','PRES32','PRES33','LH1','GLIS'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_MA   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             SANS_MAILLE     =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             SANS_NOEUD      =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
             LIAISON         =SIMP(statut='f',typ='TXM',into=('ENCASTRE',)),
             DX              =SIMP(statut='f',typ='R' ),
             DY              =SIMP(statut='f',typ='R' ),
             DZ              =SIMP(statut='f',typ='R' ),
             DRX             =SIMP(statut='f',typ='R' ),
             DRY             =SIMP(statut='f',typ='R' ),
             DRZ             =SIMP(statut='f',typ='R' ),
             GRX             =SIMP(statut='f',typ='R' ),
             PRES            =SIMP(statut='f',typ='R' ),
             PHI             =SIMP(statut='f',typ='R' ),
             TEMP            =SIMP(statut='f',typ='R' ),
             PRE1            =SIMP(statut='f',typ='R' ),
             PRE2            =SIMP(statut='f',typ='R' ),
             UI2             =SIMP(statut='f',typ='R' ),
             UI3             =SIMP(statut='f',typ='R' ),
             UI4             =SIMP(statut='f',typ='R' ),
             UI5             =SIMP(statut='f',typ='R' ),
             UI6             =SIMP(statut='f',typ='R' ),
             UO2             =SIMP(statut='f',typ='R' ),
             UO3             =SIMP(statut='f',typ='R' ),
             UO4             =SIMP(statut='f',typ='R' ),
             UO5             =SIMP(statut='f',typ='R' ),
             UO6             =SIMP(statut='f',typ='R' ),
             VI2             =SIMP(statut='f',typ='R' ),
             VI3             =SIMP(statut='f',typ='R' ),
             VI4             =SIMP(statut='f',typ='R' ),
             VI5             =SIMP(statut='f',typ='R' ),
             VI6             =SIMP(statut='f',typ='R' ),
             VO2             =SIMP(statut='f',typ='R' ),
             VO3             =SIMP(statut='f',typ='R' ),
             VO4             =SIMP(statut='f',typ='R' ),
             VO5             =SIMP(statut='f',typ='R' ),
             VO6             =SIMP(statut='f',typ='R' ),
             WI2             =SIMP(statut='f',typ='R' ),
             WI3             =SIMP(statut='f',typ='R' ),
             WI4             =SIMP(statut='f',typ='R' ),
             WI5             =SIMP(statut='f',typ='R' ),
             WI6             =SIMP(statut='f',typ='R' ),
             WO2             =SIMP(statut='f',typ='R' ),
             WO3             =SIMP(statut='f',typ='R' ),
             WO4             =SIMP(statut='f',typ='R' ),
             WO5             =SIMP(statut='f',typ='R' ),
             WO6             =SIMP(statut='f',typ='R' ),
             WO              =SIMP(statut='f',typ='R' ),
             WI1             =SIMP(statut='f',typ='R' ),
             WO1             =SIMP(statut='f',typ='R' ),
             GONF            =SIMP(statut='f',typ='R' ),
             H1X             =SIMP(statut='f',typ='R' ),
             H1Y             =SIMP(statut='f',typ='R' ),
             H1Z             =SIMP(statut='f',typ='R' ),
             H1PRE1          =SIMP(statut='f',typ='R' ),
             H2X             =SIMP(statut='f',typ='R' ),
             H2Y             =SIMP(statut='f',typ='R' ),
             H2Z             =SIMP(statut='f',typ='R' ),
             H2PRE1          =SIMP(statut='f',typ='R' ),
             H3X             =SIMP(statut='f',typ='R' ),
             H3Y             =SIMP(statut='f',typ='R' ),
             H3Z             =SIMP(statut='f',typ='R' ),
             H3PRE1          =SIMP(statut='f',typ='R' ),
             H4X             =SIMP(statut='f',typ='R' ),
             H4Y             =SIMP(statut='f',typ='R' ),
             H4Z             =SIMP(statut='f',typ='R' ),
             K1              =SIMP(statut='f',typ='R' ),
             K2              =SIMP(statut='f',typ='R' ),
             K3              =SIMP(statut='f',typ='R' ),
             PRE_FLU         =SIMP(statut='f',typ='R' ),
             LAG_FLI         =SIMP(statut='f',typ='R' ),
             LAG_FLS         =SIMP(statut='f',typ='R' ),
             PR2_FLU         =SIMP(statut='f',typ='R' ),
             LA2_FLI         =SIMP(statut='f',typ='R' ),
             LA2_FLS         =SIMP(statut='f',typ='R' ),
             PR3_FLU         =SIMP(statut='f',typ='R' ),
             LA3_FLI         =SIMP(statut='f',typ='R' ),
             LA3_FLS         =SIMP(statut='f',typ='R' ),
             LAGS_C          =SIMP(statut='f',typ='R' ),
             LAGS_F1         =SIMP(statut='f',typ='R' ),
             LAGS_F2         =SIMP(statut='f',typ='R' ),
             LAG2_C          =SIMP(statut='f',typ='R' ),
             LAG2_F1         =SIMP(statut='f',typ='R' ),
             LAG2_F2         =SIMP(statut='f',typ='R' ),
             LAG3_C          =SIMP(statut='f',typ='R' ),
             LAG3_F1         =SIMP(statut='f',typ='R' ),
             LAG3_F2         =SIMP(statut='f',typ='R' ),
             LAG4_C          =SIMP(statut='f',typ='R' ),
             LAG4_F1         =SIMP(statut='f',typ='R' ),
             LAG4_F2         =SIMP(statut='f',typ='R' ),
             V11             =SIMP(statut='f',typ='R' ),
             V12             =SIMP(statut='f',typ='R' ),
             V13             =SIMP(statut='f',typ='R' ),
             V21             =SIMP(statut='f',typ='R' ),
             V22             =SIMP(statut='f',typ='R' ),
             V23             =SIMP(statut='f',typ='R' ),
             V31             =SIMP(statut='f',typ='R' ),
             V32             =SIMP(statut='f',typ='R' ),
             V33             =SIMP(statut='f',typ='R' ),
             PRES11          =SIMP(statut='f',typ='R' ),
             PRES12          =SIMP(statut='f',typ='R' ),
             PRES13          =SIMP(statut='f',typ='R' ),
             PRES21          =SIMP(statut='f',typ='R' ),
             PRES22          =SIMP(statut='f',typ='R' ),
             PRES23          =SIMP(statut='f',typ='R' ),
             PRES31          =SIMP(statut='f',typ='R' ),
             PRES32          =SIMP(statut='f',typ='R' ),
             PRES33          =SIMP(statut='f',typ='R' ),
             LH1             =SIMP(statut='f',typ='R' ),
             GLIS            =SIMP(statut='f',typ='R' ),
           ),



         DDL_POUTRE    =FACT(statut='f',max='**',
             fr=tr("Bloque des DDLs dans un repère local d'une poutre"),
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                     AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ'),
                     UN_PARMI('VECT_Y','ANGL_VRIL'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_MA   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             SANS_MAILLE     =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             SANS_NOEUD      =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),


             DX              =SIMP(statut='f',typ='R' ),
             DY              =SIMP(statut='f',typ='R' ),
             DZ              =SIMP(statut='f',typ='R' ),
             DRX             =SIMP(statut='f',typ='R' ),
             DRY             =SIMP(statut='f',typ='R' ),
             DRZ             =SIMP(statut='f',typ='R' ),
#  définition du repère local
             VECT_Y          =SIMP(statut='f',typ='R',min=3,max=3),
             ANGL_VRIL       =SIMP(statut='f',typ='R',),
#  restriction sur les mailles servant à définir le repère local
             GROUP_MA_REPE   =SIMP(statut='f',typ=grma,),
             MAILLE_REPE     =SIMP(statut='c',typ=ma,),
                            ),



           FACE_IMPO       =FACT(statut='f',max='**',
             fr=tr("Impose à tous les noeuds d'une face une ou plusieurs valeurs de déplacement (ou de certaines grandeurs associées)"),
             regles=(UN_PARMI('GROUP_MA','MAILLE',),
                     AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ','GRX','PRES','PHI',
                                 'TEMP','PRE1','PRE2','DNOR','DTAN'),
                     EXCLUS('DNOR','DX'),
                     EXCLUS('DNOR','DY'),
                     EXCLUS('DNOR','DZ'),
                     EXCLUS('DNOR','DRX'),
                     EXCLUS('DNOR','DRY'),
                     EXCLUS('DNOR','DRZ'),
                     EXCLUS('DTAN','DX'),
                     EXCLUS('DTAN','DY'),
                     EXCLUS('DTAN','DZ'),
                     EXCLUS('DTAN','DRX'),
                     EXCLUS('DTAN','DRY'),
                     EXCLUS('DTAN','DRZ'),),
#  rajout d'un mot clé REPERE :/ LOCAL /GLOBAL
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_MA   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             SANS_MAILLE     =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             SANS_NOEUD      =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
             DX              =SIMP(statut='f',typ='R' ),
             DY              =SIMP(statut='f',typ='R' ),
             DZ              =SIMP(statut='f',typ='R' ),
             DRX             =SIMP(statut='f',typ='R' ),
             DRY             =SIMP(statut='f',typ='R' ),
             DRZ             =SIMP(statut='f',typ='R' ),
             DNOR            =SIMP(statut='f',typ='R' ),
             DTAN            =SIMP(statut='f',typ='R' ),
             GRX             =SIMP(statut='f',typ='R' ),
             PRES            =SIMP(statut='f',typ='R' ),
             PHI             =SIMP(statut='f',typ='R' ),
             TEMP            =SIMP(statut='f',typ='R' ),
             PRE1            =SIMP(statut='f',typ='R' ),
             PRE2            =SIMP(statut='f',typ='R' ),
           ),

         CHAMNO_IMPO  =FACT(statut='f',max=1,
             fr=tr("Impose des DDLs aux valeurs d'un concept cham_no_sdaster"),
#  type de cham_no_sdaster CO()
             CHAM_NO         =SIMP(statut='o',typ=cham_no_sdaster), #CO()
             COEF_IMPO       =SIMP(statut='o',typ='R' ),
             NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
           ),

         ARETE_IMPO       =FACT(statut='f',max='**',
             fr=tr("Impose à tous les noeuds d'une arete des elements 3D une ou plusieurs valeurs de déplacement"),
             regles=(UN_PARMI('GROUP_MA','MAILLE',),
                     AU_MOINS_UN('DX','DY','DZ','DTAN','PRES','PHI','TEMP','PRE1','PRE2'),
                     EXCLUS('DTAN','DX'),
                     EXCLUS('DTAN','DY'),
                     EXCLUS('DTAN','DZ'),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_MA   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             SANS_MAILLE     =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             SANS_NOEUD      =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
             DX              =SIMP(statut='f',typ='R' ),
             DY              =SIMP(statut='f',typ='R' ),
             DZ              =SIMP(statut='f',typ='R' ),
             DTAN            =SIMP(statut='f',typ='R' ),
             PRE1            =SIMP(statut='f',typ='R' ),
             PRE2            =SIMP(statut='f',typ='R' ),
             PRES            =SIMP(statut='f',typ='R' ),
             PHI             =SIMP(statut='f',typ='R' ),
             TEMP            =SIMP(statut='f',typ='R' ),
           ),

           LIAISON_DDL     =FACT(statut='f',max='**',
             fr=tr("Définit une relation linéaire entre des DDLs de deux ou plusieurs noeuds"),
             regles=(UN_PARMI('GROUP_NO','NOEUD'),),
             GROUP_NO        =SIMP(statut='f',typ=grno ,max='**'),
             NOEUD           =SIMP(statut='c',typ=no   ,max='**'),
             DDL             =SIMP(statut='o',typ='TXM',max='**'),
             COEF_MULT       =SIMP(statut='o',typ='R'  ,max='**'),
             COEF_IMPO       =SIMP(statut='o',typ='R' ),
           ),

           LIAISON_OBLIQUE =FACT(statut='f',max='**',
             fr=tr("Applique à des noeuds la meme valeur de déplacement définie composante par composante"
              " dans un repère oblique quelconque"),
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE','GROUP_NO','NOEUD'),
                     AU_MOINS_UN('DX','DY','DZ','DRX','DRY','DRZ'),),
             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_MA   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             SANS_MAILLE     =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             SANS_NOEUD      =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
             ANGL_NAUT       =SIMP(statut='o',typ='R',max=3),
             DX              =SIMP(statut='f',typ='R' ),
             DY              =SIMP(statut='f',typ='R' ),
             DZ              =SIMP(statut='f',typ='R' ),
             DRX             =SIMP(statut='f',typ='R' ),
             DRY             =SIMP(statut='f',typ='R' ),
             DRZ             =SIMP(statut='f',typ='R' ),
           ),

           LIAISON_GROUP   =FACT(statut='f',max='**',
             fr=tr("Définit la meme relation linéaire entre certains DDLs de couples de noeuds"),
             regles=(UN_PARMI('GROUP_MA_1','MAILLE_1','GROUP_NO_1','NOEUD_1'),
                     UN_PARMI('GROUP_MA_2','MAILLE_2','GROUP_NO_2','NOEUD_2'),
                     EXCLUS('GROUP_MA_1','GROUP_NO_2'),
                     EXCLUS('GROUP_MA_1','NOEUD_2'),
                     EXCLUS('GROUP_NO_1','GROUP_MA_2'),
                     EXCLUS('GROUP_NO_1','MAILLE_2'),
                     EXCLUS('MAILLE_1','GROUP_NO_2'),
                     EXCLUS('MAILLE_1','NOEUD_2'),
                     EXCLUS('NOEUD_1','GROUP_MA_2'),
                     EXCLUS('NOEUD_1','MAILLE_2'),
                     EXCLUS('SANS_NOEUD','SANS_GROUP_NO'),),

               GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
               MAILLE_1        =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
               GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
               MAILLE_2        =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
               GROUP_NO_1      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
               NOEUD_1         =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
               GROUP_NO_2      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
               NOEUD_2         =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),

             SANS_NOEUD      =SIMP(statut='c',typ=no   ,validators=NoRepeat(),max='**'),
             SANS_GROUP_NO   =SIMP(statut='f',typ=grno ,validators=NoRepeat(),max='**'),
             DDL_1           =SIMP(statut='o',typ='TXM',max='**'),
             COEF_MULT_1     =SIMP(statut='o',typ='R'  ,max='**'),
             DDL_2           =SIMP(statut='o',typ='TXM',max='**'),
             COEF_MULT_2     =SIMP(statut='o',typ='R'  ,max='**'),
             COEF_IMPO       =SIMP(statut='o',typ='R' ),
             SOMMET          =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             TRAN            =SIMP(statut='f',typ='R',max=3),
             ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
             CENTRE          =SIMP(statut='f',typ='R',max=3),
           ),

           LIAISON_MAIL    =FACT(statut='f',max='**',
             fr=tr("Définit des relations linéaires permettant de recoller deux bords d'une structure"),
             regles=(AU_MOINS_UN('GROUP_MA_MAIT','MAILLE_MAIT'),
                     AU_MOINS_UN('GROUP_MA_ESCL','MAILLE_ESCL','GROUP_NO_ESCL','NOEUD_ESCL')),
              GROUP_MA_MAIT   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_MAIT     =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
              GROUP_MA_ESCL   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_ESCL     =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
              GROUP_NO_ESCL   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
              NOEUD_ESCL      =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
              DISTANCE_MAX    =SIMP(statut='f',typ='R'),
              DISTANCE_ALARME =SIMP(statut='f',typ='R'),

              TYPE_RACCORD    =SIMP(statut='o',typ='TXM',defaut="MASSIF",into=("MASSIF","COQUE","COQUE_MASSIF","MASSIF_COQUE",)),

              b_MASSIF     =BLOC ( condition = """equal_to("TYPE_RACCORD", 'MASSIF')""",
                 regles=( PRESENT_PRESENT('DDL_MAIT','DDL_ESCL'),),
              TRAN            =SIMP(statut='f',typ='R',max=3 ),
              ANGL_NAUT       =SIMP(statut='f',typ='R',max=3 ),
              CENTRE          =SIMP(statut='f',typ='R',max=3 ),
              DDL_MAIT        =SIMP(statut='f',typ='TXM',into=("DNOR",) ),
              DDL_ESCL        =SIMP(statut='f',typ='TXM',into=("DNOR",) ),
              ),
              b_COQUE_MASSIF =BLOC ( condition = """equal_to("TYPE_RACCORD", 'COQUE_MASSIF')""",
                 EPAIS           =SIMP(statut='o',typ='R'),
                 CHAM_NORMALE    =SIMP(statut='o',typ=cham_no_sdaster),
              ),
              ELIM_MULT       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
         ),

           LIAISON_PROJ     =FACT(statut='f',max=1,
             fr="Définit des relations linéaires issues de PROJ_CHAMP entre les DDLs d'un même modèle",
             MATR_PROJECTION =SIMP(statut='o',typ=corresp_2_mailla),
             DDL             =SIMP(statut='o',typ='TXM',validators=NoRepeat(),into=('DX','DY','DZ','DRX','DRY','DRZ'),min=1,max=6),
             TYPE            =SIMP(statut='f',typ='TXM',into=('IDENTITE','EXCENTREMENT',),defaut='IDENTITE',),
           ),

           LIAISON_CYCL    =FACT(statut='f',max='**',
             fr=tr("Définit des relations linéaires permettant de recoller les bords de deux parties symétriquement cycliques"),
             regles=(AU_MOINS_UN('GROUP_MA_MAIT1','MAILLE_MAIT1'),
                     AU_MOINS_UN('GROUP_MA_ESCL','MAILLE_ESCL','GROUP_NO_ESCL','NOEUD_ESCL'),
                     PRESENT_PRESENT('DDL_MAIT','DDL_ESCL'),
                     ),
              GROUP_MA_MAIT1   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_MAIT1     =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
              GROUP_MA_MAIT2   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_MAIT2     =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
              GROUP_MA_ESCL   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
              MAILLE_ESCL     =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
              GROUP_NO_ESCL   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
              NOEUD_ESCL     =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
              TRAN            =SIMP(statut='f',typ='R',max=3 ),
              ANGL_NAUT       =SIMP(statut='f',typ='R',max=3 ),
              CENTRE          =SIMP(statut='f',typ='R',max=3 ),
              COEF_MAIT1            =SIMP(statut='f',typ='R',max=1 ),
              COEF_MAIT2            =SIMP(statut='f',typ='R',max=1 ),
              COEF_ESCL            =SIMP(statut='f',typ='R',max=1 ),
              DDL_MAIT        =SIMP(statut='f',typ='TXM',into=("DNOR",) ),
              DDL_ESCL        =SIMP(statut='f',typ='TXM',into=("DNOR",) ),
         ),


           LIAISON_SOLIDE  =FACT(statut='f',max='**',
             fr=tr("Modélise une partie indéformable d'une structure. "
                  "Le mot clé TRAN permettent d'imposer le déplacement de la partie indéformable."),
             regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),),

             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_MA   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             SANS_MAILLE     =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             SANS_NOEUD      =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
             DIST_MIN        =SIMP(statut='f',typ='R'),
             NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
           ),

         LIAISON_ELEM    =FACT(statut='f',max='**',
            fr=tr("Modélise le raccord : d'une partie massive 3D avec une poutre ou avec un tuyau, d'une coque "
                 "avec une poutre ou avec un tuyau, d'une plaque avec une poutre"),
            regles      =(UN_PARMI('GROUP_MA_1','MAILLE_1'), UN_PARMI('GROUP_NO_2','NOEUD_2','GROUP_MA_2','MAILLE_2'),),
            OPTION      =SIMP(statut='o',typ='TXM',into=("3D_TUYAU","3D_POU","3D_POU_ARLEQUIN","2D_POU","COQ_POU","COQ_TUYAU","PLAQ_POUT_ORTH") ),

            GROUP_MA_1  =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            MAILLE_1    =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_NO_2  =SIMP(statut='f',typ=grno),
            NOEUD_2     =SIMP(statut='c',typ=no  ),
            # GROUP_MA_2 est une liste pour "3D_POU_ARLEQUIN" :
            GROUP_MA_2  =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            MAILLE_2    =SIMP(statut='c',typ=ma  ),

            b_3d_pou_arlequin =BLOC( condition = """equal_to("OPTION", '3D_POU_ARLEQUIN')""",
               CARA_ELEM      =SIMP(statut='o',typ=cara_elem ),
               CHAM_MATER     =SIMP(statut='o',typ=cham_mater ),
            ),

            b_plaq_pout_orth =BLOC( condition = """equal_to("OPTION", 'PLAQ_POUT_ORTH')""",
               VERIF_EXCENT   =SIMP(statut='o',typ='TXM',defaut="OUI",into=("OUI","NON") ),
            ),

            b_cara_pout =BLOC( condition = """equal_to("OPTION", 'COQ_POU') or equal_to("OPTION", '3D_TUYAU') or equal_to("OPTION", 'COQ_TUYAU')""",
               CARA_ELEM   =SIMP(statut='o',typ=(cara_elem) ),
               AXE_POUTRE  =SIMP(statut='o',typ='R',max=3),
            ),


            NUME_LAGR   =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
            ANGL_MAX    =SIMP(statut='f',typ='R',defaut= 1. ),

         ),

           LIAISON_UNIF    =FACT(statut='f',max='**',
             fr=tr("Impose une meme valeur (inconnue) à des DDLs d'un ensemble de noeuds"),
             regles=(UN_PARMI('GROUP_NO','NOEUD','GROUP_MA','MAILLE'),),

             GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD           =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_MA   =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             SANS_MAILLE     =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_NO   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             SANS_NOEUD      =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),

             DDL             =SIMP(statut='o',typ='TXM',max='**'),
           ),

         LIAISON_CHAMNO  =FACT(statut='f',max=1,
             fr=tr("Définit une relation linéaire entre tous les DDLs présents dans un concept CHAM_NO"),
#  type de cham_no_sdaster CO()
             CHAM_NO         =SIMP(statut='o',typ=cham_no_sdaster), #CO()
             COEF_IMPO       =SIMP(statut='o',typ='R' ),
             NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
           ),

         LIAISON_RBE3    =FACT(statut='f',max='**',
            fr=tr("Modélise des relations linéaires de type RBE3 entre "
                 "les degrés de liberté d'un noeud maître et des noeuds esclaves."),
            regles          =(UN_PARMI('GROUP_NO_MAIT','NOEUD_MAIT'), UN_PARMI('GROUP_NO_ESCL','NOEUD_ESCL'),),
            GROUP_NO_MAIT   =SIMP(statut='f',typ=grno,max=1),
            NOEUD_MAIT      =SIMP(statut='c',typ=no  ,max=1),
            DDL_MAIT        =SIMP(statut='o',typ='TXM',validators=NoRepeat(),min=1,max=6,into=('DX','DY','DZ','DRX','DRY','DRZ')),
            GROUP_NO_ESCL   =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            NOEUD_ESCL      =SIMP(statut='c',typ=no  ,validators=NoRepeat(),min=1,max='**'),
            DDL_ESCL        =SIMP(statut='o',typ='TXM',min=1,max='**'),
            COEF_ESCL       =SIMP(statut='f',typ='R',min=1,max='**'),
            NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
         ),

         LIAISON_INTERF  =FACT(statut='f',max='**',
             fr=tr("Définit une relation linéaire entre les DDLs d'interface à partir d'un MACRELEM"),
             MACR_ELEM_DYNA  =SIMP(statut='o',typ=macr_elem_dyna),
             TYPE_LIAISON    =SIMP(statut='f',typ='TXM',defaut="RIGIDE",into=("RIGIDE","SOUPLE") ),
           ),

#         SIMP(statut='f',typ='TXM',defaut="NON" ),

         VECT_ASSE       =SIMP(statut='f',typ=cham_no_sdaster ),
#
# FORCES
#
         FORCE_NODALE    =FACT(statut='f',fr=tr("Applique à des noeuds des forces nodales"),max='**',
           regles=(AU_MOINS_UN('GROUP_NO','NOEUD'),
                   AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ' ),),
           GROUP_NO        =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
           NOEUD           =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
           FX              =SIMP(statut='f',typ='R' ),
           FY              =SIMP(statut='f',typ='R' ),
           FZ              =SIMP(statut='f',typ='R' ),
           MX              =SIMP(statut='f',typ='R' ),
           MY              =SIMP(statut='f',typ='R' ),
           MZ              =SIMP(statut='f',typ='R' ),
           ANGL_NAUT       =SIMP(statut='f',typ='R',max=3),
         ),

         FORCE_FACE      =FACT(statut='f',max='**',
             fr=tr("Applique des forces surfaciques sur une face d'élément volumique"),
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FX','FY','FZ'),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             FX              =SIMP(statut='f',typ='R' ),
             FY              =SIMP(statut='f',typ='R' ),
             FZ              =SIMP(statut='f',typ='R' ),
           ),

         FORCE_ARETE     =FACT(statut='f',max='**',
         fr=tr("Applique des forces linéiques à une arete d'élément volumique ou de coque"),
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE',),
                     AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ' ),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             FX              =SIMP(statut='f',typ='R' ),
             FY              =SIMP(statut='f',typ='R' ),
             FZ              =SIMP(statut='f',typ='R' ),
             MX              =SIMP(statut='f',typ='R' ),
             MY              =SIMP(statut='f',typ='R' ),
             MZ              =SIMP(statut='f',typ='R' ),
           ),

         FORCE_CONTOUR   =FACT(statut='f',max='**',
             fr=tr("Applique des forces linéiques au bord d'un domaine 2D ou AXIS ou AXIS_FOURIER"),
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FX','FY','FZ',),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             FX              =SIMP(statut='f',typ='R' ),
             FY              =SIMP(statut='f',typ='R' ),
             FZ              =SIMP(statut='f',typ='R' ),
           ),

         FORCE_INTERNE   =FACT(statut='f',max='**',
             fr=tr("Applique des forces volumiques (2D ou 3D) à un domaine volumique"),
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FX','FY','FZ' ),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             FX              =SIMP(statut='f',typ='R' ),
             FY              =SIMP(statut='f',typ='R' ),
             FZ              =SIMP(statut='f',typ='R' ),
           ),

         PRE_SIGM   =FACT(statut='f',max=1,
             fr=tr("Applique des contraintes volumiques (2D ou 3D) à un domaine volumique"),
             #INST            =SIMP(statut='f',typ='R' ),
             SIGM            =SIMP(statut='o',typ=(cham_elem,carte_sdaster)),
           ),

         PRES_REP        =FACT(statut='f',max='**',
             fr=tr("Applique une pression à un domaine de milieu continu 2D ou 3D, ou à un domaine de coques et tuyaux"),
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE','FISSURE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE','FISSURE'),
                     AU_MOINS_UN('PRES','CISA_2D' ),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             FISSURE         =SIMP(statut='f',typ=fiss_xfem,min=1,max=100,),
             PRES            =SIMP(statut='f',typ='R' ),
             CISA_2D         =SIMP(statut='f',typ='R' ),
           ),

         EFFE_FOND       =FACT(statut='f',max='**',
           fr=tr("Calcul l'effet de fond sur une branche de tuyauterie (modélisation 3D) soumise à une pression"),
           regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),),
           GROUP_MA_INT    =SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**'),
           GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
           MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
           PRES            =SIMP(statut='o',typ='R' ),
         ),

         PRE_EPSI       =FACT(statut='f',max='**',
             fr=tr("Applique un chargement de déformation initiale à un élément 2D, 3D ou de structure"),
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('EPXX','EPYY','EPZZ','EPXY','EPXZ','EPYZ','EPX',
                                 'KY','KZ','EXX','EYY','EXY','KXX','KYY','KXY'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             EPXX            =SIMP(statut='f',typ='R' ),
             EPYY            =SIMP(statut='f',typ='R' ),
             EPZZ            =SIMP(statut='f',typ='R' ),
             EPXY            =SIMP(statut='f',typ='R' ),
             EPXZ            =SIMP(statut='f',typ='R' ),
             EPYZ            =SIMP(statut='f',typ='R' ),
             EPX             =SIMP(statut='f',typ='R' ),
             KY              =SIMP(statut='f',typ='R' ),
             KZ              =SIMP(statut='f',typ='R' ),
             EXX             =SIMP(statut='f',typ='R' ),
             EYY             =SIMP(statut='f',typ='R' ),
             EXY             =SIMP(statut='f',typ='R' ),
             KXX             =SIMP(statut='f',typ='R' ),
             KYY             =SIMP(statut='f',typ='R' ),
             KXY             =SIMP(statut='f',typ='R' ),
           ),

        FORCE_POUTRE    =FACT(statut='f',max='**',
             fr=tr("Applique des forces linéiques sur des éléments de type poutre"),
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     ),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             TYPE_CHARGE     =SIMP(statut='f',typ='TXM',defaut="FORCE",into=("VENT","FORCE",) ),
#  rajour d'un mot clé REPERE :/ LOCAL /GLOBAL
               b_force = BLOC(condition = """equal_to("TYPE_CHARGE", 'FORCE')""",
                          regles=(
                    AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ','N','VY','VZ','MT','MFY','MFZ'),
                   PRESENT_ABSENT('FX','N','VY','VZ','MT','MFY','MFZ'),
                     PRESENT_ABSENT('FY','N','VY','VZ','MT','MFY','MFZ'),
                     PRESENT_ABSENT('FZ','N','VY','VZ','MT','MFY','MFZ'),
                     PRESENT_ABSENT('MX','N','VY','VZ','MT','MFY','MFZ'),
                     PRESENT_ABSENT('MY','N','VY','VZ','MT','MFY','MFZ'),
                     PRESENT_ABSENT('MZ','N','VY','VZ','MT','MFY','MFZ'),
                     PRESENT_ABSENT('N','FX','FY','FZ','MX','MY','MZ'),
                     PRESENT_ABSENT('VY','FX','FY','FZ','MX','MY','MZ'),
                     PRESENT_ABSENT('VZ','FX','FY','FZ','MX','MY','MZ'),
                     PRESENT_ABSENT('MT','FX','FY','FZ','MX','MY','MZ'),
                     PRESENT_ABSENT('MFY','FX','FY','FZ','MX','MY','MZ'),
                     PRESENT_ABSENT('MFZ','FX','FY','FZ','MX','MY','MZ'),),
                    FX              =SIMP(statut='f',typ='R' ),
                    FY              =SIMP(statut='f',typ='R' ),
                    FZ              =SIMP(statut='f',typ='R' ),
                    MX              =SIMP(statut='f',typ='R' ),
                    MY              =SIMP(statut='f',typ='R' ),
                    MZ              =SIMP(statut='f',typ='R' ),
                    N               =SIMP(statut='f',typ='R' ),
                    VY              =SIMP(statut='f',typ='R' ),
                    VZ              =SIMP(statut='f',typ='R' ),
                    MT              =SIMP(statut='f',typ='R' ),
                    MFY             =SIMP(statut='f',typ='R' ),
                    MFZ             =SIMP(statut='f',typ='R' ),
                                  ),
           b_vent = BLOC(condition = """equal_to("TYPE_CHARGE", 'VENT')""",
                         regles=(
                    AU_MOINS_UN('FX','FY','FZ','N','VY','VZ',),
                   PRESENT_ABSENT('FX','N','VY','VZ',),
                     PRESENT_ABSENT('FY','N','VY','VZ',),
                     PRESENT_ABSENT('FZ','N','VY','VZ',),
                     PRESENT_ABSENT('N','FX','FY','FZ',),
                     PRESENT_ABSENT('VY','FX','FY','FZ',),
                     PRESENT_ABSENT('VZ','FX','FY','FZ',),),
                    FX              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
                    FY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
                    FZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
                    N               =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
                    VY              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
                    VZ              =SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
                                  ),

           ),

         FORCE_TUYAU     =FACT(statut='f',max='**',
             fr=tr("Applique une pression sur des éléments TUYAU"),
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             PRES            =SIMP(statut='o',typ='R' ),
           ),

         FORCE_COQUE     =FACT(statut='f',max='**',
             fr=tr("Applique des forces surfaciques sur des éléments de types coques"),
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FX','FY','FZ','MX','MY','MZ','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('FX','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('FY','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('FZ','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('MX','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('MY','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('MZ','PRES','F1','F2','F3','MF1','MF2'),
                     PRESENT_ABSENT('F1','FX','FY','FZ','MX','MY','MZ','PRES'),
                     PRESENT_ABSENT('F2','FX','FY','FZ','MX','MY','MZ','PRES'),
                     PRESENT_ABSENT('F3','FX','FY','FZ','MX','MY','MZ','PRES'),
                     PRESENT_ABSENT('MF1','FX','FY','FZ','MX','MY','MZ','PRES'),
                     PRESENT_ABSENT('MF2','FX','FY','FZ','MX','MY','MZ','PRES'),
                     PRESENT_ABSENT('PRES','FX','FY','FZ','MX','MY','MZ','F1','F2','F3','MF1','MF2'),),
#  rajour d'un mot clé REPERE :/ LOCAL /GLOBAL
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),

               FX              =SIMP(statut='f',typ='R' ),
               FY              =SIMP(statut='f',typ='R' ),
               FZ              =SIMP(statut='f',typ='R' ),
               MX              =SIMP(statut='f',typ='R' ),
               MY              =SIMP(statut='f',typ='R' ),
               MZ              =SIMP(statut='f',typ='R' ),

               F1              =SIMP(statut='f',typ='R' ),
               F2              =SIMP(statut='f',typ='R' ),
               F3              =SIMP(statut='f',typ='R' ),
               MF1             =SIMP(statut='f',typ='R' ),
               MF2             =SIMP(statut='f',typ='R' ),

             PRES            =SIMP(statut='f',typ='R' ),
             PLAN            =SIMP(statut='f',typ='TXM',defaut="MAIL",into=("SUP","INF","MOY","MAIL",) ),
           ),

           LIAISON_COQUE   =FACT(statut='f',max='**',
             fr=tr("Permet de représenter le raccord entre des éléments de coques au moyen des relations linéaires"),
             regles=(AU_MOINS_UN('GROUP_MA_1','MAILLE_1','GROUP_MA_2','MAILLE_2',
                               'GROUP_NO_1','NOEUD_1','GROUP_NO_2','NOEUD_2',),),
             GROUP_MA_1      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE_1        =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_NO_1      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD_1         =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_MA_1 =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             SANS_MAILLE_1   =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_NO_1 =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             SANS_NOEUD_1    =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
             GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE_2        =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_NO_2      =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             NOEUD_2         =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_MA_2 =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             SANS_MAILLE_2   =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             SANS_GROUP_NO_2 =SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
             SANS_NOEUD_2    =SIMP(statut='c',typ=no  ,validators=NoRepeat(),max='**'),
             NUME_LAGR       =SIMP(statut='f',typ='TXM',defaut="NORMAL",into=("NORMAL","APRES") ),
           ),

         RELA_CINE_BP    =FACT(statut='f',max='**',
           fr=tr("Etablir des relations cinématiques permettant de relier les noeuds cable aux noeuds du béton, et spécifier "
                "la prise en compte des contraintes initiales dans les cables"),
           CABLE_BP        =SIMP(statut='o',typ=cabl_precont ),
           RELA_CINE       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON") ),
           b_rela_oui  =BLOC ( condition = """equal_to("RELA_CINE", 'OUI')""",
                  SIGM_BPEL       =SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
                       ),
           b_rela_non  =BLOC ( condition = """equal_to("RELA_CINE", 'NON')""",
                  SIGM_BPEL       =SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI",) ),
                       ),
           TYPE_EPX        =SIMP(statut='f',typ='TXM',defaut="ADHE",into=("ADHE","GLIS","FROT") ),
           DIST_MIN        =SIMP(statut='f',typ='R'),
         ),

         FORCE_ELEC      =FACT(statut='f',max='**',
             fr=tr("Appliquer la force de LAPLACE agissant sur un conducteur principal, due à la présence d'un conducteur "
                  "secondaire droit"),
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),),

             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),

             POSITION        =SIMP(statut='f',typ='TXM',fr=tr("Direction prédéfinie"),into=("PARA","INFI","FINI",) ),
             b_fxyz  =BLOC ( condition = """not exists("POSITION")""",
                  FX   =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
                  FY   =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
                  FZ   =SIMP(statut='f',typ='R',defaut= 0.E+0 ),
                       ),

             b_para     =BLOC ( condition = """equal_to("POSITION", 'PARA')""",
               regles=(UN_PARMI('TRANS','DIST'),),
               TRANS           =SIMP(statut='f',typ='R',max=3),
               DIST            =SIMP(statut='f',typ='R' ),
               b_point2        =BLOC ( condition = """exists("DIST")""",
                 POINT2           =SIMP(statut='o',typ='R',max=3),
               ),
             ),
             b_fini_infi     =BLOC ( condition = """(equal_to("POSITION", 'FINI')) or (equal_to("POSITION", 'INFI'))""",
               POINT1          =SIMP(statut='o',typ='R',max=3),
               POINT2          =SIMP(statut='o',typ='R',max=3),
             ),
           ),




        INTE_ELEC       =FACT(statut='f',max='**',
             fr=tr("Appliquer la force de LAPLACE agissant sur un conducteur principal, due à la présence d'un conducteur "
                  "secondaire non nécessairement droit"),
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('GROUP_MA_2','MAILLE_2','TRANS','SYME'),
                     EXCLUS('TRANS','SYME'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             GROUP_MA_2      =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE_2        =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             TRANS           =SIMP(statut='f',typ='R' ,max='**'),
             SYME            =SIMP(statut='f',typ='R' ,max='**'),
           ),


         IMPE_FACE       =FACT(statut='f',fr=tr("Applique une impédance acoustique à une face"),max='**',
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE' ),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             IMPE            =SIMP(statut='o',typ='R' ),
           ),

         VITE_FACE       =FACT(statut='f',fr=tr("Impose des vitesses normales à une face (phénomène ACOUSTIQUE), "),max='**',
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             VNOR            =SIMP(statut='o',typ='R' ),
           ),



         ONDE_FLUI       =FACT(statut='f',max='**',
             fr=tr("Applique une amplitude de pression d'onde incidente sinusoidale arrivant normalement à une face"),
             regles=(AU_MOINS_UN('GROUP_MA','MAILLE'),),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             PRES            =SIMP(statut='o',typ='R' ),
           ),

         FLUX_THM_REP    =FACT(statut='f',max='**',
             fr=tr("Applique à un domaine de milieu continu 2D ou 3D un flux de chaleur et/ou un apport de masse fluide "
                  "(flux hydraulique)"),
             regles=(AU_MOINS_UN('TOUT','GROUP_MA','MAILLE'),
                     PRESENT_ABSENT('TOUT','GROUP_MA','MAILLE'),
                     AU_MOINS_UN('FLUN','FLUN_HYDR1','FLUN_HYDR2'),),
             TOUT            =SIMP(statut='f',typ='TXM',into=("OUI",) ),
             GROUP_MA        =SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
             MAILLE          =SIMP(statut='c',typ=ma  ,validators=NoRepeat(),max='**'),
             FLUN            =SIMP(statut='f',typ='R' ),
             FLUN_HYDR1      =SIMP(statut='f',typ='R' ),
             FLUN_HYDR2      =SIMP(statut='f',typ='R' ),
           ),
         FORCE_SOL       =FACT(statut='f',max=1,
             fr=tr("Définition des impédances et forces  de sol temporelles"),
           regles=(UN_PARMI('GROUP_NO_INTERF','SUPER_MAILLE'),
                   AU_MOINS_UN('UNITE_RESU_MASS','UNITE_RESU_RIGI','UNITE_RESU_AMOR'),),
           GROUP_NO_INTERF =SIMP(statut='f',typ=grno,),
           SUPER_MAILLE    =SIMP(statut='f',typ=ma,),
           UNITE_RESU_MASS =SIMP(statut='f',typ=UnitType(), inout='in' ),
           UNITE_RESU_RIGI =SIMP(statut='f',typ=UnitType(), inout='in' ),
           UNITE_RESU_AMOR =SIMP(statut='f',typ=UnitType(), inout='in' ),
           UNITE_RESU_FORC =SIMP(statut='f',typ=UnitType(), inout='in' ),
           NB_PAS_TRONCATURE =SIMP(statut='f',typ='I',defaut= 0 ),
           TYPE            =SIMP(statut='f',typ='TXM',defaut="ASCII",into=("BINAIRE","ASCII") ),
         ),

         INFO            =SIMP(statut='f',typ='I',defaut= 1,into=( 1 , 2) ),
         translation={
            "AFFE_CHAR_MECA": "Assign mechanical load",
            "EVOL_CHAR": "Pressure from a result",
         }
)  ;
