# coding=utf-8
# --------------------------------------------------------------------
# Copyright (C) 1991 - 2018 - EDF R&D - www.code-aster.org
# This file is part of code_aster.
#
# code_aster is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# code_aster is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with code_aster.  If not, see <http://www.gnu.org/licenses/>.
# --------------------------------------------------------------------

# person_in_charge: jean-luc.flejou at edf.fr
#
from code_aster.Cata.Syntax import *
from code_aster.Cata.DataStructure import *
from code_aster.Cata.Commons import *


CARA_ELEM=OPER(nom="CARA_ELEM",sd_prod=cara_elem, op= 19,
   fr=tr("NE PAS UTILISER : Affectation de caractéristiques à des éléments de structure"),
   reentrant='n',
   regles = (AU_MOINS_UN('POUTRE','BARRE','COQUE','CABLE','DISCRET','DISCRET_2D','MASSIF',
                         'GRILLE','MEMBRANE','MULTIFIBRE','RIGI_PARASOL','MASS_REP',),
             PRESENT_PRESENT('MULTIFIBRE','GEOM_FIBRE'),
             EXCLUS('DISCRET','DISCRET_2D'),),
   MODELE = SIMP(statut='o',typ=modele_sdaster ),
   INFO   = SIMP(statut='f',typ='I', defaut= 1 ,into=(1,2) ),
   VERIF  = SIMP(statut='f',typ='TXM',validators=NoRepeat(),max='**',into=("MAILLE",) ),
#
# ==============================================================================
    POUTRE  = FACT(statut= 'f',max= '**',
        SECTION = SIMP(statut= 'o',typ= 'TXM' ,into= ("GENERALE","RECTANGLE","CERCLE","COUDE") ),
        b_generale = BLOC(condition = " SECTION == 'GENERALE'",
            regles = (UN_PARMI('MAILLE','GROUP_MA'),),
            MAILLE    = SIMP(statut= 'f',typ= ma  ,validators= NoRepeat(),max= '**'),
            GROUP_MA  = SIMP(statut= 'f',typ= grma,validators= NoRepeat(),max= '**'),
            VARI_SECT = SIMP(statut= 'f',typ= 'TXM',into= ("CONSTANT","HOMOTHETIQUE"),defaut= "CONSTANT"),
            b_constant = BLOC(condition = "VARI_SECT == 'CONSTANT'",
                regles = (PRESENT_ABSENT('TABLE_CARA','CARA'),
                          PRESENT_PRESENT('TABLE_CARA','NOM_SEC'),
                          PRESENT_PRESENT('CARA','VALE'),),
                TABLE_CARA = SIMP(statut= 'f',typ=table_sdaster),
                NOM_SEC    = SIMP(statut= 'f',typ= 'TXM'),
                CARA       = SIMP(statut= 'f',typ= 'TXM',min= 4 ,max= 15,
                    fr= tr("A,IY,IZ,JX sont des paramètres obligatoires"),
                    validators= NoRepeat(),
                    into= ("A","IY","IZ","AY","AZ","EY","EZ","JX","RY","RZ","RT","JG","IYR2","IZR2","AI") ),
                VALE       = SIMP(statut= 'f',typ= 'R',min= 4 ,max= 15),
            ),
            b_homothetique = BLOC(condition = "VARI_SECT == 'HOMOTHETIQUE'",
                CARA = SIMP(statut= 'o',typ= 'TXM',min= 8 ,max= 30,
                    fr= tr("A1,A2,IY1,IY2,IZ1,IZ2,JX1,JX2 sont des paramètres obligatoires"),
                    validators= NoRepeat(),
                    into= ("A1","IY1","IZ1","AY1","AZ1","EY1","EZ1","JX1","RY1", "RZ1","RT1","JG1","IYR21","IZR21","AI1",
                           "A2","IY2","IZ2","AY2","AZ2","EY2","EZ2","JX2","RY2", "RZ2","RT2","JG2","IYR22","IZR22","AI2") ),
                VALE = SIMP(statut= 'o',typ= 'R',min= 8 ,max= 30),
            ),
        ),
        b_rectangle = BLOC(condition = "SECTION == 'RECTANGLE'",
            regles = (UN_PARMI('MAILLE','GROUP_MA'),),
            MAILLE    = SIMP(statut= 'f',typ= ma  ,validators= NoRepeat(),max= '**'),
            GROUP_MA  = SIMP(statut= 'f',typ= grma,validators= NoRepeat(),max= '**'),
            VARI_SECT = SIMP(statut= 'f',typ= 'TXM',into= ("CONSTANT","HOMOTHETIQUE","AFFINE"),defaut= "CONSTANT"),
            b_constant = BLOC(condition = "VARI_SECT == 'CONSTANT'",
                CARA   = SIMP(statut= 'o',typ= 'TXM',min= 1 ,max= 4,
                    validators = NoRepeat(),
                    into= ("H","EP", "HY","HZ","EPY","EPZ"),),
                VALE  = SIMP(statut= 'o',typ= 'R',min= 1 ,max= 4),
            ),
            b_homothetique = BLOC(condition = "VARI_SECT == 'HOMOTHETIQUE'",
                CARA  = SIMP(statut= 'o',typ= 'TXM',min= 2 ,max= 8,
                    validators = NoRepeat(),
                    into= ("H1","HZ1","HY1","EP1","EPY1","EPZ1",
                           "H2","HZ2","HY2","EP2","EPY2","EPZ2") ),
                VALE  = SIMP(statut= 'o',typ= 'R',min= 2 ,max= 8),
            ),
            b_affine = BLOC(condition = "VARI_SECT == 'AFFINE'",
                CARA = SIMP(statut= 'o',typ= 'TXM',min= 3 ,max= 6,
                    validators= NoRepeat() ,
                    into= ("HY","EPY", "HZ1","EPZ1","HZ2","EPZ2") ),
                VALE = SIMP(statut= 'o',typ= 'R',min= 3 ,max= 6),
            ),
        ),
        b_cercle = BLOC(condition = " SECTION == 'CERCLE'",
            VARI_SECT = SIMP(statut= 'f',typ= 'TXM',into= ("CONSTANT","HOMOTHETIQUE"),defaut= "CONSTANT"),
            b_constant = BLOC(condition = "VARI_SECT == 'CONSTANT'",
                regles = (UN_PARMI('MAILLE','GROUP_MA'),),
                MAILLE   = SIMP(statut= 'f',typ= ma  ,validators= NoRepeat(),max= '**'),
                GROUP_MA = SIMP(statut= 'f',typ= grma,validators= NoRepeat(),max= '**'),
                CARA     = SIMP(statut= 'o',typ= 'TXM',min=1, max=2,
                    validators= NoRepeat() ,
                    fr= tr("R est un paramètre obligatoire"),
                    into= ("R","EP") ),
                VALE     = SIMP(statut= 'o',typ= 'R',min=1, max=2,),
            ),
            b_homothetique = BLOC(condition = "VARI_SECT == 'HOMOTHETIQUE'",
                regles = (UN_PARMI('MAILLE','GROUP_MA'),),
                MAILLE   = SIMP(statut= 'f',typ= ma  ,validators= NoRepeat(),max= '**'),
                GROUP_MA = SIMP(statut= 'f',typ= grma,validators= NoRepeat(),max= '**'),
                b_maille = BLOC(condition = "MAILLE != None",
                    CARA = SIMP(statut= 'o',typ= 'TXM', min=2, max=4,
                        validators= NoRepeat() ,
                        fr= tr("R1, R2 sont des paramètres obligatoires"),
                        into= ("R1","R2","EP1","EP2") ),
                ),
                b_grma  = BLOC(condition = "GROUP_MA != None",
                    CARA = SIMP(statut= 'o',typ= 'TXM', min=2, max= 4,
                        validators= NoRepeat(),
                        fr= tr("R_DEBUT, R_FIN sont des paramètres obligatoires"),
                        into= ("R_DEBUT","R_FIN","EP_DEBUT","EP_FIN") ),
                ),
                VALE = SIMP(statut= 'o',typ= 'R',min= 2 ,max= 4),
            ),
            MODI_METRIQUE = SIMP(statut= 'f',typ= 'TXM',defaut= "NON",into= ("OUI","NON") ),
            FCX           = SIMP(statut= 'f',typ= (fonction_sdaster,nappe_sdaster,formule) ),
            TUYAU_NSEC    = SIMP(statut= 'f',typ= 'I',val_max= 32, val_min=8, defaut= 16),
            TUYAU_NCOU    = SIMP(statut= 'f',typ= 'I',val_max= 10, val_min=1, defaut= 3),
        ),
        b_coude = BLOC(condition = " SECTION == 'COUDE'",
            regles=(UN_PARMI('MAILLE','GROUP_MA'),
                    EXCLUS('COEF_FLEX','COEF_FLEX_XY'),
                    EXCLUS('COEF_FLEX','COEF_FLEX_XZ'),
                    EXCLUS('INDI_SIGM','INDI_SIGM_XY'),
                    EXCLUS('INDI_SIGM','INDI_SIGM_XZ'),
                    PRESENT_PRESENT('COEF_FLEX_XY','COEF_FLEX_XZ'),
                    PRESENT_PRESENT('INDI_SIGM_XY','INDI_SIGM_XZ'),),
            MAILLE          = SIMP(statut='f',typ= ma  ,validators= NoRepeat(),max= '**'),
            GROUP_MA        = SIMP(statut='f',typ= grma,validators= NoRepeat(),max= '**'),
            COEF_FLEX       = SIMP(statut='f',typ='R',val_min=0.0),
            INDI_SIGM       = SIMP(statut='f',typ='R',val_min=0.0),
            COEF_FLEX_XY    = SIMP(statut='f',typ='R',val_min=0.0),
            INDI_SIGM_XY    = SIMP(statut='f',typ='R',val_min=0.0),
            COEF_FLEX_XZ    = SIMP(statut='f',typ='R',val_min=0.0),
            INDI_SIGM_XZ    = SIMP(statut='f',typ='R',val_min=0.0),
        ),
    ),
#
# ============================================================================
    BARRE = FACT(statut='f',max='**',
        regles = (UN_PARMI('MAILLE','GROUP_MA'),),
        MAILLE = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
        GROUP_MA = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
        SECTION  = SIMP(statut='o',typ='TXM',into=("GENERALE","RECTANGLE","CERCLE") ),
        b_generale = BLOC(condition = "SECTION=='GENERALE'",
            regles = (PRESENT_ABSENT('TABLE_CARA','CARA'),
                      PRESENT_PRESENT('TABLE_CARA','NOM_SEC'),
                      PRESENT_PRESENT('CARA','VALE')),
            TABLE_CARA = SIMP(statut='f',typ=table_sdaster),
            NOM_SEC    = SIMP(statut='f',typ='TXM'),
            CARA       = SIMP(statut='f',typ='TXM',into=("A",) ),
            VALE       = SIMP(statut='f',typ='R',min=1,max=1 ),
        ),
        b_rectangle = BLOC(condition = "SECTION=='RECTANGLE'",
            CARA = SIMP(statut='o',typ='TXM', min=1, max=4,
                validators = NoRepeat(),
                into=("H","EP","HZ","HY","EPY","EPZ"), ),
            VALE = SIMP(statut='o',typ='R',min=1,max=4 ), ),
        b_cercle = BLOC(condition = "SECTION=='CERCLE'",
            CARA = SIMP(statut='o',typ='TXM',validators=NoRepeat(),min=1,max=2,into=("R","EP") ),
            VALE = SIMP(statut='o',typ='R',min=1,max=2 ), ),
      FCX = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
   ),

#  ============================================================================
   COQUE                = FACT(statut='f',max='**',
      regles               = (UN_PARMI('MAILLE','GROUP_MA' ),
                              EXCLUS('ANGL_REP','VECTEUR'),
                              PRESENT_PRESENT( 'EXCENTREMENT',   'INER_ROTA' ),
                              PRESENT_PRESENT( 'EXCENTREMENT_FO','INER_ROTA' ),
                              UN_PARMI('EPAIS','EPAIS_FO' ),
                              EXCLUS('EXCENTREMENT','EXCENTREMENT_FO'),),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      EPAIS                = SIMP(statut='f',typ='R' ),
      EPAIS_FO             = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
      ANGL_REP             = SIMP(statut='f',typ='R',min=2,max=2),
      VECTEUR              = SIMP(statut='f',typ='R',min=3,max=3),
      A_CIS                = SIMP(statut='f',typ='R',defaut= 0.8333333E0),
      COEF_RIGI_DRZ        = SIMP(statut='f',typ='R',defaut= 1.0E-5 ),
      COQUE_NCOU           = SIMP(statut='f',typ='I',defaut= 1 ),
      EXCENTREMENT         = SIMP(statut='f',typ='R' ),
      EXCENTREMENT_FO      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
      INER_ROTA            = SIMP(statut='f',typ='TXM',into=("OUI",) ),
      MODI_METRIQUE        = SIMP(statut='f',typ='TXM',defaut="NON",into=("OUI","NON") ),
   ),

#  ============================================================================
   CABLE                = FACT(statut='f',max='**',
      regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      N_INIT               = SIMP(statut='o',typ='R'),
      SECTION              = SIMP(statut='o',typ='R'),
      FCX                  = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
   ),

#  ============================================================================
   DISCRET              = FACT(statut='f',max='**',
      REPERE               = SIMP(statut='f',typ='TXM',into=("LOCAL","GLOBAL") ),
      AMOR_HYST            = SIMP(statut='f',typ='R' ),

      SYME                 = SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON"),),
      b_SYME_OUI           = BLOC(condition="SYME=='OUI'",
         fr=tr("SYMETRIQUE: Affectation de matrices de rigidité, de masse ou d'amortissement à des mailles"),
         CARA                 = SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=1,defaut="None",
            into=("K_T_D_N", "K_T_D_L", "K_TR_D_N", "K_TR_D_L", "K_T_N", "K_T_L", "K_TR_N", "K_TR_L",
                  "M_T_D_N", "M_T_D_L", "M_TR_D_N", "M_TR_D_L", "M_T_N", "M_T_L", "M_TR_N", "M_TR_L",
                  "A_T_D_N", "A_T_D_L", "A_TR_D_N", "A_TR_D_L", "A_T_N", "A_T_L", "A_TR_N", "A_TR_L",),),
         #  Affection des caractéristiques de RIGIDITE/AMORTISSEMENT/MASSE
         b_AK_T_D_N            = BLOC(condition = "((CARA=='K_T_D_N')or(CARA=='A_T_D_N'))",
            fr=tr("POI1: 3 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=3 ,max=3 ),),
         b_AK_T_D_L            = BLOC(condition = "((CARA=='K_T_D_L')or(CARA=='A_T_D_L'))",
            fr=tr("SEGMENT: 3 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=3 ,max=3 ),),
         b_AK_TR_D_N           = BLOC(condition = "((CARA=='K_TR_D_N')or(CARA=='A_TR_D_N'))",
            fr=tr("POI1: 6 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=6 ,max=6 ),),
         b_AK_TR_D_L           = BLOC(condition = "((CARA=='K_TR_D_L')or(CARA=='A_TR_D_L'))",
            fr=tr("SEGMENT: 6 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=6 ,max=6 ),),
         b_MAK_T_N              = BLOC(condition = "((CARA=='K_T_N')or(CARA=='A_T_N')or(CARA=='M_T_N'))",
            fr=tr("POI1: 6 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=6 ,max=6 ),),
         b_MAK_T_L              = BLOC(condition = "((CARA=='K_T_L')or(CARA=='A_T_L')or(CARA=='M_T_L'))",
            fr=tr("SEGMENT: 21 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=21,max=21),),
         b_MAK_TR_N             = BLOC(condition = "((CARA=='K_TR_N')or(CARA=='A_TR_N')or(CARA=='M_TR_N'))",
            fr=tr("POI1: 21 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=21,max=21),),
         b_MAK_TR_L             = BLOC(condition = "((CARA=='K_TR_L')or(CARA=='A_TR_L')or(CARA=='M_TR_L'))",
            fr=tr("SEGMENT: 78 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=78,max=78),),
         #  Affection des caractéristiques de MASSE
         b_M_T_D_N           = BLOC(condition = "(CARA=='M_T_D_N')",
            fr=tr("POI1: 1 valeur de masse"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=1 ,max=1 ),),
         b_M_T_D_L           = BLOC(condition = "(CARA=='M_T_D_L')",
            fr=tr("SEGMENT: 1 valeur de masse"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=1 ,max=1 ),),
         b_M_TR_D_N           = BLOC(condition = "(CARA=='M_TR_D_N')",
            fr=tr("POI1: 1 valeur de masse, 6 valeurs du tenseur d'inertie, 3 composantes du vecteur d'excentrement"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=10,max=10),),
         b_M_TR_D_L           = BLOC(condition = "(CARA=='M_TR_D_L')",
            fr=tr("SEGMENT: 1 valeur de masse, 3 valeurs du tenseur d'inertie"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=4,max=4),),
      ),
      #     éléments à matrice non-symétrique
      #        b_MAK_T_N_NS       'K_T_N'     'A_T_N'    'M_T_N'
      #        b_MAK_T_L_NS       'K_T_L'     'A_T_L'    'M_T_L'
      #        b_MAK_TR_N_NS      'K_TR_N'    'A_TR_N'   'M_TR_N'
      #        b_MAK_TR_L_NS      'K_TR_L'    'A_TR_L'   'M_TR_L'
      b_SYME_NON           = BLOC(condition="SYME=='NON'",
         fr=tr("NON-SYMETRIQUE: Affectation de matrices de rigidité, de masse ou d'amortissement à des mailles"),
         CARA                 = SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=1,defaut="None",
            into=("K_T_N", "K_T_L", "K_TR_N", "K_TR_L",
                  "M_T_N", "M_T_L", "M_TR_N", "M_TR_L",
                  "A_T_N", "A_T_L", "A_TR_N", "A_TR_L",),),
         #  Affection des caractéristiques de RIGIDITE/AMORTISSEMENT/MASSE : NON-SYMETRIQUE
         b_MAK_T_N_NS           = BLOC(condition = "((CARA=='K_T_N')or(CARA=='A_T_N')or(CARA=='M_T_N'))",
            fr=tr("POI1: 9 valeurs (matrice pleine par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=9 ,max=9 ),),
         b_MAK_T_L_NS           = BLOC(condition = "((CARA=='K_T_L')or(CARA=='A_T_L')or(CARA=='M_T_L'))",
            fr=tr("SEGMENT: 36 valeurs (matrice pleine par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=36,max=36),),
         b_MAK_TR_N_NS          = BLOC(condition = "((CARA=='K_TR_N')or(CARA=='A_TR_N')or(CARA=='M_TR_N'))",
            fr=tr("POI1: 36 valeurs (matrice pleine par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=36,max=36),),
         b_MAK_TR_L_NS          = BLOC(condition = "((CARA=='K_TR_L')or(CARA=='A_TR_L')or(CARA=='M_TR_L'))",
            fr=tr("SEGMENT: 144 valeurs (matrice pleine par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=144,max=144),),
      ),
   ),
#  ============================================================================
   DISCRET_2D           = FACT(statut='f',max='**',
      REPERE               = SIMP(statut='f',typ='TXM',into=("LOCAL","GLOBAL") ),
      AMOR_HYST            = SIMP(statut='f',typ='R' ),
      SYME                 = SIMP(statut='f',typ='TXM',defaut="OUI",into=("OUI","NON"),),
      b_SYME_OUI           = BLOC(condition="SYME=='OUI'",
         fr=tr("SYMETRIQUE: Affectation de matrices de rigidité, de masse ou d'amortissement à des mailles"),
         CARA                 = SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=1,defaut="None",
            into=("K_T_D_N", "K_T_D_L", "K_TR_D_N", "K_TR_D_L", "K_T_N", "K_T_L", "K_TR_N", "K_TR_L",
                  "M_T_D_N", "M_T_D_L", "M_TR_D_N", "M_TR_D_L", "M_T_N", "M_T_L", "M_TR_N", "M_TR_L",
                  "A_T_D_N", "A_T_D_L", "A_TR_D_N", "A_TR_D_L", "A_T_N", "A_T_L", "A_TR_N", "A_TR_L",),),
         #  Affection des caractéristiques de RIGIDITE/AMORTISSEMENT/MASSE
         b_AK_T_D_N            = BLOC(condition = "((CARA=='K_T_D_N')or(CARA=='A_T_D_N'))",
            fr=tr("POI1: 2 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=2 ,max=2 ),),
         b_AK_T_D_L            = BLOC(condition = "((CARA=='K_T_D_L')or(CARA=='A_T_D_L'))",
            fr=tr("SEGMENT: 2 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=2 ,max=2 ),),
         b_AK_TR_D_N           = BLOC(condition = "((CARA=='K_TR_D_N')or(CARA=='A_TR_D_N'))",
            fr=tr("POI1: 3 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=3 ,max=3 ),),
         b_AK_TR_D_L           = BLOC(condition = "((CARA=='K_TR_D_L')or(CARA=='A_TR_D_L'))",
            fr=tr("SEGMENT: 3 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=3 ,max=3 ),),
         b_MAK_T_N              = BLOC(condition = "((CARA=='K_T_N')or(CARA=='A_T_N')or(CARA=='M_T_N'))",
            fr=tr("POI1: 3 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=3 ,max=3 ),),
         b_MAK_T_L              = BLOC(condition = "((CARA=='K_T_L')or(CARA=='A_T_L')or(CARA=='M_T_L'))",
            fr=tr("SEGMENT: 10 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=10,max=10),),
         b_MAK_TR_N             = BLOC(condition = "((CARA=='K_TR_N')or(CARA=='A_TR_N')or(CARA=='M_TR_N'))",
            fr=tr("POI1: 6 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=6 ,max=6),),
         b_MAK_TR_L             = BLOC(condition = "((CARA=='K_TR_L')or(CARA=='A_TR_L')or(CARA=='M_TR_L'))",
            fr=tr("SEGMENT: 21 valeurs (triangulaire supérieure par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=21,max=21),),
         #  Affection des caractéristiques de MASSE
         b_M_T_D_N            = BLOC(condition = "(CARA=='M_T_D_N')",
            fr=tr("POI1: 1 valeur de masse"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=1 ,max=1 ),),
         b_M_T_D_L            = BLOC(condition = "(CARA=='M_T_D_L')",
            fr=tr("SEGMENT: 1 valeur de masse"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=1 ,max=1 ),),
         b_M_TR_D_N           = BLOC(condition = "(CARA=='M_TR_D_N')",
            fr=tr("POI1: 1 valeur de masse, 1 valeur d'inertie, 2 composantes du vecteur d'excentrement"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=4 ,max=4 ),),
         b_M_TR_D_L           = BLOC(condition = "(CARA=='M_TR_D_L')",
            fr=tr("SEGMENT: 1 valeur de masse, 1 valeur d'inertie"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=2 ,max=2 ),),
      ),
      #     éléments à matrice non-symétrique
      #        b_MAK_T_N_NS       'K_T_N'     'A_T_N'    'M_T_N'
      #        b_MAK_T_L_NS       'K_T_L'     'A_T_L'    'M_T_L'
      #        b_MAK_TR_N_NS      'K_TR_N'    'A_TR_N'   'M_TR_N'
      #        b_MAK_TR_L_NS      'K_TR_L'    'A_TR_L'   'M_TR_L'
      b_SYME_NON           = BLOC(condition="SYME=='NON'",
         fr=tr("NON-SYMETRIQUE: Affectation de matrices de rigidité, de masse ou d'amortissement à des mailles"),
         CARA                 = SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=1,defaut="None",
            into=("K_T_N", "K_T_L", "K_TR_N", "K_TR_L",
                  "M_T_N", "M_T_L", "M_TR_N", "M_TR_L",
                  "A_T_N", "A_T_L", "A_TR_N", "A_TR_L",),),
         #  Affection des caractéristiques de RIGIDITE/AMORTISSEMENT/MASSE : NON-SYMETRIQUE
         b_MAK_T_N_NS           = BLOC(condition = "((CARA=='K_T_N')or(CARA=='A_T_N')or(CARA=='M_T_N'))",
            fr=tr("POI1: 4 valeurs (matrice pleine par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=4 ,max=4 ),),
         b_MAK_T_L_NS           = BLOC(condition = "((CARA=='K_T_L')or(CARA=='A_T_L')or(CARA=='M_T_L'))",
            fr=tr("SEGMENT: 16 valeurs (matrice pleine par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=16,max=16),),
         b_MAK_TR_N_NS          = BLOC(condition = "((CARA=='K_TR_N')or(CARA=='A_TR_N')or(CARA=='M_TR_N'))",
            fr=tr("POI1: 9 valeurs (matrice pleine par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=9 ,max=9),),
         b_MAK_TR_L_NS          = BLOC(condition = "((CARA=='K_TR_L')or(CARA=='A_TR_L')or(CARA=='M_TR_L'))",
            fr=tr("SEGMENT: 36 valeurs (matrice pleine par colonne)"),
            regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
            MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE                 = SIMP(statut='o',typ='R',min=36,max=36),),
      ),
   ),
#
#  ============================================================================
    ORIENTATION = FACT(statut='f',max='**',
        CARA  = SIMP(statut='o',typ='TXM', into=("VECT_Y","ANGL_VRIL","VECT_X_Y","ANGL_NAUT","GENE_TUYAU"),),
        b_cara_vect_y = BLOC(condition = "(CARA=='VECT_Y')", fr=tr("Maille de longueur non nulle."),
            regles = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE    = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA  = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE      = SIMP(statut='o',typ='R',max=3,min=3, fr=tr("Vecteur dont la projection sur le plan normal à l'axe X local donne Y local."),),
            PRECISION = SIMP(statut='f',typ='R', fr=tr("valeur en-dessous de laquelle la maille est considérée comme de longueur nulle"),),
        ),
        b_cara_angl_vril = BLOC(condition = "(CARA=='ANGL_VRIL')", fr=tr("Maille de longueur non nulle."),
            regles = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE    = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA  = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE      = SIMP(statut='o',typ='R', fr=tr("Angle de rotation du repère autour de l'axe X local."),),
            PRECISION = SIMP(statut='f',typ='R', fr=tr("valeur en-dessous de laquelle la maille est considérée comme de longueur nulle")),
        ),
        b_cara_vect_x_y = BLOC(condition = "(CARA=='VECT_X_Y')", fr=tr("Maille de longueur nulle."),
            regles = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE    = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA  = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE      = SIMP(statut='o',typ='R',max=6,min=6, fr=tr("Les 2 vecteurs formant les axes X et Y locaux."),),
            PRECISION = SIMP(statut='f',typ='R', fr=tr("valeur en-dessous de laquelle la maille est considérée comme de longueur nulle")),
        ),
        b_cara_angl_naut = BLOC(condition = "(CARA=='ANGL_NAUT')", fr=tr("Maille de longueur nulle."),
            regles = (UN_PARMI('MAILLE','GROUP_MA',),),
            MAILLE    = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
            GROUP_MA  = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
            VALE      = SIMP(statut='o',typ='R',max=3,min=3, fr=tr("Les 3 angles nautiques alpha, beta, gamma.")),
            PRECISION = SIMP(statut='f',typ='R', fr=tr("valeur en-dessous de laquelle la maille est considérée comme de longueur nulle")),
        ),
        b_cara_gene_tuyau = BLOC(condition = "(CARA=='GENE_TUYAU')", fr=tr("Orientation des tuyaux."),
            regles = (UN_PARMI('NOEUD','GROUP_NO',),),
            NOEUD     = SIMP(statut='f',typ=no  ,validators=NoRepeat(),max='**'),
            GROUP_NO  = SIMP(statut='f',typ=grno,validators=NoRepeat(),max='**'),
            VALE      = SIMP(statut='o',typ='R', max=3,min=3, fr=tr("Vecteur donnant la position de la génératrice.")),
            PRECISION = SIMP(statut='f',typ='R', defaut= 1.0E-4 ),
            CRITERE   = SIMP(statut='f',typ='TXM',defaut="RELATIF",into=("RELATIF","ABSOLU") ),
        ),
    ),
#
#============================================================================
   MASSIF               = FACT(statut='f',max='**',
      regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                              UN_PARMI('ANGL_REP','ANGL_AXE','ANGL_EULER'),
                              EXCLUS('ANGL_REP','ANGL_EULER'),
                              EXCLUS('ANGL_REP','ANGL_AXE'),
                              EXCLUS('ANGL_REP','ORIG_AXE'),
                              PRESENT_PRESENT('ANGL_AXE','ORIG_AXE'), ),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      ANGL_REP             = SIMP(statut='f',typ='R',max=3),
      ANGL_EULER           = SIMP(statut='f',typ='R',min=3,max=3),
      ANGL_AXE             = SIMP(statut='f',typ='R',max=2),
      ORIG_AXE             = SIMP(statut='f',typ='R',max=3),
   ),

#  ============================================================================
   POUTRE_FLUI          = FACT(statut='f',max='**',
      regles               = (UN_PARMI('MAILLE','GROUP_MA'),),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      B_T                  = SIMP(statut='o',typ='R'),
      B_N                  = SIMP(statut='o',typ='R'),
      B_TN                 = SIMP(statut='o',typ='R',defaut= 0.E+0 ),
      A_FLUI               = SIMP(statut='o',typ='R'),
      A_CELL               = SIMP(statut='o',typ='R'),
      COEF_ECHELLE         = SIMP(statut='o',typ='R'),
   ),

#  ============================================================================
   GRILLE               = FACT(statut='f',max='**',
      regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                              EXCLUS('ANGL_REP','AXE'),
                              UN_PARMI('SECTION','SECTION_FO' ),
                              EXCLUS('EXCENTREMENT','EXCENTREMENT_FO'), ),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      SECTION              = SIMP(statut='f',typ='R'),
      SECTION_FO           = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
      ANGL_REP             = SIMP(statut='f',typ='R',max=2),
      EXCENTREMENT         = SIMP(statut='f',typ='R'),
      EXCENTREMENT_FO      = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
      AXE                  = SIMP(statut='f',typ='R',max='**'),
      COEF_RIGI_DRZ        = SIMP(statut='f',typ='R',defaut= 1.0E-10 ),
   ),

#  ============================================================================
   MEMBRANE             = FACT(statut='f',max='**',
      regles               = (UN_PARMI('MAILLE','GROUP_MA'),
                              EXCLUS('ANGL_REP','AXE'),
                              ),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      EPAIS                = SIMP(statut='f',typ='R'),
      ANGL_REP             = SIMP(statut='f',typ='R',max=2),
      AXE                  = SIMP(statut='f',typ='R',max='**'),
      N_INIT               = SIMP(statut='f',typ='R'),
   ),
#
#============================================================================
   RIGI_PARASOL = FACT(statut='f',max='**',
      regles = (UN_PARMI('COEF_GROUP','FONC_GROUP'),
                UN_PARMI('COOR_CENTRE','NOEUD_CENTRE','GROUP_NO_CENTRE'),
                UN_PARMI('GROUP_MA_POI1','GROUP_MA_SEG2'),),
      GROUP_MA      = SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**',
                           fr=tr("Surface servant à répartir les caractéristiques des discrets")),
      GROUP_MA_POI1 = SIMP(statut='f',typ=grma,validators=NoRepeat(),max=1,
                           fr=tr("Mailles de type point correspondant aux discrets")),
      GROUP_MA_SEG2 = SIMP(statut='f',typ=grma,validators=NoRepeat(),max=1,
                           fr=tr("Mailles de type seg2 correspondant aux discrets")),
      FONC_GROUP   = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule) ),
      COEF_GROUP   = SIMP(statut='f',typ='R',max='**'),
      REPERE       = SIMP(statut='f',typ='TXM',into=("LOCAL","GLOBAL") ),
      CARA         = SIMP(statut='o',typ='TXM',validators=NoRepeat(),max=2,
                          into=("K_TR_D_N","K_T_D_N","K_TR_D_L","K_T_D_L",
                                "A_TR_D_N","A_T_D_N","A_TR_D_L","A_T_D_L"),
                          fr=tr("Choix des types de discrets du tapis de ressorts.") ),
      b_cara = BLOC(condition ="""CARA and (len(CARA)==1  or (len(CARA)==2 and CARA[0][2:]==CARA[1][2:]))""",
                    fr=tr("Valeurs pour les discrets du tapis de ressorts."),
         VALE = SIMP(statut='o',typ='R',max='**',
                     fr=tr("Valeurs pour les discrets du tapis de ressorts."),),
      ),
      GROUP_NO_CENTRE = SIMP(statut='f',typ=grno),
      NOEUD_CENTRE    = SIMP(statut='f',typ=no),
      COOR_CENTRE     = SIMP(statut='f',typ='R',min=2,max=3),
      EUROPLEXUS      = SIMP(statut='f',typ='TXM',into=("OUI","NON"),defaut="NON"),
      UNITE           = SIMP(statut='f',typ='I',val_min=1),
   ),
#
#============================================================================
   RIGI_MISS_3D         = FACT(statut='f',max='**',
      GROUP_MA_POI1        = SIMP(statut='o',typ=grma,max=1),
      GROUP_MA_SEG2        = SIMP(statut='f',typ=grma,max=1),
      FREQ_EXTR            = SIMP(statut='o',typ='R',max=1),
      UNITE_RESU_IMPE      = SIMP(statut='f',typ='I',defaut=30),
   ),

#============================================================================
   MASS_AJOU            = FACT(statut='f',max='**',
      GROUP_MA             = SIMP(statut='o',typ=grma,validators=NoRepeat(),max='**',
         fr=tr("Surface servant à répartir les caractéristiques des discrets")),
      GROUP_MA_POI1        = SIMP(statut='o',typ=grma,validators=NoRepeat(),max=1,
         fr=tr("Mailles de type point correspondant aux discrets")),
      FONC_GROUP           = SIMP(statut='o',typ=(fonction_sdaster,nappe_sdaster,formule) ),
   ),
#
# ==============================================================================
    MASS_REP = FACT(statut='f',max='**',
        fr = tr("Masse répartie sur des POI1, pondérée par la surface des mailles connectées."),
        GROUP_MA         = SIMP(statut='o',typ=grma,validators=NoRepeat(),max=1,
                            fr = tr("Surface ou ligne servant à répartir la masse"),),
        GROUP_MA_POI1    = SIMP(statut='o',typ=grma,validators=NoRepeat(),max=1,
                            fr = tr("Mailles de type POI1 correspondant aux masses."),),
        VALE             = SIMP(statut='o',typ='R',max=1,
                            fr = tr("Valeur de la masse à répartir sur les mailles de GROUP_MA."),),
        TYPE             = SIMP(statut='o',typ='TXM',max=1, into=('TOTALE','LINEIQUE','SURFACIQUE'),
                            fr = tr("Type de la masse"),),
        FONC_MULT        = SIMP(statut='f',typ=(fonction_sdaster,nappe_sdaster,formule),max=1,
                            fr = tr("Fonction (X,Y,Z) multiplicatrice de la masse."),),
    ),
#
#============================================================================
   GEOM_FIBRE           = SIMP(statut='f',max=1,typ=gfibre_sdaster,
      fr=tr("Donner le nom de la SD regroupant tous les groupes de fibres (issue de DEFI_GEOM_FIBRE)")),

   MULTIFIBRE           = FACT(statut='f',max='**',
      regles               = (AU_MOINS_UN('GROUP_MA','MAILLE'),),
      GROUP_MA             = SIMP(statut='f',typ=grma,validators=NoRepeat(),max='**'),
      MAILLE               = SIMP(statut='f',typ=ma  ,validators=NoRepeat(),max='**'),
      GROUP_FIBRE          = SIMP(statut='o',typ='TXM',max='**'),
      PREC_AIRE            = SIMP(statut= 'f',typ= 'R',defaut= 0.01),
      PREC_INERTIE         = SIMP(statut= 'f',typ= 'R',defaut= 0.1),
   ),
);
