# coding=utf-8
# --------------------------------------------------------------------
# Copyright (C) 1991 - 2017 - EDF R&D - www.code-aster.org
# This file is part of code_aster.
#
# code_aster is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# code_aster is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with code_aster.  If not, see <http://www.gnu.org/licenses/>.
# --------------------------------------------------------------------

# person_in_charge: mickael.abbas at edf.fr

"""Ce module définit les noms de variables internes valides.
Un comportement ne doit/peut pas utiliser une variable internes dont le
nom ne serait pas déclaré ici."""

DICT_NOM_VARI = {
    "FERRITE": _(u"phase métallurgique acier variable (ferrite)"),
    "PERLITE": _(u"phase métallurgique acier variable (perlite)"),
    "BAINITE": _(u"phase métallurgique acier variable (bainite)"),
    "MARTENSITE": _(u"phase métallurgique acier variable (martensite)"),
    "AUSTENITE": _(u"phase métallurgique acier variable (austenite)"),
    "ADOUMEMB": _(u"affaiblissement relatif de raideur en membrane"),
    "ADOUCOMP": _(u"affaiblissement relatif de raideur en membrane en compression"),
    "ADOUFLEX": _(u"affaiblissement relatif de raideur en flexion"),
    "ADOUTRAC": _(u"affaiblissement relatif de raideur en membrane en traction"),
    "AFM": _(u"afm"),
    "AFT": _(u"aft"),
    "ALEA": _(u"contrainte de rupture par amorçage,"),
    "ALF": _(u"alu fixes  reversible"),
    "ALL": _(u"alu libre"),
    "ALPHA2XX": _(u"écrouissage cinématique non linéaire variable interne 2  composante XX"),
    "ALPHA2XY": _(u"écrouissage cinématique non linéaire variable interne 2  composante XY"),
    "ALPHA2XZ": _(u"écrouissage cinématique non linéaire variable interne 2  composante XZ"),
    "ALPHA2YY": _(u"écrouissage cinématique non linéaire variable interne 2  composante YY"),
    "ALPHA2YZ": _(u"écrouissage cinématique non linéaire variable interne 2  composante YZ"),
    "ALPHA2ZZ": _(u"écrouissage cinématique non linéaire variable interne 2  composante ZZ"),
    "ALPHAXX": _(u"écrouissage cinématique non linéaire variable interne 1  composante XX"),
    "ALPHAXY": _(u"écrouissage cinématique non linéaire variable interne 1  composante XY"),
    "ALPHAXZ": _(u"écrouissage cinématique non linéaire variable interne 1  composante XZ"),
    "ALPHAYY": _(u"écrouissage cinématique non linéaire variable interne 1  composante YY"),
    "ALPHAYZ": _(u"écrouissage cinématique non linéaire variable interne 1  composante YZ"),
    "ALPHAZZ": _(u"écrouissage cinématique non linéaire variable interne 1  composante ZZ"),
    "ANGL1": _(u"GLRC_DAMAGE : angle d'orthotropie 1"),
    "ANGL2": _(u"GLRC_DAMAGE : angle d'orthotropie 2"),
    "ANGL3": _(u"GLRC_DAMAGE : angle d'orthotropie 3"),
    "ANGLEDEV": _(u"angle du seuil déviatoire (CJS)"),
    "ARAG": _(u"BETON_RAG : avancement de la réaction"),
    "ASSCORN1": _(u"assemblage cornière, variable interne 1"),
    "ASSCORN2": _(u"assemblage cornière, variable interne 2"),
    "ASSCORN3": _(u"assemblage cornière, variable interne 3"),
    "ASSCORN4": _(u"assemblage cornière, variable interne 4"),
    "ASSCORN5": _(u"assemblage cornière, variable interne 5"),
    "ASSCORN6": _(u"assemblage cornière, variable interne 6"),
    "ASSCORN7": _(u"assemblage cornière, variable interne 7"),
    "BC": _(u"BETON_RAG : Endommagement macroscopique en compression"),
    "BT11": _(u"BETON_RAG : Endommagement macroscopique (indicateur de fissuration)  composante 1"),
    "BT12": _(u"BETON_RAG : Endommagement macroscopique (indicateur de fissuration)  composante 2"),
    "BT13": _(u"BETON_RAG : Endommagement macroscopique (indicateur de fissuration)  composante 3"),
    "BT22": _(u"BETON_RAG : Endommagement macroscopique (indicateur de fissuration)  composante 4"),
    "BT23": _(u"BETON_RAG : Endommagement macroscopique (indicateur de fissuration)  composante 5"),
    "BT33": _(u"BETON_RAG : Endommagement macroscopique (indicateur de fissuration)  composante 6"),
    "CAL": _(u"calcium libre"),
    "CASH": _(u"C-A-S-H"),
    "CCF1": _(u"coeff de consolidation fin de pas"),
    "COHESION": _(u"cohésion"),
    "COMPT": _(u"itération de Newton courante,"),
    "COMR": _(u"itération de Newton de rupture,"),
    "CRITSIG": _(u"Critère en contrainte, utilisé en Génie Civil"),
    "CRITEPS": _(u"Critère en déformation, utilisé en Génie Civil"),
    "CRITHILL": _(u"Critère de Hill : pour Hujeux : densité normalisée pour le travail du second ordre"),
    "CRITRUPT": _(u"Critère de rupture pour CRIT_RUPT"),
    "CSH": _(u"CSH"),
    "CSHE": _(u"CSH capable de fixer les alu reversibles"),
    "DB1": _(u"c_plan ou 1d algo Deborst, variable interne 1"),
    "DB2": _(u"c_plan ou 1d algo Deborst, variable interne 2"),
    "DB3": _(u"c_plan ou 1d algo Deborst, variable interne 3"),
    "DB4": _(u"c_plan ou 1d algo Deborst, variable interne 4"),
    "DC": _(u"endommagement de compression"),
    "DDISSM": _(u"Vitesse de dissipation mécanique"),
    "DEPLX": _(u"DIS_ECRO_TRAC : Déplacement différentiel, suivant x local."),
    "DEPLANEX": _(u"DIS_ECRO_TRAC : Déplacement anélastique, suivant x local."),
    "DEPLCUMX": _(u"DIS_ECRO_TRAC : Déplacement anélastique cumulé, suivant x local."),
    "DEPPLAS1": _(u"JOINT_MECA_FROT  déplacement tangentiel plastique par rapport au point de départ, composante 1"),
    "DEPPLAS2": _(u"JOINT_MECA_FROT  déplacement tangentiel plastique par rapport au point de départ, composante 2"),
    "DEPS-TH": _(u"PINTO-MENEGOTTO V5"),
    "DEPSPEQ": _(u"incrément de déformation plastique équivalente"),
    "DETOPTG": _(u"Hujeux : déterminant de la matrice tangente"),
    "DFLU": _(u"endommagement de fluage"),
    "DG1": _(u"endommagement principaux induit par la def plast de gel"),
    "DG2": _(u"endommagement principaux induit par la def plast de gel"),
    "DG3": _(u"endommagement principaux induit par la def plast de gel"),
    "DINSTM": _(u"Incrément de temps"),
    "DIS1": _(u"éléments discrets, variable interne 1"),
    "DIS10": _(u"éléments discrets, variable interne 10"),
    "DIS11": _(u"éléments discrets, variable interne 11"),
    "DIS12": _(u"éléments discrets, variable interne 12"),
    "DIS13": _(u"éléments discrets, variable interne 13"),
    "DIS14": _(u"éléments discrets, variable interne 14"),
    "DIS15": _(u"éléments discrets, variable interne 15"),
    "DIS16": _(u"éléments discrets, variable interne 16"),
    "DIS17": _(u"éléments discrets, variable interne 17"),
    "DIS18": _(u"éléments discrets, variable interne 18"),
    "DIS2": _(u"éléments discrets, variable interne 2"),
    "DIS3": _(u"éléments discrets, variable interne 3"),
    "DIS4": _(u"éléments discrets, variable interne 4"),
    "DIS5": _(u"éléments discrets, variable interne 5"),
    "DIS6": _(u"éléments discrets, variable interne 6"),
    "DIS7": _(u"éléments discrets, variable interne 7"),
    "DIS8": _(u"éléments discrets, variable interne 8"),
    "DIS9": _(u"éléments discrets, variable interne 9"),
    "DISSENDO": _(u"dissipation d'endommagement"),
    "DISSIP": _(u"dissipation plastique"),
    "DISSGLIS": _(u"dissipation de glissement"),
    "DISSTHER": _(u"dissipation Thermodynamique"),
    "DISTSDEV": _(u"CJS distance normalisée au seuil déviatoire"),
    "DISTSISO": _(u"CJS distance normalisée au seuil isotrope"),
    "DOMAINE": _(u"domaine de comportement de la roche"),
    "DOMCOMP": _(u"Laigle : domaine de comportement de la roche"),
    "DPORO": _(u"LIQU_AD_GAZ v1"),
    "DPVP": _(u"LIQU_AD_GAZ v2"),
    "DTH": _(u"endommagement thermique isotrope"),
    "DTHE": _(u"endommagement thermique"),
    "DTL1": _(u"densite de fissuration diffuse de traction"),
    "DTL2": _(u"densite de fissuration diffuse de traction"),
    "DTL3": _(u"densite de fissuration diffuse de traction"),
    "DTP1": _(u"endommagement principaux localisés pour Poisson"),
    "DTP2": _(u"endommagement principaux localisés pour Poisson"),
    "DTP3": _(u"endommagement principaux localisés pour Poisson"),
    "DUY": _(u"valeur maximale de la différence déplacement local-déplacement limite"),
    "DV": _(u"variation de volume cumulée"),
    "DW1": _(u"endommagements principaux induits par la def plastique hydrique"),
    "DW2": _(u"endommagements principaux induits par la def plastique hydrique"),
    "DW3": _(u"endommagements principaux induits par la def plastique hydrique"),
    "E0D1": _(u"variables internes pour le fluage direction 1"),
    "E0D2": _(u"variables internes pour le fluage direction 2"),
    "E0D3": _(u"variables internes pour le fluage direction 3"),
    "E0D4": _(u"variables internes pour le fluage direction 4"),
    "E0D5": _(u"variables internes pour le fluage direction 5"),
    "E0D6": _(u"variables internes pour le fluage direction 6"),
    "E1D1": _(u"variables internes pour le fluage direction 1"),
    "E1D2": _(u"variables internes pour le fluage direction 2"),
    "E1D3": _(u"variables internes pour le fluage direction 3"),
    "E1D4": _(u"variables internes pour le fluage direction 4"),
    "E1D5": _(u"variables internes pour le fluage direction 5"),
    "E1D6": _(u"variables internes pour le fluage direction 6"),
    "E2D1": _(u"variables internes pour le fluage direction 1"),
    "E2D2": _(u"variables internes pour le fluage direction 2"),
    "E2D3": _(u"variables internes pour le fluage direction 3"),
    "E2D4": _(u"variables internes pour le fluage direction 4"),
    "E2D5": _(u"variables internes pour le fluage direction 5"),
    "E2D6": _(u"variables internes pour le fluage direction 6"),
    "E0S": _(u"variables internes pour le fluage sphérique"),
    "E1S": _(u"variables internes pour le fluage sphérique"),
    "E2S": _(u"variables internes pour le fluage sphérique"),
    "EBLOC": _(u"énergie bloquée"),
    "EDISS": _(u"énergie dissipée pour CRIT_RUPT"),
    "EDISSCUM": _(u"énergie dissipée cumulée à chaque pas pour CRIT_RUPT"),
    "ECRISOM1": _(u"JOINT_BA : variable scalaire de l'écrouissage isotrope pour l'endommagement en mode 1"),
    "ECRISOM2": _(u"JOINT_BA : variable scalaire de l'écrouissage isotrope pour l'endommagement en mode 2"),
    "ECROCINE": _(u"JOINT_BA : valeur de l'écrouissage cinématique par frottement des fissures"),
    "ECROISOT": _(u"Variable d'écrouissage isotrope"),
    "EDI11": _(u"déformation seuil déviatorique irréversible, composante 11"),
    "EDI12": _(u"déformation seuil déviatorique irréversible, composante 12"),
    "EDI13": _(u"déformation seuil déviatorique irréversible, composante 13"),
    "EDI22": _(u"déformation seuil déviatorique irréversible, composante 22"),
    "EDI23": _(u"déformation seuil déviatorique irréversible, composante 23"),
    "EDI33": _(u"déformation seuil déviatorique irréversible, composante 33"),
    "EDS11": _(u"déformation seuil déviatorique irréversible, composante 11"),
    "EDS12": _(u"déformation seuil déviatorique réversible, composante 12"),
    "EDS13": _(u"déformation seuil déviatorique réversible, composante 13"),
    "EDS22": _(u"déformation seuil déviatorique réversible, composante 22"),
    "EDS23": _(u"déformation seuil déviatorique réversible, composante 23"),
    "EDS33": _(u"déformation seuil déviatorique réversible, composante 33"),
    "EID11": _(u"déformation déviatorique irréversible, composante 11"),
    "EID12": _(u"déformation déviatorique irréversible, composante 12"),
    "EID31": _(u"déformation déviatorique irréversible, composante 31"),
    "EID22": _(u"déformation déviatorique irréversible, composante 22"),
    "EID23": _(u"déformation déviatorique irréversible, composante 23"),
    "EID33": _(u"déformation déviatorique irréversible, composante 33"),
    "EIEQM": _(u"déformation équivalente irréversible maximale"),
    "ERD11": _(u"déformation déviatorique réversible, composante 11"),
    "ERD12": _(u"déformation déviatorique réversible, composante 12"),
    "ERD31": _(u"déformation déviatorique réversible, composante 31"),
    "ERD22": _(u"déformation déviatorique réversible, composante 22"),
    "ERD23": _(u"déformation déviatorique réversible, composante 23"),
    "ERD33": _(u"déformation déviatorique réversible, composante 33"),
    "EFD11": _(u"retrait de dessiccation, composante 11"),
    "EFD12": _(u"retrait de dessiccation, composante 12"),
    "EFD31": _(u"retrait de dessiccation, composante 31"),
    "EFD22": _(u"retrait de dessiccation, composante 22"),
    "EFD23": _(u"retrait de dessiccation, composante 23"),
    "EFD33": _(u"retrait de dessiccation, composante 33"),
    "EIS": _(u"déformation sphérique irréversible"),
    "EISP": _(u"déformation sphérique irréversible"),
    "ELEP1": _(u"numéro de l'élément pointé numéro 1,"),
    "ELEP2": _(u"numéro de l'élément pointé numéro 2 (quand amorçage),"),
    "ENDO": _(u"endommagement scalaire"),
    "ENDOC0": _(u"BETON_RAG : Endommagement intrinsèque de compression"),
    "ENDOCOMP": _(u"endommagement scalaire en compression"),
    "ENDOFL-": _(u"variable d'endommagement pour la flexion négative"),
    "ENDOFL+": _(u"variable d'endommagement pour la flexion positive"),
    "ENDOSUP": _(u"variable d'endommagement pour la moitié supérieure de la plaque"),
    "ENDOINF": _(u"variable d'endommagement pour la moitié inférieure de la plaque"),
    "ENDONOR": _(u"endommagement normal"),
    "ENDORIGI": _(u"rigidité résiduelle"),
    "ENDOTAN": _(u"endommagement tangentiel"),
    "ENDOT11": _(u"BETON_RAG : Endommagement intrinsèque de traction, composante 1"),
    "ENDOT12": _(u"BETON_RAG : Endommagement intrinsèque de traction, composante 2"),
    "ENDOT13": _(u"BETON_RAG : Endommagement intrinsèque de traction, composante 3"),
    "ENDOT22": _(u"BETON_RAG : Endommagement intrinsèque de traction, composante 4"),
    "ENDOT23": _(u"BETON_RAG : Endommagement intrinsèque de traction, composante 5"),
    "ENDOT33": _(u"BETON_RAG : Endommagement intrinsèque de traction, composante 6"),
    "ENDOXX": _(u"tenseur endommagement, direction XX"),
    "ENDOXY": _(u"tenseur endommagement, direction XY"),
    "ENDOXZ": _(u"tenseur endommagement, direction XZ"),
    "ENDOYY": _(u"tenseur endommagement, direction YY"),
    "ENDOYZ": _(u"tenseur endommagement, direction YZ"),
    "ENDOZZ": _(u"tenseur endommagement, direction ZZ"),
    "ENEL_RES": _(u"énergie résiduelle"),
    "EPAISSJO": _(u"épaisseur du joint clavé"),
    "EPEQ": _(u"déformation équivalente de fluage"),
    "EPEQIRRA": _(u"déformation plastique équivalente d'irradiation"),
    "EPG1": _(u"déformation plastique due au gel"),
    "EPG2": _(u"déformation plastique due au gel"),
    "EPG3": _(u"déformation plastique due au gel"),
    "EPG4": _(u"déformation plastique due au gel"),
    "EPG5": _(u"déformation plastique due au gel"),
    "EPG6": _(u"déformation plastique due au gel"),
    "EPSEQ": _(u"déformation équivalente, au sens de Mazars"),
    "EPSEQC": _(u"déformation de compression équivalente, au sens de Mazars"),
    "EPSEQT": _(u"déformation de traction équivalente, au sens de Mazars"),
    "EPSEXX": _(u"déformation élastique composante XX"),
    "EPSEXY": _(u"déformation élastique composante XY"),
    "EPSEXZ": _(u"déformation élastique composante XZ"),
    "EPSEYY": _(u"déformation élastique composante YY"),
    "EPSEYZ": _(u"déformation élastique composante YZ"),
    "EPSEZZ": _(u"déformation élastique composante ZZ"),
    "EPSGRD": _(u"déformation de grandissement."),
    "EPSM+V5": _(u" Pinto-Menegotto, déformation totale"),
    "EPSP1": _(u"GLRC_DAMAGE : extension membranaire plastique 1"),
    "EPSP2": _(u"GLRC_DAMAGE : extension membranaire plastique 2"),
    "EPSP3": _(u"GLRC_DAMAGE : extension membranaire plastique 3"),
    "EPSPEQ": _(u"déformation plastique équivalente (déviatorique)  cumulée"),
    "EPSPEQC": _(u"déformation plastique équivalente (déviatorique)  cumulée en compression"),
    "EPSPEQT": _(u"déformation plastique équivalente (déviatorique)  cumulée en traction"),
    "EPSPVIT": _(u"Vitesse de déformation plastique mécanique"),
    "EPSPVOL": _(u"déformation plastique équivalente volumique"),
    "EPSVOLME" : _(u"déformations volumiques élastiques mécaniques"),
    "EPSVOLTH" : _(u"déformations volumiques élastiques thermiques"),
    "EPSVOLVP" : _(u"déformations volumiques viscoplastiques"),
    "EPSPXX": _(u"déformation plastique composante XX"),
    "EPSPXY": _(u"déformation plastique composante XY"),
    "EPSPXZ": _(u"déformation plastique composante XZ"),
    "EPSPYY": _(u"déformation plastique composante YY"),
    "EPSPYZ": _(u"déformation plastique composante YZ"),
    "EPSPZZ": _(u"déformation plastique composante ZZ"),
    "EPSEDXX": _(u"déformation élastique endommagée composante XX"),
    "EPSEDXY": _(u"déformation élastique endommagée composante XY"),
    "EPSEDXZ": _(u"déformation élastique endommagée composante XZ"),
    "EPSEDYY": _(u"déformation élastique endommagée composante YY"),
    "EPSEDYZ": _(u"déformation élastique endommagée composante YZ"),
    "EPSEDZZ": _(u"déformation élastique endommagée composante ZZ"),
    "EPSRN": _(u"déformation du cycle actuel, Pinto-Menegotto"),
    "EPSRN-1": _(u"déformation du cycle précédent  Pinto-Menegotto"),
    "ERRM": _(u"indicateur d erreur sur la taille des mailles"),
    "ERS": _(u"Déformation sphérique réversible"),
    "ERSP": _(u"Déformation sphérique réversible"),
    "ESI": _(u"BETON_RAG : déformation seuil viscoplastique sphérique"),
    "ESS": _(u"BETON_RAG : déformation seuil viscoplastique sphérique"),
    "EVE1": _(u"déformation visco elastique due aux contraintes de traction dans la zone endommagée"),
    "EVE2": _(u"déformation visco elastique due aux contraintes de traction dans la zone endommagée"),
    "EVE3": _(u"déformation visco elastique due aux contraintes de traction dans la zone endommagée"),
    "EVE4": _(u"déformation visco elastique due aux contraintes de traction dans la zone endommagée"),
    "EVE5": _(u"déformation visco elastique due aux contraintes de traction dans la zone endommagée"),
    "EVE6": _(u"déformation visco elastique due aux contraintes de traction dans la zone endommagée"),
    "EVP11": _(u"BETON_RAG : déformation  viscoplastique composante 1"),
    "EVP12": _(u"BETON_RAG : déformation  viscoplastique composante 2"),
    "EVP13": _(u"BETON_RAG : déformation  viscoplastique composante 3"),
    "EVP22": _(u"BETON_RAG : déformation  viscoplastique composante 4"),
    "EVP23": _(u"BETON_RAG : déformation  viscoplastique composante 5"),
    "EVP33": _(u"BETON_RAG : déformation  viscoplastique composante 6"),
    "FECRDVC1": _(u"Hujeux : facteur de mobilisation du mécanisme déviatoire cyclique, k= 1"),
    "FECRDVC2": _(u"Hujeux : facteur de mobilisation du mécanisme déviatoire cyclique, k= 1"),
    "FECRDVC3": _(u"Hujeux : facteur de mobilisation du mécanisme déviatoire cyclique, k= 1"),
    "FECRDVM1": _(u"Hujeux : facteur de mobilisation du mécanisme déviatoire monotone, k= 1"),
    "FECRDVM2": _(u"Hujeux : facteur de mobilisation du mécanisme déviatoire monotone, k= 2"),
    "FECRDVM3": _(u"Hujeux : facteur de mobilisation du mécanisme déviatoire monotone, k= 3"),
    "FECRISC1": _(u"Hujeux : facteur de mobilisation du mécanisme de consolidation cyclique"),
    "FECRISM1": _(u"Hujeux : facteur de mobilisation du mécanisme de consolidation monotone"),
    "FORCE": _(u"Force"),
    "FH_X": _(u"flux hydraulique dans le repère global ( xxx_JOINT_HYME) composante 1"),
    "FH_Y": _(u"flux hydraulique dans le repère global ( xxx_JOINT_HYME) composante 2"),
    "FH_Z": _(u"flux hydraulique dans le repère global ( xxx_JOINT_HYME) composante 3"),
    "GAMMAECR": _(u"le paramètre d'écrouissage correspondant à la déformation irréversible majeure."),
    "GAMMAP": _(u"déformation déviatorique plastique"),
    "GAMMAVP": _(u"déformation déviatorique viscoplastique"),
    "GAZ1": _(u"GAZ : v1"),
    "GLIS": _(u"JOINT_BA : déformation de glissement cumulée par frottement des fissures"),
    "GLISXINF": _(u"DHRC : déformation de glissement le long des aciers orientés selon X dans la partie inférieure de la plaque"),
    "GLISXSUP": _(u"DHRC : déformation de glissement le long des aciers orientés selon X dans la partie supérieure de la plaque"),
    "GLISYINF": _(u"DHRC : déformation de glissement le long des aciers orientés selon Y dans la partie inférieure de la plaque"),
    "GLISYSUP": _(u"DHRC : déformation de glissement le long des aciers orientés selon Y dans la partie supérieure de la plaque"),
    "GONF": _(u"gonflement"),
    "GR1": _(u"elas_poutre_GR v1"),
    "GR2": _(u"elas_poutre_GR v2"),
    "GR3": _(u"elas_poutre_GR v3"),
    "GRADP_X": _(u"gradient de pression dans le repère global ( xxx_JOINT_HYME)  Composante 1"),
    "GRADP_Y": _(u"gradient de pression dans le repère global ( xxx_JOINT_HYME)  Composante 2"),
    "GRADP_Z": _(u"gradient de pression dans le repère global ( xxx_JOINT_HYME)  Composante 3"),
    "H1": _(u"Hayhurst : variable d'écrouissage H1"),
    "H2": _(u"Hayhurst : variable d'écrouissage H2"),
    "HIS10": _(u"Hujeux : variable mémoratrice pour le mécanisme déviatoire cyclique du plan 1, composante 2"),
    "HIS11": _(u"Hujeux : variable mémoratrice pour le mécanisme déviatoire cyclique du plan 1, composante 3"),
    "HIS12": _(u"Hujeux : variable mémoratrice pour le mécanisme déviatoire cyclique du plan 1, composante 4"),
    "HIS13": _(u"Hujeux : variable mémoratrice pour le mécanisme déviatoire cyclique du plan 2, composante 1"),
    "HIS14": _(u"Hujeux : variable mémoratrice pour le mécanisme déviatoire cyclique du plan 2, composante 2"),
    "HIS15": _(u"Hujeux : variable mémoratrice pour le mécanisme déviatoire cyclique du plan 2, composante 3"),
    "HIS16": _(u"Hujeux : variable mémoratrice pour le mécanisme déviatoire cyclique du plan 2, composante 4"),
    "HIS17": _(u"Hujeux : variable mémoratrice pour le mécanisme déviatoire cyclique du plan 3, composante 1"),
    "HIS18": _(u"Hujeux : variable mémoratrice pour le mécanisme déviatoire cyclique du plan 3, composante 2"),
    "HIS19": _(u"Hujeux : variable mémoratrice pour le mécanisme déviatoire cyclique du plan 3, composante 3"),
    "HIS20": _(u"Hujeux : variable mémoratrice pour le mécanisme déviatoire cyclique du plan 3, composante 4"),
    "HIS21": _(u"Hujeux : variable mémoratrice discontinue du mécanisme de consolidation"),
    "HIS22": _(u"Hujeux : variable mémoratrice discontinue de normale à la surface de charge du mécanisme de consolidation"),
    "HIS34": _(u"Hujeux : Indicateur d'état des mécanismes actifs après convergence"),
    "HIS9": _(u"Hujeux : variable mémoratrice pour le mécanisme déviatoire cyclique du plan 1, composante 1"),
    "HYD": _(u"degre d hydratation"),
    "HYD0": _(u"degres d hydratation moyen"),
    "HYDR1": _(u"HYDR : v1"),
    "HYDREND1": _(u"HYDRENDO : v1"),
    "HYDRUTI1": _(u"HYDR_UTIL : v1"),
    "ID": _(u"indice de degrdation des ppte de trsport au jeune age"),
    "INDIOUV": _(u"JOINT_MECA_FROT : indicateur d'ouverture complète =0 fermé, =1 ouvert"),
    "INDETAC1": _(u"Hujeux : indicateur d'activation (1) ou non (0) des mécanismes cycliques, composante 1"),
    "INDETAC2": _(u"Hujeux : indicateur d'activation (1) ou non (0) des mécanismes cycliques, composante 2"),
    "INDETAC3": _(u"Hujeux : indicateur d'activation (1) ou non (0) des mécanismes cycliques, composante 3"),
    "INDETAC4": _(u"Hujeux : indicateur d'activation (1) ou non (0) des mécanismes cycliques, composante 4"),
    "INDETAM1": _(u"Hujeux : indicateur d'activation (1) ou non (0) des mécanismes monotones ou de passage au cyclique, composante 1"),
    "INDETAM2": _(u"Hujeux : indicateur d'activation (1) ou non (0) des mécanismes monotones ou de passage au cyclique, composante 2"),
    "INDETAM3": _(u"Hujeux : indicateur d'activation (1) ou non (0) des mécanismes monotones ou de passage au cyclique, composante 3"),
    "INDETAM4": _(u"Hujeux : indicateur d'activation (1) ou non (0) des mécanismes monotones ou de passage au cyclique, composante 4"),
    "INDIC": _(u"LETK : indicateur de la position de l'etat de contrainte par rapport aux seuils viscoplastiques"),
    "INDICDIL": _(u"indicateur de contractance ou de dilatance"),
    "INDICYCL": _(u" Pinto-Menegotto, indicateur d'activation du comportement cyclique"),
    "INDIDISS": _(u"Indicateur de dissipation =0 si régime linéaire, =1 si régime dissipatif."),
    "INDIEND1": _(u"indicateur d'endommagement pour la flexion positive"),
    "INDIEND2": _(u"indicateur d'endommagement pour la flexion négative"),
    "INDIENDO": _(u"indicateur d'endommagement"),
    "INDIENDN": _(u"indicateur d'endommagement normal =0 sain, =1 endommagé, =2 cassé"),
    "INDIENDT": _(u"indicateur d'endommagement tangentiel =0 sain, =1 endommagé, =2 cassé"),
    "INDIFLAM": _(u"indicateur de flambement"),
    "INDIHYDR": _(u"indicateur d'irréversibilité hydrique"),
    "INDIPLAC": _(u"indicateur de plasticité en compression  (0 : seuil non atteint, 1 ou > 1 : seuil atteint)"),
    "INDIPLAS": _(u"indicateur de plasticité (0 : seuil non atteint, 1 ou > 1 : seuil atteint)"),
    "INDIPLAT": _(u"indicateur de plasticité en traction  (0 : seuil non atteint, 1 ou > 1 : seuil atteint)"),
    "INDIVIDE": _(u"indice des vides"),
    "INDIVISC": _(u"indicateur de viscoplasticité"),
    "IRRA": _(u"irradiation"),
    "IRTW": _(u"indicateur de passage du pic de la loi de traction"),
    "IRVECU": _(u"mémorisation de l'historique d'irradiation (fluence),"),
    "ISPH": _(u"BETON_UMLV : v21"),
    "KHIP1": _(u"GLRC_DAMAGE : courbure plastique 1"),
    "KHIP2": _(u"GLRC_DAMAGE : courbure plastique 2"),
    "KHIP3": _(u"GLRC_DAMAGE : courbure plastique 3"),
    "KSIXX": _(u"tenseur de rappel pour l'effet de mémoire, composante XX"),
    "KSIXY": _(u"tenseur de rappel pour l'effet de mémoire, composante XY"),
    "KSIXZ": _(u"tenseur de rappel pour l'effet de mémoire, composante XZ"),
    "KSIYY": _(u"tenseur de rappel pour l'effet de mémoire, composante YY"),
    "KSIYZ": _(u"tenseur de rappel pour l'effet de mémoire, composante YZ"),
    "KSIZZ": _(u"tenseur de rappel pour l'effet de mémoire, composante ZZ"),
    "LAMBDA": _(u"JOINT_MECA_FROT : paramètre croissant indiquant le déplacement tangentiel plastique cumulé (sans orientation)."),
    "LIQADGV1": _(u"LIQADGV1"),
    "LIQADGV2": _(u"LIQADGV2"),
    "LIQADGV3": _(u"LIQADGV3"),
    "LIQGATM1": _(u"LIQGATM1"),
    "LIQGATM2": _(u"LIQGATM2"),
    "LIQGAZ1": _(u"LIQGAZ1"),
    "LIQGAZ2": _(u"LIQGAZ2"),
    "LIQSAT1": _(u"LIQSAT1"),
    "LIQVAP1": _(u"LIQVAP1"),
    "LIQVAP2": _(u"LIQVAP2"),
    "LIQVAP3": _(u"LIQVAP3"),
    "LIQVG1": _(u"LIQVG1"),
    "LIQVG2": _(u"LIQVG2"),
    "LIQVG3": _(u"LIQVG3"),
    "MEMOECRO": _(u"CIN2_MEMO : variable relative à la mémoire d'écrouissage q"),
    "MSRD": _(u"quantite d eau apporte depuis le debut du calcul"),
    "MSRF": _(u"quantite deau apporte depuis le debut du calcul"),
    "NBITER": _(u"nombre d'itérations internes"),
    "NBSSPAS": _(u"nombre de redécoupages locaux du pas de temps"),
    "NSOL": _(u"nasol pour verif"),
    "SIGP": _(u"cam_clay : contrainte de confinement"),
    "PAS0": _(u"premier passage vrai"),
    "PCENERDI": _(u"pourcentage d'endommagement normal (dans la zone adoucissante)"),
    "PCENDOT": _(u"pourcentage d'endommagement tangentiel"),
    "PCH": _(u"BETON_RAG : pression chimique"),
    "PCR": _(u"pression critique"),
    "PDISS": _(u"puissance dissipée pour CRIT_RUPT"),
    "PDISSCUM": _(u"puissance dissipée cumulée à chaque pas pour CRIT_RUPT"),
    "PEFFRAG": _(u"BETON_RAG : pression effective due à la RAG"),
    "PERM_LONG": _(u"perméabilité longitudinale de la fissure"),
    "PGEL": _(u"pression de gel"),
    "PHI": _(u"Hayhurst : variable PHI"),
    "PHIS": _(u"Dissipation par fluage sphérique"),
    "PHID": _(u"Dissipation par fluage deviatoire"),
    "POROSITE": _(u"porosité"),
    "POS": _(u"VISC_DRUC_PRAG : position du point de charge par rapport au seuil"),
    "PRE1": _(u"LIQU_AD_GAZ v4"),
    "PRE2": _(u"LIQU_AD_GAZ v5"),
    "PRESF": _(u"pression de fluide"),
    "PW": _(u"BETON_RAG : pression hydrique"),
    "PWAT": _(u"pression hydrique"),
    "SIEQ": _(u"cam_clay : contrainte équivalente"),
    "RAIDEUR": _(U"DIS_ZENER, DIS_ECRO_TRAC : Raideur du discret"),
    "RESIDU": _(u"valeur du test local d'arrêt des itérations internes"),
    "RHXZ": _(u"Hujeux : rayon du seuil déviatoire atteint par  la surface de charge avant le décharge du mécanisme déviatoire du plan 2"),
    "RHYZ": _(u"Hujeux : rayon du seuil déviatoire atteint par  la surface de charge avant le décharge du mécanisme déviatoire du plan 1"),
    "RSIGMA": _(u"Facteur de triaxialité des contraintes, modèle Mazars"),
    "SATLIQ": _(u"LIQU_AD_GAZ v3"),
    "SAUT_N": _(u"saut normal"),
    "SAUT_T1": _(u"saut tangentiel 1"),
    "SAUT_T2": _(u"saut tangentiel 2"),
    "SHIFT_T1": _(u"glissement tangentiel 1"),
    "SHIFT_T2": _(u"glissement tangentiel 2"),
    "SDEVCRIT": _(u"CJS rapport entre le seuil déviatoire et le seuil déviatorique critique"),
    "SDEVEPSP": _(u"CJS signe du produit contracté de la contrainte déviatorique par la déformation plastique déviatorique"),
    "SEE1": _(u"contrainte dans le squelette solide"),
    "SEE2": _(u"contrainte dans le squelette solide"),
    "SEE3": _(u"contrainte dans le squelette solide"),
    "SEE4": _(u"contrainte dans le squelette solide"),
    "SEE5": _(u"contrainte dans le squelette solide"),
    "SEE6": _(u"contrainte dans le squelette solide"),
    "SEF11": _(u"BETON_RAG : contrainte effective dans le modèle rhéologique, composante 1"),
    "SEF12": _(u"BETON_RAG : contrainte effective dans le modèle rhéologique, composante 2"),
    "SEF13": _(u"BETON_RAG : contrainte effective dans le modèle rhéologique, composante 3"),
    "SEF22": _(u"BETON_RAG : contrainte effective dans le modèle rhéologique, composante 4"),
    "SEF23": _(u"BETON_RAG : contrainte effective dans le modèle rhéologique, composante 5"),
    "SEF33": _(u"BETON_RAG : contrainte effective dans le modèle rhéologique, composante 6"),
    "SES1": _(u"contraintes effectives dans le squelette solide"),
    "SES2": _(u"contraintes effectives dans le squelette solide"),
    "SES3": _(u"contraintes effectives dans le squelette solide"),
    "SES4": _(u"contraintes effectives dans le squelette solide"),
    "SES5": _(u"contraintes effectives dans le squelette solide"),
    "SES6": _(u"contraintes effectives dans le squelette solide"),
    "SET1": _(u"Contraintes effectives issues du modele de fluage"),
    "SET2": _(u"Contraintes effectives issues du modele de fluage"),
    "SET3": _(u"Contraintes effectives issues du modele de fluage"),
    "SET4": _(u"Contraintes effectives issues du modele de fluage"),
    "SET5": _(u"Contraintes effectives issues du modele de fluage"),
    "SET6": _(u"Contraintes effectives issues du modele de fluage"),
    "SEUIL": _(u"seuil"),
    "SEUILDEP": _(u"CZM  seuil correspondant au plus grand saut de déplacement (en norme)"),
    "SEUILHYD": _(u"seuil hydrique"),
    "SEUILISO": _(u"seuil isotrope"),
    "SIGM_N": _(u"contrainte normale"),
    "SIGM_T1": _(u"contrainte tangentielle"),
    "SIGMAPIC": _(u"contrainte de pic"),
    "SIGN_GLO": _(u"contrainte mécanique normale (sans pression de fluide)"),
    "SIGRN": _(u" Pinto-Menegotto, contrainte cycle N"),
    "SIGT": _(u"norme de la contrainte tangente"),
    "SM1": _(u"SIMO_MIEHE, variable interne 1"),
    "SM2": _(u"SIMO_MIEHE, variable interne 2"),
    "SM3": _(u"SIMO_MIEHE, variable interne 3"),
    "SM4": _(u"SIMO_MIEHE, variable interne 4"),
    "SM5": _(u"SIMO_MIEHE, variable interne 5"),
    "SM6": _(u"SIMO_MIEHE, variable interne 6"),
    "SPL1": _(u"contrainte plastique dans les fissures de traction localisée"),
    "SPL2": _(u"contrainte plastique dans les fissures de traction localisée"),
    "SPL3": _(u"contrainte plastique dans les fissures de traction localisée"),
    "SPL4": _(u"contrainte plastique dans les fissures de traction localisée"),
    "SPL5": _(u"contrainte plastique dans les fissures de traction localisée"),
    "SPL6": _(u"contrainte plastique dans les fissures de traction localisée"),
    "SSC": _(u"seuil de compression"),
    "SSG1": _(u"contraintes seuil pour les endommagement diffus dus au gel"),
    "SSG2": _(u"contraintes seuil pour les endommagement diffus dus au gel"),
    "SSG3": _(u"contraintes seuil pour les endommagement diffus dus au gel"),
    "SSG4": _(u"contraintes seuil pour les endommagement diffus dus au gel"),
    "SSG5": _(u"contraintes seuil pour les endommagement diffus dus au gel"),
    "SSG6": _(u"contraintes seuil pour les endommagement diffus dus au gel"),
    "SSL1": _(u"seuils de traction dans l'endommagement localisé macro"),
    "SSL2": _(u"seuils de traction dans l'endommagement localisé macro"),
    "SSL3": _(u"seuils de traction dans l'endommagement localisé macro"),
    "SSL4": _(u"seuils de traction dans l'endommagement localisé macro"),
    "SSL5": _(u"seuils de traction dans l'endommagement localisé macro"),
    "SSL6": _(u"seuils de traction dans l'endommagement localisé macro"),
    "SSP1": _(u"seuils de traction dans l'endommagement localisé Poisson"),
    "SSP2": _(u"seuils de traction dans l'endommagement localisé Poisson"),
    "SSP3": _(u"seuils de traction dans l'endommagement localisé Poisson"),
    "SSP4": _(u"seuils de traction dans l'endommagement localisé Poisson"),
    "SSP5": _(u"seuils de traction dans l'endommagement localisé Poisson"),
    "SSP6": _(u"seuils de traction dans l'endommagement localisé Poisson"),
    "SSW1": _(u"contraintes seuil pour pour les endommagement diffus dû à l'eau"),
    "SSW2": _(u"contraintes seuil pour pour les endommagement diffus dû à l'eau"),
    "SSW3": _(u"contraintes seuil pour pour les endommagement diffus dû à l'eau"),
    "SSW4": _(u"contraintes seuil pour pour les endommagement diffus dû à l'eau"),
    "SSW5": _(u"contraintes seuil pour pour les endommagement diffus dû à l'eau"),
    "SSW6": _(u"contraintes seuil pour pour les endommagement diffus dû à l'eau"),
    "SUC": _(u"BETON_RAG : contraintes seuil de compression"),
    "SULF": _(u"sulfates fixes"),
    "SULL": _(u"sulfate libre"),
    "SURF": _(u"contrainte de rupture par propagation,"),
    "SUT11": _(u"BETON_RAG : contraintes seuil de traction, composante 1"),
    "SUT12": _(u"BETON_RAG : contraintes seuil de traction, composante 2"),
    "SUT13": _(u"BETON_RAG : contraintes seuil de traction, composante 3"),
    "SUT22": _(u"BETON_RAG : contraintes seuil de traction, composante 4"),
    "SUT23": _(u"BETON_RAG : contraintes seuil de traction, composante 5"),
    "SUT33": _(u"BETON_RAG : contraintes seuil de traction, composante 6"),
    "SVE1": _(u"contraintes effectives de traction dues au chargement extérieur"),
    "SVE2": _(u"contraintes effectives de traction dues au chargement extérieur"),
    "SVE3": _(u"contraintes effectives de traction dues au chargement extérieur"),
    "SVE4": _(u"contraintes effectives de traction dues au chargement extérieur"),
    "SVE5": _(u"contraintes effectives de traction dues au chargement extérieur"),
    "SVE6": _(u"contraintes effectives de traction dues au chargement extérieur"),
    "TAUW": _(u"taux de chargement local de Weibull"),
    "TEMP": _(u"température"),
    "TEMP_MAX": _(u"température maximum"),
    "TEQU": _(u"temps de chargement cumule"),
    "THXY1": _(u"Hujeux : normale entrante à la surface de charge du mécanisme père du mécanisme déviatoire du plan 3, composante 1"),
    "THXY2": _(u"Hujeux : normale entrante à la surface de charge du mécanisme père du mécanisme déviatoire du plan 3, composante 2"),
    "THXZ1": _(u"Hujeux : normale entrante à la surface de charge du mécanisme père du mécanisme déviatoire du plan 2, composante 1"),
    "THXZ2": _(u"Hujeux : normale entrante à la surface de charge du mécanisme père du mécanisme déviatoire du plan 2, composante 2"),
    "THYZ1": _(u"Hujeux : normale entrante à la surface de charge du mécanisme père du mécanisme déviatoire du plan 1, composante 1"),
    "THYZ2": _(u"Hujeux : normale entrante à la surface de charge du mécanisme père du mécanisme déviatoire du plan 1, composante 2"),
    "TMDF": _(u"temps caracteristique de micro diffusion des reactions"),
    "TMP1": _(u"Temperature finale pour verification"),
    "TOEQ": _(u"tau de chargement equivalent"),
    "TORF": _(u"tau de chragement temporel sur la durée de référence"),
    "TXX": _(u"GDEF_LOG  contrainte T, composante XX"),
    "TXY": _(u"GDEF_LOG  contrainte T, composante XY"),
    "TXZ": _(u"GDEF_LOG  contrainte T, composante XZ"),
    "TYY": _(u"GDEF_LOG  contrainte T, composante YY"),
    "TYZ": _(u"GDEF_LOG  contrainte T, composante YZ"),
    "TZZ": _(u"GDEF_LOG  contrainte T, composante ZZ"),
    "UVISQ": _(u"Déplacement concernant la partie visqueuse"),
    "VDEF": _(u"volume d ett secondaire"),
    "VE11": _(u"variables internes pour le fluage direction 1"),
    "VE12": _(u"variables internes pour le fluage direction 2"),
    "VE13": _(u"variables internes pour le fluage direction 3"),
    "VE14": _(u"variables internes pour le fluage direction 4"),
    "VE15": _(u"variables internes pour le fluage direction 5"),
    "VE16": _(u"variables internes pour le fluage direction 6"),
    "VE1S": _(u"variables internes pour le fluage sphérique"),
    "VE21": _(u"variables internes pour le fluage direction 1"),
    "VE22": _(u"variables internes pour le fluage direction 2"),
    "VE23": _(u"variables internes pour le fluage direction 3"),
    "VE24": _(u"variables internes pour le fluage direction 4"),
    "VE25": _(u"variables internes pour le fluage direction 5"),
    "VE26": _(u"variables internes pour le fluage direction 6"),
    "VE2S": _(u"variables internes pour le fluage sphérique"),
    "VG1": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 1"),
    "VG10": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 10"),
    "VG11": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 11"),
    "VG12": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 12"),
    "VG13": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 13"),
    "VG14": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 14"),
    "VG15": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 15"),
    "VG16": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 16"),
    "VG17": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 17"),
    "VG18": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 18"),
    "VG19": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 19"),
    "VG2": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 2"),
    "VG20": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 20"),
    "VG21": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 21"),
    "VG22": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 22"),
    "VG23": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 23"),
    "VG24": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 24"),
    "VG25": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 25"),
    "VG26": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 26"),
    "VG27": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 27"),
    "VG28": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 28"),
    "VG29": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 29"),
    "VG3": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 3"),
    "VG30": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 30"),
    "VG31": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 31"),
    "VG32": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 32"),
    "VG33": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 33"),
    "VG34": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 34"),
    "VG35": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 35"),
    "VG36": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 36"),
    "VG37": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 37"),
    "VG38": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 38"),
    "VG39": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 39"),
    "VG4": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 4"),
    "VG40": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 40"),
    "VG41": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 41"),
    "VG42": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 42"),
    "VG43": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 43"),
    "VG44": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 44"),
    "VG45": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 45"),
    "VG46": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 46"),
    "VG47": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 47"),
    "VG48": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 48"),
    "VG49": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 49"),
    "VG5": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 5"),
    "VG50": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 50"),
    "VG51": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 51"),
    "VG52": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 52"),
    "VG53": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 53"),
    "VG54": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 54"),
    "VG55": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 55"),
    "VG6": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 6"),
    "VG7": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 7"),
    "VG8": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 8"),
    "VG9": _(u"comportement BETON_GRANGER, voir R7.01.01, variable interne 9"),
    "VIDE": _(u"variable interne vide"),
    "VISCHA1": _(u"VISCOCHAB, voir R5.03.12, variable interne 1"),
    "VISCHA10": _(u"VISCOCHAB, voir R5.03.12, variable interne 10"),
    "VISCHA11": _(u"VISCOCHAB, voir R5.03.12, variable interne 11"),
    "VISCHA12": _(u"VISCOCHAB, voir R5.03.12, variable interne 12"),
    "VISCHA13": _(u"VISCOCHAB, voir R5.03.12, variable interne 13"),
    "VISCHA14": _(u"VISCOCHAB, voir R5.03.12, variable interne 14"),
    "VISCHA15": _(u"VISCOCHAB, voir R5.03.12, variable interne 15"),
    "VISCHA16": _(u"VISCOCHAB, voir R5.03.12, variable interne 16"),
    "VISCHA17": _(u"VISCOCHAB, voir R5.03.12, variable interne 17"),
    "VISCHA18": _(u"VISCOCHAB, voir R5.03.12, variable interne 18"),
    "VISCHA19": _(u"VISCOCHAB, voir R5.03.12, variable interne 19"),
    "VISCHA2": _(u"VISCOCHAB, voir R5.03.12, variable interne 2"),
    "VISCHA20": _(u"VISCOCHAB, voir R5.03.12, variable interne 20"),
    "VISCHA21": _(u"VISCOCHAB, voir R5.03.12, variable interne 21"),
    "VISCHA22": _(u"VISCOCHAB, voir R5.03.12, variable interne 22"),
    "VISCHA23": _(u"VISCOCHAB, voir R5.03.12, variable interne 23"),
    "VISCHA24": _(u"VISCOCHAB, voir R5.03.12, variable interne 24"),
    "VISCHA25": _(u"VISCOCHAB, voir R5.03.12, variable interne 25"),
    "VISCHA26": _(u"VISCOCHAB, voir R5.03.12, variable interne 26"),
    "VISCHA27": _(u"VISCOCHAB, voir R5.03.12, variable interne 27"),
    "VISCHA28": _(u"VISCOCHAB, voir R5.03.12, variable interne 28"),
    "VISCHA3": _(u"VISCOCHAB, voir R5.03.12, variable interne 3"),
    "VISCHA4": _(u"VISCOCHAB, voir R5.03.12, variable interne 4"),
    "VISCHA5": _(u"VISCOCHAB, voir R5.03.12, variable interne 5"),
    "VISCHA6": _(u"VISCOCHAB, voir R5.03.12, variable interne 6"),
    "VISCHA7": _(u"VISCOCHAB, voir R5.03.12, variable interne 7"),
    "VISCHA8": _(u"VISCOCHAB, voir R5.03.12, variable interne 8"),
    "VISCHA9": _(u"VISCOCHAB, voir R5.03.12, variable interne 9"),
    "VMA1": _(u"vitesse de fluage de Maxwell dans les fissures utile pour le calcul des ouvertures de fissures en présence de fluage"),
    "VMA2": _(u"vitesse de fluage de Maxwell dans les fissures utile pour le calcul des ouvertures de fissures en présence de fluage"),
    "VMA3": _(u"vitesse de fluage de Maxwell dans les fissures utile pour le calcul des ouvertures de fissures en présence de fluage"),
    "VMA4": _(u"vitesse de fluage de Maxwell dans les fissures utile pour le calcul des ouvertures de fissures en présence de fluage"),
    "VMA5": _(u"vitesse de fluage de Maxwell dans les fissures utile pour le calcul des ouvertures de fissures en présence de fluage"),
    "VMA6": _(u"vitesse de fluage de Maxwell dans les fissures utile pour le calcul des ouvertures de fissures en présence de fluage"),
    "VRAG": _(u"volume du gel de rag"),
    "VT00": _(u"stockage des vecteurs propre des tailles des éléments pour éviter le recalcul à chaque sous itération"),
    "VT11": _(u"stockage des vecteurs propre des tailles des éléments pour éviter le recalcul à chaque sous itération"),
    "VT12": _(u"stockage des vecteurs propre des tailles des éléments pour éviter le recalcul à chaque sous itération"),
    "VT13": _(u"stockage des vecteurs propre des tailles des éléments pour éviter le recalcul à chaque sous itération"),
    "VT21": _(u"stockage des vecteurs propre des tailles des éléments pour éviter le recalcul à chaque sous itération"),
    "VT22": _(u"stockage des vecteurs propre des tailles des éléments pour éviter le recalcul à chaque sous itération"),
    "VT23": _(u"stockage des vecteurs propre des tailles des éléments pour éviter le recalcul à chaque sous itération"),
    "VT31": _(u"stockage des vecteurs propre des tailles des éléments pour éviter le recalcul à chaque sous itération"),
    "VT32": _(u"stockage des vecteurs propre des tailles des éléments pour éviter le recalcul à chaque sous itération"),
    "VT33": _(u"stockage des vecteurs propre des tailles des éléments pour éviter le recalcul à chaque sous itération"),
    "VTOT": _(u"variation volumique"),
    "VVE1": _(u"Vitesse de fluage de Kelvin au droit des fissure localisée utile pour le calcul des ouvertures de fissures en présence de fluage"),
    "VVE2": _(u"Vitesse de fluage de Kelvin au droit des fissure localisée utile pour le calcul des ouvertures de fissures en présence de fluage"),
    "VVE3": _(u"Vitesse de fluage de Kelvin au droit des fissure localisée utile pour le calcul des ouvertures de fissures en présence de fluage"),
    "VVE4": _(u"Vitesse de fluage de Kelvin au droit des fissure localisée utile pour le calcul des ouvertures de fissures en présence de fluage"),
    "VVE5": _(u"Vitesse de fluage de Kelvin au droit des fissure localisée utile pour le calcul des ouvertures de fissures en présence de fluage"),
    "VVE6": _(u"Vitesse de fluage de Kelvin au droit des fissure localisée utile pour le calcul des ouvertures de fissures en présence de fluage"),
    "VWE": _(u"volume d eau"),
    "WL1": _(u"ouvertures suivant les axes principaux de l'endommagement de traction localisé"),
    "WL2": _(u"ouvertures suivant les axes principaux de l'endommagement de traction localisé"),
    "WL3": _(u"ouvertures suivant les axes principaux de l'endommagement de traction localisé"),
    "WLM1": _(u"ouverture maxi des fissures localisées"),
    "WLM2": _(u"ouverture maxi des fissures localisées"),
    "WLM3": _(u"ouverture maxi des fissures localisées"),
    "WLM4": _(u"ouverture maxi des fissures localisées"),
    "WLM5": _(u"ouverture maxi des fissures localisées"),
    "WLM6": _(u"ouverture maxi des fissures localisées"),
    "X1": _(u"coordonnée X de la pointe de fissure après rupture par propagation,"),
    "X2": _(u"coordonnée X de la pointe de fissure 2 lors de l'amorçage,"),
    "XCINXX": _(u"tenseur cinématique, composante XX"),
    "XCINXY": _(u"tenseur cinématique, composante XY"),
    "XCINXZ": _(u"tenseur cinématique, composante XZ"),
    "XCINYY": _(u"tenseur cinématique, composante YY"),
    "XCINYZ": _(u"tenseur cinématique, composante YZ"),
    "XCINZZ": _(u"tenseur cinématique, composante ZZ"),
    "XFLEX1": _(u"GLRC_DAMAGE : tenseur d'écrouissage cinématique en flexion composante 1"),
    "XFLEX2": _(u"GLRC_DAMAGE : tenseur d'écrouissage cinématique en flexion composante 2"),
    "XFLEX3": _(u"GLRC_DAMAGE : tenseur d'écrouissage cinématique en flexion composante 3"),
    "XGFW": _(u"coeff d affinite probabiliste sur l energie de fissuration"),
    "XHXY1": _(u"Hujeux : coordonnée du point de tangence à la surface de charge du mécanisme déviatoire du plan 3, composante 1"),
    "XHXY2": _(u"Hujeux : coordonnée du point de tangence à la surface de charge du mécanisme déviatoire du plan 3, composante 2"),
    "XHXZ1": _(u"Hujeux : coordonnée du point de tangence à la surface de charge du mécanisme déviatoire du plan 2, composante1"),
    "XHXZ2": _(u"Hujeux : coordonnée du point de tangence à la surface de charge du mécanisme déviatoire du plan 2, composante2"),
    "XHYZ1": _(u"Hujeux : coordonnée du point de tangence à la surface de charge du mécanisme déviatoire du plan 1, composante 1"),
    "XHYZ2": _(u"Hujeux : coordonnée du point de tangence à la surface de charge du mécanisme déviatoire du plan 1, composante 2"),
    "XIP": _(u"variable d'écrouissage élastoplastique"),
    "XIVP": _(u"variable d'écrouissage viscoplastique"),
    "XMEMB1": _(u"GLRC_DAMAGE : tenseur d'écrouissage cinématique en membrane composante 1"),
    "XMEMB2": _(u"GLRC_DAMAGE : tenseur d'écrouissage cinématique en membrane composante 2"),
    "XMEMB3": _(u"GLRC_DAMAGE : tenseur d'écrouissage cinématique en membrane composante 3"),
    "XNL": _(u"variable de calcul non local pour Weibull"),
    "XRTT": _(u"coeff multiplicateur pour effet d echelle temporelle"),
    "XRTW": _(u"coeff de modif de la resistane a la traction par effet de Weibull"),
    "Y1": _(u"coordonnée Y de la pointe de fissure après rupture par propagation,"),
    "Y2": _(u"coordonnée Y de la pointe de fissure 2 lors de l'amorçage,"),
    "ZIRCALPH": _(u"phase métallurgique zirconium ALPHA"),
    "ZIRCALBE": _(u"phase métallurgique zirconium ALPHA/BETA"),
    "ZIRCBETA": _(u"phase métallurgique zirconium BETA"),
}
