# Copyright (C) 2009-2016  OPEN CASCADE
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
#

#  Author : Roman NIKOLAEV Open CASCADE S.A.S. (roman.nikolaev@opencascade.com)
#  Date   : 13/04/2009

#------------------------------------------------------------

AC_DEFUN([CHECK_PYLIGHT],[

AC_CHECKING(for PyLight)

PyLight_ok=no

PYLIGHT_LDFLAGS=""
PYLIGHT_CXXFLAGS=""

AC_ARG_WITH(gui,
	    --with-py-light=DIR root directory path of PYLIGHT installation,
	    PYLIGHT_DIR="$withval",PYLIGHT_DIR="")

if test "x$PYLIGHT_DIR" = "x" ; then

# no --with-light option used

  if test "x$PYLIGHT_ROOT_DIR" != "x" ; then

    # PYLIGHT_ROOT_DIR environment variable defined
    LIGHT_DIR=$PYLIGHT_ROOT_DIR

  else

    # search PYLIGHT binaries in PATH variable
    AC_PATH_PROG(TEMP, PYLIGHTGUI.py)
    if test "x$TEMP" != "x" ; then
      PYLIGHT_BIN_DIR=`dirname $TEMP`
      PYLIGHT_DIR=`dirname $PYLIGHT_BIN_DIR`
    fi

  fi
#
fi

if test -f ${PYLIGHT_DIR}/lib/salome/PYLIGHTGUI.py  ; then
  PyLight_ok=yes
  AC_MSG_RESULT(Using PYLIGHT distribution in ${PYLIGHT_DIR})

  if test "x$PYLIGHT_ROOT_DIR" == "x" ; then
    PYLIGHT_ROOT_DIR=${PYLIGHT_DIR}
  fi
  AC_SUBST(PYLIGHT_ROOT_DIR)
else
  AC_MSG_WARN("Cannot find compiled PYLIGHT distribution")
fi
  
AC_MSG_RESULT(for PYLIGHT: $PyLight_ok)
 
])dnl
 
