// Copyright (C) 2010-2016  CEA/DEN, EDF R&D
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
// See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  File   : PARAVIS_version.h
//  Author : Sergey ANIKIN
//  Module : PARAVIS

#if !defined(__PARAVIS_VERSION_H__)
#define __PARAVIS_VERSION_H__

/*!
  Specify version of SALOME PARAVIS module, as follows

  PARAVIS_VERSION_MAJOR       : (integer) number identifying major version
  PARAVIS_VERSION_MINOR       : (integer) number identifying minor version
  PARAVIS_VERSION_MAINTENANCE : (integer) number identifying maintenance version
  PARAVIS_VERSION_STR         : (string)  complete version number "major.minor.maintenance"
  PARAVIS_VERSION             : (hex)     complete version number (major << 16) + (minor << 8) + maintenance
  PARAVIS_DEVELOPMENT         : (integer) indicates development version when set to 1
*/

#define PARAVIS_VERSION_MAJOR       8
#define PARAVIS_VERSION_MINOR       3
#define PARAVIS_VERSION_MAINTENANCE 0
#define PARAVIS_VERSION_STR         "8.3.0"
#define PARAVIS_VERSION             0x080300
#define PARAVIS_DEVELOPMENT         0

#endif // __PARAVIS_VERSION_H__
