#  -*- coding: iso-8859-1 -*-
# Copyright (C) 2007-2016  CEA/DEN, EDF R&D
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
#
# Author : Anthony Geay

from MEDLoader import *

"""This test focuses on fields on pfls on cells and faces of a cartesian mesh."""

fname="testMEDReader11.med"
outImgName="testMEDReader11.png"
#
arrX=DataArrayDouble([1.6128,1.72032,1.93536,2.1504,2.36544,2.58048,2.79552,3.01056,3.2256]) ; arrX.setInfoOnComponent(0,"x [m]")
arrY=DataArrayDouble([1.6128,1.72032,1.93536,2.1504,2.36544,2.58048,2.79552,3.01056,3.2256]) ; arrY.setInfoOnComponent(0,"y [m]")
arrZ=DataArrayDouble([4.0825,4.21725,4.352,4.5276,4.5724]) ; arrZ.setInfoOnComponent(0,"z [m]")
cm=MEDCouplingCMesh()
cm.setCoords(arrX,arrY,arrZ)
cm.setName("Maillage_THYC")
mm=MEDFileCMesh()
mm.setMesh(cm)
mm.write(fname,2)
#
pfl0=DataArrayInt([0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,40,41,42,43,44,45,46,48,49,50,51,52,53,56,57,58,59,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,104,105,106,107,108,109,110,112,113,114,115,116,117,120,121,122,123,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,168,169,170,171,172,173,174,176,177,178,179,180,181,184,185,186,187,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,232,233,234,235,236,237,238,240,241,242,243,244,245,248,249,250,251]) ; pfl0.setName("MAILLE_REELLE")
pfl1=DataArrayInt([0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,256,257,258,259,260,261,262,263,264,265,266,267,268,269,270,271]) ; pfl1.setName("FACEX_REELLE")
pfl2=DataArrayInt([288,289,290,291,292,293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,320,321,322,323,324,325,326,327,328,329,330,331,332,333,334,335,336,337,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,353,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,388,389,390,391,392,393,394,395,396,397,398,399,400,401,402,403,404,405,406,407,408,409,410,411,412,413,414,415,416,417,418,419,420,421,422,423,424,425,426,427,428,429,430,431,432,433,434,435,436,437,438,439,440,441,442,443,444,445,446,447,448,449,450,451,452,453,454,455,456,457,458,459,460,461,462,463,464,465,466,467,468,469,470,471,472,473,474,475,480,481,482,483,484,485,486,487,488,489,490,491,492,493,494,495,496,497,498,499,500,501,502,503,504,505,506,507,512,513,514,515,516,517,518,519,520,521,522,523,524,525,526,527,528,529,530,531,532,533,534,535,544,545,546,547,548,549,550,551,552,553,554,555,556,557,558,559]) ; pfl2.setName("FACEY_REELLE")
pfl3=DataArrayInt([576,577,578,579,580,581,582,583,584,585,586,587,588,589,590,591,592,593,594,595,596,597,598,599,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,616,617,618,619,620,621,622,624,625,626,627,628,629,632,633,634,635,640,641,642,643,644,645,646,647,648,649,650,651,652,653,654,655,656,657,658,659,660,661,662,663,664,665,666,667,668,669,670,671,672,673,674,675,676,677,678,680,681,682,683,684,685,686,688,689,690,691,692,693,696,697,698,699,704,705,706,707,708,709,710,711,712,713,714,715,716,717,718,719,720,721,722,723,724,725,726,727,728,729,730,731,732,733,734,735,736,737,738,739,740,741,742,744,745,746,747,748,749,750,752,753,754,755,756,757,760,761,762,763,768,769,770,771,772,773,774,775,776,777,778,779,780,781,782,783,784,785,786,787,788,789,790,791,792,793,794,795,796,797,798,799,800,801,802,803,804,805,806,808,809,810,811,812,813,814,816,817,818,819,820,821,824,825,826,827,832,833,834,835,836,837,838,839,840,841,842,843,844,845,846,847,848,849,850,851,852,853,854,855,856,857,858,859,860,861,862,863,864,865,866,867,868,869,870,872,873,874,875,876,877,878,880,881,882,883,884,885,888,889,890,891]) ; pfl3.setName("FACEZ_REELLE")
#
nrj_0_1=DataArrayDouble([49980250.739945136,49997118.86371836,46623494.10908149,37852069.74702562,39471409.6292513,37852069.74702569,39842508.35226136,21928560.90513961,49997118.86371836,49997118.86371841,42541408.15597093,39471409.62925134,31239765.22793739,37852069.74702573,37514707.27156196,31712072.693586547,46623494.10908149,42541408.15597093,41360639.49184804,30463831.534370907,19600759.824440192,29789106.583443597,36435147.350078166,26685371.809177615,37852069.74702562,39471409.62925134,30463831.534370907,32420533.892060254,28405920.434042387,35524268.66632625,35625477.408965275,23109329.569262516,39471409.6292513,31239765.22793739,19600759.824440192,28405920.434042387,36300202.35989265,34174818.76447149,33027786.347894896,37852069.74702569,37852069.74702573,29789106.583443597,35524268.66632625,34174818.76447149,36738773.5779956,19263397.348976526,39842508.35226136,37514707.27156196,36435147.350078166,35625477.408965275,33027786.347894896,19263397.348976526,21928560.90513961,31712072.693586547,26685371.809177615,23109329.569262516,20937450.719275985,20944517.020564992,19531256.762767084,15856780.92492515,16535145.016235504,15856780.92492547,16690603.644593278,9186191.675686393,20944517.020564992,20944517.020565014,17821211.850831635,16535145.016235521,13086789.987208627,15856780.92492564,15715454.066712739,13284646.423300333,19531256.762767084,17821211.850831635,17326570.76060237,12761740.127915107,8211042.097805845,12479088.076355552,15263210.784217406,11178888.639181452,15856780.92492515,16535145.016235521,12761740.127915107,13581431.077437881,11899651.370658372,14881630.514611986,14924028.32234589,9680832.76591566,16535145.016235504,13086789.987208627,8211042.097805845,11899651.370658372,15206680.373905474,14316326.411492817,13835817.923841504,15856780.92492547,15856780.92492564,12479088.076355552,14881630.514611986,14316326.411492817,15390404.207419263,8069716.072026062,16690603.644593278,15715454.066712739,15263210.784217406,14924028.32234589,13835817.923841504,8069716.072026062,9186191.675686393,13284646.423300333,11178888.639181452,9680832.76591566,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.])
nrj_0_1.setInfoOnComponent(0,"- [J/kg]")
h_0=DataArrayDouble([0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9223840872291476,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9214142372366041,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9203203502111137,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702,0.9195585290435702]) ; h_0+=1278022.
h_0.setInfoOnComponent(0,"- [J/kg]")
h_1=DataArrayDouble([1707193.5978477711,1706680.071128439,1675298.880293715,1601056.2085307203,1606306.6047159557,1594561.8541066758,1609077.181469409,1463129.0460355966,1706680.0711284394,1705133.653210327,1646964.5287915035,1610142.778223492,1541197.578460137,1591612.2007810709,1590674.1654269584,1539980.1003904382,1675298.8802937143,1646964.5287915033,1627491.3954009535,1538286.0071971477,1446464.812125112,1524026.5146543428,1579393.901579361,1499535.5893318024,1601056.2085307199,1610142.7782234924,1538286.0071971482,1545239.955225724,1512988.5731550949,1570989.2143312085,1573098.0322487084,1469781.4110798093,1606306.6047159557,1541197.578460137,1446464.8121251126,1512988.5731550949,1576766.5407206328,1562392.3969638983,1551122.7814057101,1594561.8541066758,1591612.2007810709,1524026.514654343,1570989.214331209,1562392.3969638986,1580259.850172817,1440025.6068089742,1609077.1814694093,1590674.1654269581,1579393.9015793614,1573098.0322487084,1551122.7814057101,1440025.6068089742,1463129.0460355966,1539980.1003904382,1499535.5893318024,1469781.411079809,1708662.9998022616,1708129.2893356946,1676579.3523699266,1602363.8117384266,1607304.9271424229,1595667.6716220675,1610076.111165725,1464034.4308848085,1708129.2893356949,1706525.0463378802,1648191.1473162076,1611277.0989177777,1542287.1250714804,1592562.7299295843,1591724.4521483583,1540837.4634551322,1676579.3523699269,1648191.1473162074,1628484.2933928836,1539471.2736180348,1447438.4998261146,1524863.4766562376,1580310.2322566814,1500384.0745638395,1602363.8117384266,1611277.0989177779,1539471.2736180353,1546078.1599080698,1513821.5182706374,1571852.9108575245,1574031.9381076966,1470554.960494518,1607304.9271424229,1542287.1250714804,1447438.4998261149,1513821.5182706374,1577594.8275246841,1563390.579853997,1552013.1563359816,1595667.6716220675,1592562.7299295843,1524863.4766562376,1571852.9108575247,1563390.5798539973,1581078.28020071,1440776.029922329,1610076.1111657252,1591724.4521483583,1580310.232256682,1574031.9381076966,1552013.1563359816,1440776.029922329,1464034.4308848085,1540837.4634551322,1500384.0745638395,1470554.960494518,1708633.6572019386,1708082.5909808695,1676574.5221266153,1602705.4765794547,1607123.196116413,1595696.386114491,1609876.1772222994,1464701.091025861,1708082.5909808702,1706443.9486524272,1648801.5106365879,1611306.631905331,1542750.815136018,1592362.0556866801,1591692.343642542,1540826.8832543544,1676574.5221266148,1648801.5106365879,1628365.1330480182,1540258.3408503362,1448308.4766427176,1524944.381073225,1580151.6447241844,1500621.0407745198,1602705.476579454,1611306.6319053315,1540258.3408503365,1545972.6490343718,1513916.3380209352,1571672.694518838,1573924.2707864814,1470851.5892692045,1607123.196116413,1542750.8151360182,1448308.4766427178,1513916.3380209352,1577358.6838762078,1563432.6963735586,1551964.324298151,1595696.3861144907,1592362.0556866801,1524944.381073225,1571672.694518838,1563432.6963735586,1580765.3699054038,1441419.52299663,1609876.1772222994,1591692.343642542,1580151.6447241846,1573924.2707864814,1551964.324298151,1441419.52299663,1464701.091025861,1540826.8832543544,1500621.0407745198,1470851.5892692045,1708432.6109588896,1707876.3546041045,1676401.0172684519,1602495.0128238203,1607049.1393951927,1595671.1131709353,1609802.0854621006,1464748.9649476882,1707876.3546041055,1706224.115966094,1646745.9812830612,1611147.1865408437,1542741.7849835826,1592309.0965317544,1591655.7628271556,1540779.4948269252,1676401.0172684516,1646745.9812830605,1628047.2222845491,1540228.7550678025,1448350.7194848624,1524936.3755608685,1580095.6006214477,1500613.317021065,1602495.0128238199,1611147.1865408437,1540228.755067803,1545927.5440642927,1513907.5223398127,1571621.0228637396,1573870.0660614343,1470853.4676345135,1607049.1393951927,1542741.7849835828,1448350.7194848624,1513907.5223398127,1577297.366572899,1563410.7906347204,1551919.866229521,1595671.113170935,1592309.0965317544,1524936.3755608685,1571621.0228637396,1563410.7906347204,1580668.7969403658,1441446.3515266203,1609802.0854621006,1591655.7628271556,1580095.6006214477,1573870.0660614343,1551919.866229521,1441446.3515266203,1464748.9649476882,1540779.4948269252,1500613.317021065,1470853.4676345135])
h_1.setInfoOnComponent(0,"- [J/kg]")
#
p_0=DataArrayDouble([15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15503268.150628341,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15502278.358422533,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15501138.536489055,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232,15500329.07377232])
p_0.setInfoOnComponent(0,"- [Pa]")
p_1=DataArrayDouble([15551357.765131623,15551250.42141628,15550979.700887434,15550660.243194763,15550323.466906475,15550149.779261714,15550007.369269539,15549993.272197371,15551250.421416283,15551091.02796482,15550997.088469505,15550587.99639021,15550331.763730764,15550121.829873659,15550011.52278095,15549943.048277102,15550979.700887434,15550997.088469505,15550628.007191319,15550459.60922553,15550282.55177755,15550099.904283773,15549969.050884046,15549944.681337206,15550660.243194763,15550587.99639021,15550459.60922553,15550271.004376523,15550144.453558365,15550011.236332033,15549935.175714444,15549931.786933027,15550323.466906475,15550331.763730764,15550282.55177755,15550144.453558365,15550018.806561679,15549967.905981027,15549922.577220777,15550149.779261714,15550121.829873659,15550099.904283773,15550011.236332033,15549967.905981027,15549893.077592332,15549947.768942442,15550007.369269539,15550011.52278095,15549969.050884046,15549935.175714444,15549922.577220777,15549947.768942442,15549993.272197371,15549943.048277102,15549944.681337206,15549931.786933027,15548981.279762102,15548876.710861823,15548514.269864595,15548094.377751365,15547771.82687132,15547593.281374065,15547465.048694642,15547368.84493183,15548876.710861823,15548722.796257973,15548402.447121516,15548030.99524092,15547739.758480769,15547566.454188002,15547456.882739155,15547362.678837247,15548514.269864593,15548402.447121516,15548124.257209042,15547862.74433127,15547642.359225657,15547506.88539034,15547410.220052736,15547341.650040662,15548094.377751365,15548030.99524092,15547862.74433127,15547686.199053222,15547543.972694844,15547446.732869877,15547373.000857387,15547313.7380713,15547771.82687132,15547739.758480769,15547642.359225657,15547543.972694844,15547457.653779456,15547397.53664531,15547348.32451941,15547593.281374065,15547566.454188002,15547506.88539034,15547446.732869877,15547397.53664531,15547337.238160651,15547313.527979365,15547465.048694642,15547456.882739155,15547410.220052736,15547373.000857387,15547348.32451941,15547313.527979365,15547368.84493183,15547362.678837247,15547341.650040662,15547313.7380713,15546460.79585754,15546357.8618016,15545839.174886756,15545179.511749623,15544847.353243,15544670.564591702,15544558.941854678,15544338.225100564,15546357.8618016,15546191.296459893,15545611.18718342,15545115.397224706,15544757.420820273,15544637.592374247,15544537.112181643,15544392.006415347,15545839.174886754,15545611.187183417,15545258.859096888,15544878.703066424,15544586.141850697,15544522.6000548,15544476.30135792,15544339.977397926,15545179.511749623,15545115.397224706,15544878.703066424,15544708.929058125,15544544.82970803,15544501.911874704,15544435.114128752,15544287.10424085,15544847.353243,15544757.420820273,15544586.141850697,15544544.82970803,15544514.550530668,15544452.528329566,15544390.02094777,15544670.564591702,15544637.592374247,15544522.6000548,15544501.911874704,15544452.528329566,15544398.304726249,15544267.606488569,15544558.941854678,15544537.112181643,15544476.30135792,15544435.114128752,15544390.02094777,15544267.606488569,15544338.225100564,15544392.006415347,15544339.977397926,15544287.10424085,15500742.74151361,15500742.175963653,15500775.049382735,15500844.05363197,15500841.349656178,15500842.793543914,15500837.362251949,15500872.17386759,15500742.175963653,15500742.220409457,15500799.523214351,15500842.058560695,15500857.830645358,15500843.22433348,15500842.318614803,15500854.013424614,15500775.049382733,15500799.523214351,15500836.839194197,15500859.581032272,15500878.623566628,15500859.574569272,15500844.70397097,15500863.493582187,15500844.05363197,15500842.058560695,15500859.581032272,15500856.278663723,15500862.58317934,15500847.27846993,15500845.924456576,15500869.98910656,15500841.349656178,15500857.830645358,15500878.623566628,15500862.58317934,15500845.918172201,15500849.012086647,15500851.205693366,15500842.793543914,15500843.22433348,15500859.574569272,15500847.27846993,15500849.012086647,15500843.61552367,15500876.57264411,15500837.362251949,15500842.318614803,15500844.70397097,15500845.924456576,15500851.205693366,15500876.57264411,15500872.17386759,15500854.013424614,15500863.493582187,15500869.98910656])
p_1.setInfoOnComponent(0,"- [Pa]")
#
t_0=DataArrayDouble([0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.950278060884898,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9501752074851311,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9500567651375604,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577,0.9499726522601577]) ; t_0+=561.
t_0.setInfoOnComponent(0,"- [K]")
t_1=DataArrayDouble([618.1841066456732,618.1835813666848,618.1856259633387,614.4163290868107,615.1050236865734,613.6611522306131,615.4410429545915,594.7447808232702,618.1835813666848,618.1828517347558,618.1848140425273,615.5420943208575,606.5383698906265,613.2906926524488,613.172247447166,606.3676512993671,618.1856259633387,618.1848140425273,617.4446721885224,606.1194741115954,592.0455660141248,604.0750677066131,611.7256994989444,600.4284234522314,614.4163290868106,615.5420943208575,606.1194741115955,607.107944674456,602.4500386485399,610.6217828941678,610.9007726037626,595.805545846157,615.1050236865734,606.5383698906265,592.0455660141249,602.4500386485399,611.3829809077741,609.4703579879634,607.9279935638773,613.6611522306131,613.2906926524488,604.0750677066133,610.6217828941678,609.4703579879636,611.8381443485634,590.9877498290456,615.4410429545915,613.172247447166,611.7256994989446,610.9007726037626,607.9279935638773,590.9877498290456,594.7447808232702,606.3676512993671,600.4284234522314,595.805545846157,618.1690561725326,618.1685215715888,618.1675396987118,614.5736956327139,615.2243300813301,613.797656658745,615.5590339973002,594.8888488525006,618.1685215715888,618.1677480416948,618.1685603053771,615.6755479780859,606.6910916712018,613.4087783150145,613.3032019318707,606.487665507702,618.1675396987118,618.1685603053769,617.6107649913579,606.2879820489304,592.2041696085278,604.1958481500603,611.8431975522402,600.5561863494399,614.5736956327139,615.6755479780859,606.2879820489304,607.2241573486538,602.5726414391355,610.7347609531276,611.0224297064647,595.9273745982524,615.2243300813301,606.6910916712018,592.2041696085278,602.5726414391355,611.4897575459067,609.603771919421,608.0498472595787,613.797656658745,613.4087783150145,604.1958481500603,610.7347609531276,609.6037719194211,611.9427094511283,591.1107455229892,615.5590339973003,613.3032019318707,611.8431975522402,611.0224297064647,608.0498472595787,591.1107455229892,594.8888488525006,606.487665507702,600.5561863494399,595.9273745982524,618.1556971987327,618.1551679790961,618.1528020796541,614.6149226840873,615.2008475261711,613.79936498802,615.5330628041404,594.9944474419851,618.1551679790961,618.1543217277318,618.153023527253,615.679087972638,606.7552835961568,613.3816803873459,613.2973025270999,606.4847180548345,618.1528020796541,618.153023527253,617.6238972111182,606.3998067487031,592.3455205744151,604.2062832971247,611.820865455767,600.5909279402423,614.6149226840872,615.679087972638,606.3998067487031,607.2080717445687,602.5854419157467,610.7092172128082,611.0065485588964,595.9733619713759,615.2008475261711,606.7552835961568,592.3455205744151,602.5854419157467,611.4571766470203,609.6078388175779,608.0415678391975,613.7993649880199,613.3816803873459,604.2062832971247,610.7092172128082,609.6078388175779,611.9004110457627,591.215888084383,615.5330628041404,613.2973025270999,611.820865455767,611.0065485588964,608.0415678391975,591.215888084383,594.9944474419851,606.4847180548345,600.5909279402423,595.9733619713759,617.9515635584473,617.951716333408,617.9735720645355,614.5841757554348,615.1622455433228,613.7678190405226,615.4936128030074,594.9876594034737,617.951716333408,617.9523014782075,618.0105606060424,615.6413627408896,606.7328282477313,613.3471266861239,613.2649468491189,606.4567244011678,617.9735720645355,618.0105606060423,617.5839108464855,606.3765159853605,592.3392452361513,604.1854090155407,611.7875087032137,600.5723938755808,614.5841757554347,615.6413627408896,606.3765159853605,607.1799475704678,602.5654958672613,610.6773939127452,610.9741777480358,595.9587761542601,615.1622455433228,606.7328282477314,592.3392452361513,602.5654958672613,611.4234364107792,609.5809527231598,608.012893408742,613.7678190405226,613.3471266861239,604.1854090155407,610.6773939127452,609.5809527231598,611.8617801876443,591.2075507662224,615.4936128030074,613.2649468491189,611.7875087032137,610.9741777480358,608.012893408742,591.2075507662224,594.9876594034737,606.4567244011678,600.5723938755808,595.9587761542601])
t_1.setInfoOnComponent(0,"- [K]")
#
vx_0=DataArrayDouble(256) ; vx_0[:]=0.
vx_0.setInfoOnComponent(0,"- [m/s]")
vx_1=DataArrayDouble([0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,1.1344206589009406e-11,0.13777212445503569,0.21011055302288695,4.024118903700059e-12,1.612127714589811e-11,0.18574910871094842,0.28891924478243673,5.513747312563484e-12,3.4141133291590045e-12,0.1046125377121644,0.277369962252552,4.734973249030581e-12,5.205206690367901e-12,0.04892166169554829,0.0669791148945737,1.304725242681302e-12,7.592141368438977e-13,0.0239535789545882,0.08891353899577627,1.4357845549109703e-12,2.069477614015718e-12,0.02043325551226558,0.03619829946451167,6.824095201904451e-13,1.3536494894586423e-13,0.006085932509367348,0.01961200257866551,3.005029515277489e-13,2.3263601616898956e-12,0.004454470066172948,-0.04176214531137861,-5.366085790916931e-13,2.7594846823464802e-11,0.26708971374098396,0.5093370051464718,1.204031797285656e-11,2.2043528584973886e-11,0.30350740289889478,0.7555587819283606,1.7118620211764295e-11,3.6802797354706385e-11,0.24389255744370075,0.4542994209552623,1.0699984868461137e-11,1.3624414594904585e-11,0.12200335093350312,0.22448447815623176,5.358659031116372e-12,6.0839333312827734e-12,0.06284371304790417,0.1611309681127474,3.734533635671857e-12,3.466405429182274e-12,0.039733424183500754,0.12778451967944597,2.9688614243749975e-12,3.527318482184164e-12,0.03004665819239134,0.05399225171225064,1.332698908468408e-12,7.969850505796324e-13,0.01482877294477144,0.04080744916198842,8.95896602794255e-13,3.035237412958874e-11,0.24893516908233704,0.5043844662868034,1.105929026287912e-11,3.8503611543307607e-11,0.2754696165710353,0.5005528471630809,1.171826008033003e-11,2.3106546683789947e-11,0.22604049666958774,0.4532970133599712,1.0936637910237274e-11,1.8397969358477885e-11,0.15003271708548734,0.2205547595693503,5.646237834375293e-12,1.0774749659431905e-11,0.07512804441581292,0.05888022781931716,1.735863763747967e-12,6.641762894333568e-12,0.04533285813425782,0.04104367240274322,1.2270553047563658e-12,2.9695401704118747e-12,0.025816481205304196,0.03915147945047681,9.748936528225525e-13,1.7344431981100495e-12,0.021194844183064776,0.05049485927865529,1.1851412370283702e-12,2.6341366323289677e-11,0.17527873235007648,0.24966228595305444,6.367191831499065e-12,2.3115062966917642e-11,0.18298181412665534,0.3330461947771215,8.091521156370611e-12,1.838406585800771e-11,0.1662795247995679,0.3032651263438391,7.30078702686326e-12,1.3847317435754685e-11,0.12256900588806978,0.18941580254573077,4.6862910768912306e-12,1.0599119239802832e-11,0.07486590518636529,0.05603603715341696,1.6787276418318527e-12,4.746757460217602e-12,0.04174285675071622,0.06792190067383477,1.6960185476713463e-12,1.7049634204578462e-12,0.019184527387358528,0.03960251948954569,9.257724198742812e-13,0.,0.,0.,0.,1.4177415777889301e-11,0.09702455596199398,0.13587961592795664,3.416001923719578e-12,1.6523620688002428e-11,0.10670867925882104,0.14604729028523441,3.953412450612833e-12,1.4440329511576989e-11,0.09545240635681953,0.09651568257046845,2.750131053574494e-12,1.1290020476606096e-11,0.07957820886530617,0.06713293785764922,1.941792078716636e-12,6.2390063801685274e-12,0.05412512264104467,0.08859284873715468,2.197412609936601e-12,6.435563255308967e-12,0.05427553329831927,0.08083245950228574,2.1364268996247426e-12,8.509129637798413e-13,0.02902729118622183,0.11348507238198809,2.4762950217111915e-12,1.0792779820701251e-11,0.069451080466159144,0.08471824603215147,2.23488683584132e-12,9.36306741078277e-12,0.06755101784067628,0.10353933634500316,2.639363103834178e-12,1.0080018190324988e-11,0.067668280231117425,0.066892224699172526,1.929724188475104e-12,6.902256511090752e-12,0.05491819090199326,0.07574036118658778,1.94215098823017e-12,4.774425950596191e-12,0.04383824019950572,0.07151004386909156,1.7794515560265796e-12,-5.590565105905348e-13,0.020046012023714564,0.1381939453045845,2.967229775273233e-12,0.,0.,0.,0.,3.5465817502036102e-12,0.05048498011276931,0.1467616022428175,3.1409788398244126e-12,6.1836015163151154e-12,0.05748975628008563,0.10625955127326588,2.5025940312083633e-12,4.1151655412957694e-12,0.051352895290015755,0.13255212665044704,3.0493972411079473e-12,2.5271335140814635e-12,0.04142601674177084,0.11962968107073847,2.6449851983928128e-12,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.])
vx_1.setInfoOnComponent(0,"- [m/s]")
#
vy_0=DataArrayDouble(256) ; vy_0[:]=0.
vy_0.setInfoOnComponent(0,"- [m/s]")
vy_1=DataArrayDouble([0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,1.1344206589003178e-11,0.13777212445496333,0.21011055302291182,4.024118903704486e-12,1.612127714589167e-11,0.1857491087108428,0.28891924478244603,5.513747312567618e-12,3.4141133291963803e-12,0.10461253771199193,0.27736996225236153,4.734973249011425e-12,5.205206690366353e-12,0.04892166169552049,0.06697911489454987,1.304725242681033e-12,7.59214136844569e-13,0.023953578954600797,0.0889135389957673,1.4357845549109573e-12,2.0694776140138044e-12,0.020433255512266233,0.0361982994645095,6.824095201907787e-13,1.353649489401137e-13,0.006085932509367072,0.01961200257866555,3.005029515275786e-13,2.3263601616894404e-12,0.004454470066175331,-0.04176214531137554,-5.366085790916619e-13,2.759484682347234e-11,0.2670897137409751,0.5093370051464797,1.2040317972850642e-11,2.2043528584938272e-11,0.3035074028989229,0.755558781928531,1.7118620211781724e-11,3.680279735467177e-11,0.24389255744370713,0.4542994209554051,1.069998486847749e-11,1.3624414594903964e-11,0.12200335093349909,0.22448447815623412,5.358659031116325e-12,6.083933331281451e-12,0.06284371304790164,0.1611309681127495,3.7345336356718185e-12,3.4664054291785365e-12,0.03973342418349267,0.12778451967944597,2.9688614243749503e-12,3.527318482185579e-12,0.030046658192390873,0.05399225171225483,1.3326989084686373e-12,7.969850505801299e-13,0.014828772944771738,0.04080744916198886,8.958966027943089e-13,3.0352374129586713e-11,0.24893516908242836,0.50438446628676165,1.1059290262879936e-11,3.850361154334228e-11,0.275469616571037,0.50055284716293835,1.171826008031372e-11,2.3106546683790864e-11,0.22604049666958455,0.4532970133599674,1.0936637910237124e-11,1.8397969358478793e-11,0.1500327170854877,0.22055475956934505,5.646237834375099e-12,1.0774749659432231e-11,0.07512804441581255,0.05888022781931371,1.7358637637479712e-12,6.641762894335265e-12,0.04533285813426652,0.04104367240274106,1.227055304756493e-12,2.969540170410839e-12,0.02581648120530273,0.03915147945047351,9.74893652822482e-13,1.7344431981102015e-12,0.02119484418306707,0.0504948592786564,1.1851412370284913e-12,2.6341366323290966e-11,0.1752787323501015,0.2496622859530608,6.367191831499332e-12,2.3115062966916808e-11,0.18298181412665402,0.3330461947771171,8.091521156370643e-12,1.8384065858007747e-11,0.16627952479956163,0.30326512634383785,7.30078702686336e-12,1.3847317435755355e-11,0.1225690058880658,0.1894158025457279,4.686291076891146e-12,1.0599119239803562e-11,0.07486590518636106,0.05603603715341608,1.678727641831818e-12,4.746757460221935e-12,0.04174285675071262,0.067921900673843455,1.6960185476714709e-12,1.7049634204580688e-12,0.019184527387355423,0.0396025194895433,9.257724198742138e-13,0.,0.,0.,0.,1.4177415777887817e-11,0.09702455596198712,0.1358796159279616,3.416001923719866e-12,1.6523620688003475e-11,0.10670867925882337,0.1460472902852347,3.953412450612793e-12,1.4440329511580466e-11,0.09545240635682366,0.09651568257046909,2.7501310535744093e-12,1.1290020476608075e-11,0.07957820886530187,0.06713293785764673,1.9417920787163823e-12,6.239006380166912e-12,0.05412512264104154,0.0885928487371459,2.1974126099362736e-12,6.435563255307417e-12,0.05427553329831618,0.08083245950227797,2.136426899624439e-12,8.509129637792394e-13,0.029027291186218135,0.11348507238197426,2.4762950217080278e-12,1.0792779820697871e-11,0.06945108046616426,0.08471824603215574,2.2348868358411214e-12,9.36306741078326e-12,0.06755101784068314,0.10353933634500599,2.6393631038344922e-12,1.0080018190320224e-11,0.06766828023111629,0.06689222469917198,1.9297241884751623e-12,6.902256511088822e-12,0.05491819090200067,0.07574036118658685,1.942150988230387e-12,4.7744259505983125e-12,0.04383824019951468,0.0715100438691009,1.7794515560269655e-12,-5.590565105893459e-13,0.0200460120237228,0.13819394530459182,2.96722977527643e-12,0.,0.,0.,0.,3.5465817502089962e-12,0.05048498011277266,0.14676160224282185,3.1409788398246275e-12,6.1836015163154474e-12,0.057489756280087925,0.10625955127326758,2.5025940312083767e-12,4.115165541297016e-12,0.05135289529001548,0.13255212665045197,3.0493972411081165e-12,2.5271335140815564e-12,0.04142601674176666,0.11962968107074047,2.6449851983928293e-12,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.])
vy_1.setInfoOnComponent(0,"- [m/s]")
#
vz_0=DataArrayDouble([4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932346330243951,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932355637906689,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932364945724892,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932377075449937,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269,4.932378622763269])
vz_0.setInfoOnComponent(0,"- [m/s]")
vz_1=DataArrayDouble([7.349832160580091,7.3412494252968665,6.8265681348499925,6.037688449446315,6.032628951060745,5.985783695022618,6.02575328540414,5.64734497266171,7.3412494252968665,7.321708742744497,6.352380589937687,6.062789999961401,5.847851705776218,5.978163033819428,5.969208720348231,5.829862834874871,6.826568134850019,6.352380589937691,6.156502299509909,5.848656388561603,5.623601855611934,5.794251914680753,5.937077345478105,5.729925755241562,6.037688449446314,6.062789999961397,5.848656388561602,5.858773586600506,5.7702057032772665,5.91572234935386,5.918421177956426,5.662316971359428,6.032628951060745,5.84785170577622,5.623601855611933,5.7702057032772665,5.933191264162171,5.888975469854007,5.858436269571031,5.985783695022618,5.978163033819427,5.794251914680754,5.915722349353859,5.888975469854006,5.939914717327204,5.598743967266288,6.025753285404143,5.969208720348233,5.937077345478104,5.918421177956426,5.858436269571031,5.598743967266288,5.64734497266171,5.829862834874871,5.729925755241564,5.662316971359428,7.418621717213538,7.409580698826639,6.890019939503438,6.047004448200347,6.0415474829975615,5.9947477375717275,6.034852347832169,5.651842605325184,7.409580698826635,7.388785659885766,6.409556955370353,6.072224673745008,5.854638903882661,5.986456090656494,5.977788708395183,5.835966331821743,6.890019939503408,6.409556955370348,6.154960129948821,5.85521269831336,5.627770433633566,5.8000311059546785,5.944735600323997,5.734996849610944,6.047004448200343,6.072224673745005,5.855212698313357,5.865023414967229,5.7756338473407265,5.922954381961648,5.925866692719966,5.666539053908997,6.0415474829975615,5.854638903882661,5.627770433633565,5.7756338473407265,5.940519698443319,5.89633096686707,5.86501121959622,5.994747737571727,5.986456090656493,5.80003110595468,5.92295438196165,5.896330966867066,5.947130765712147,5.602362742275441,6.0348523478321665,5.977788708395183,5.9447356003239955,5.925866692719966,5.86501121959622,5.602362742275442,5.651842605325184,5.835966331821743,5.734996849610945,5.666539053908997,7.406051167645625,7.398592182256506,6.895598593079653,6.048268181804127,6.045602294566558,5.996860603343903,6.037394482042198,5.657043050192003,7.398592182256506,7.389243034209025,6.427592620353271,6.0751736638992755,5.859905718054873,5.989796830392787,5.979473917744552,5.8407573804046855,6.895598593079629,6.427592620353237,6.148823703982074,5.8600144952649105,5.634322923630218,5.803617378273333,5.947967190200876,5.739832952383712,6.048268181804123,6.075173663899271,5.860014495264909,5.870021622820003,5.780503535007995,5.926630091840758,5.929091366800336,5.6723084464302,6.045602294566554,5.859905718054874,5.634322923630217,5.780503535007995,5.944887410863348,5.898639958178519,5.869017022137498,5.996860603343902,5.989796830392787,5.803617378273333,5.92663009184076,5.898639958178516,5.95274095559223,5.60762204615107,6.037394482042198,5.979473917744553,5.947967190200874,5.929091366800335,5.869017022137498,5.607622046151069,5.657043050192003,5.8407573804046855,5.739832952383712,5.6723084464302005,7.3660708538767485,7.352378755066297,6.866580899398151,6.051221748716661,6.040228056987783,5.996177250915436,6.028714710432652,5.677268356281304,7.352378755066289,7.323658461684197,6.406656763040177,6.071115910062361,5.869964069043467,5.986025766955024,5.977056475288331,5.843007642107803,6.866580899398164,6.40665676304019,6.133977042599296,5.87216369110615,5.661125687914528,5.814199843538564,5.94393111462986,5.750697135422344,6.051221748716665,6.071115910062368,5.872163691106149,5.8752247917282485,5.791830984602159,5.924195887384471,5.92554560343197,5.687087811612532,6.0402280569877815,5.869964069043467,5.661125687914527,5.791830984602159,5.939832693577055,5.899909498506444,5.869010914130541,5.996177250915436,5.986025766955023,5.814199843538563,5.924195887384472,5.899909498506446,5.942065823030365,5.629231907842557,6.028714710432652,5.977056475288331,5.94393111462986,5.925545603431969,5.869010914130541,5.629231907842554,5.677268356281304,5.843007642107803,5.750697135422344,5.687087811612533,7.37316253913956,7.359407581815623,6.872667241578819,6.050263991490144,6.040405026173425,5.996416772364126,6.028919573113356,5.67745958302709,7.359407581815634,7.330545854301259,6.399677353372563,6.070711496373787,5.870149720205851,5.986233094808958,5.977279526093338,5.843172630202691,6.872667241578822,6.399677353372577,6.132597972049951,5.872264180218762,5.661299924160254,5.8143880798800005,5.944121990041686,5.7508677744682295,6.050263991490148,6.070711496373792,5.872264180218763,5.875390964702222,5.79201040459281,5.9243831711057195,5.925732005290623,5.687247879770933,6.040405026173424,5.87014972020585,5.661299924160253,5.79201040459281,5.940015973705896,5.900117216474172,5.86918716532528,5.996416772364126,5.986233094808958,5.8143880798800005,5.9243831711057195,5.9001172164741735,5.942216607212156,5.629394508858754,6.028919573113356,5.977279526093339,5.944121990041685,5.925732005290623,5.86918716532528,5.629394508858752,5.67745958302709,5.843172630202692,5.75086777446823,5.687247879770933])
vz_1.setInfoOnComponent(0,"- [m/s]")
#
poro=DataArrayDouble([0.5336735960954855,0.533673596095485,0.533673596095485,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.5336735960954855,0.533673596095485,0.5336735960954847,0.5336735960954847,0.533673596095485,0.533673596095485,0.5336735960954844,0.533673596095485,0.533673596095485,0.533673596095485,0.5336735960954847,0.5336735960954847,0.533673596095485,0.533673596095485,0.5336735960954844,0.533673596095485,0.533673596095485,0.5336735960954855,0.533673596095485,0.533673596095485,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.5336735960954855,0.5336735960954855,0.533673596095485,0.533673596095485,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.5336735960954847,0.5336735960954844,0.5336735960954844,0.5336735960954847,0.5336735960954847,0.5336735960954839,0.5336735960954847,0.5336735960954855,0.533673596095485,0.533673596095485,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.533673596095485,0.533673596095485,0.5336735960954855,0.5336735960954855,0.533673596095485,0.533673596095485,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.5336735960954855,0.533673596095485,0.5336735960954847,0.5336735960954847,0.533673596095485,0.533673596095485,0.5336735960954844,0.533673596095485,0.533673596095485,0.533673596095485,0.5336735960954847,0.5336735960954847,0.533673596095485,0.533673596095485,0.5336735960954844,0.533673596095485,0.533673596095485,0.5336735960954855,0.533673596095485,0.533673596095485,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.5336735960954855,0.5336735960954855,0.533673596095485,0.533673596095485,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.5336735960954847,0.5336735960954844,0.5336735960954844,0.5336735960954847,0.5336735960954847,0.5336735960954839,0.5336735960954847,0.5336735960954855,0.533673596095485,0.533673596095485,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.533673596095485,0.533673596095485,0.5336735960954855,0.5336735960954855,0.5336735960954851,0.5336735960954851,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.5336735960954855,0.5336735960954851,0.5336735960954847,0.5336735960954847,0.5336735960954851,0.5336735960954851,0.5336735960954844,0.5336735960954851,0.5336735960954851,0.5336735960954851,0.5336735960954847,0.5336735960954847,0.5336735960954851,0.5336735960954851,0.5336735960954844,0.5336735960954851,0.5336735960954851,0.5336735960954855,0.5336735960954851,0.5336735960954851,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.5336735960954855,0.5336735960954855,0.5336735960954851,0.5336735960954851,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.5336735960954847,0.5336735960954844,0.5336735960954844,0.5336735960954847,0.5336735960954847,0.5336735960954839,0.5336735960954847,0.5336735960954855,0.5336735960954851,0.5336735960954851,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.5336735960954851,0.5336735960954851,0.5336735960954855,0.5336735960954855,0.5336735960954851,0.5336735960954851,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.5336735960954855,0.5336735960954851,0.5336735960954847,0.5336735960954847,0.5336735960954851,0.5336735960954851,0.5336735960954844,0.5336735960954851,0.5336735960954851,0.5336735960954851,0.5336735960954847,0.5336735960954847,0.5336735960954851,0.5336735960954851,0.5336735960954844,0.5336735960954851,0.5336735960954851,0.5336735960954855,0.5336735960954851,0.5336735960954851,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.5336735960954855,0.5336735960954855,0.5336735960954851,0.5336735960954851,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.5336735960954847,0.5336735960954844,0.5336735960954844,0.5336735960954847,0.5336735960954847,0.5336735960954839,0.5336735960954847,0.5336735960954855,0.5336735960954851,0.5336735960954851,0.5336735960954855,0.5336735960954855,0.5336735960954847,0.5336735960954855,0.5336735960954851,0.5336735960954851,0.5336735960954855])
poro.setInfoOnComponent(0,"- [-]")
##
ts=[(-1,1,0.),(-1, 2,2.)]
fs=MEDFileFields()
sup=cm.buildUnstructured()[pfl0] ; sup.setName(cm.getName())
for name,arrs in [("ENERGIE RECUE",(nrj_0_1,nrj_0_1)),("ENTHALPIE",(h_0,h_1)),("PRESSION",(p_0,p_1)),("TEMPERATURE",(t_0,t_1))]:
    fmts0=MEDFileFieldMultiTS()
    for its,(dt,it,ft) in enumerate(ts):
        f1ts0=MEDFileField1TS()
        f=MEDCouplingFieldDouble(ON_CELLS) ; f.setName(name) ; f.setTime(ft,dt,it) ; f.setMesh(sup)
        f.setArray(arrs[its])
        f.checkConsistencyLight()
        f1ts0.setFieldProfile(f,mm,0,pfl0)
        fmts0.pushBackTimeStep(f1ts0)
        pass
    fs.pushField(fmts0)
    pass
#
fmts0=MEDFileFieldMultiTS()
f1ts0=MEDFileField1TS()
f=MEDCouplingFieldDouble(ON_CELLS) ; f.setName("POROSITE") ; f.setTime(0.,-1,0)
f.setArray(poro)
f1ts0.setFieldProfile(f,mm,0,pfl0)
fmts0.pushBackTimeStep(f1ts0)
fs.pushField(fmts0)
#
fmts0=MEDFileFieldMultiTS()
arrs=(vx_0,vx_1)
for its,(dt,it,ft) in enumerate(ts):
    f1ts0=MEDFileField1TS()
    f=MEDCouplingFieldDouble(ON_CELLS) ; f.setName("VITESSE X") ; f.setTime(ft,dt,it)
    f.setArray(arrs[its])
    f1ts0.setFieldProfile(f,mm,-1,pfl1)
    fmts0.pushBackTimeStep(f1ts0)
    pass
fs.pushField(fmts0)
#
fmts0=MEDFileFieldMultiTS()
arrs=(vy_0,vy_1)
for its,(dt,it,ft) in enumerate(ts):
    f1ts0=MEDFileField1TS()
    f=MEDCouplingFieldDouble(ON_CELLS) ; f.setName("VITESSE Y") ; f.setTime(ft,dt,it)
    f.setArray(arrs[its])
    f1ts0.setFieldProfile(f,mm,-1,pfl2)
    fmts0.pushBackTimeStep(f1ts0)
    pass
fs.pushField(fmts0)
#
fmts0=MEDFileFieldMultiTS()
arrs=(vz_0,vz_1)
for its,(dt,it,ft) in enumerate(ts):
    f1ts0=MEDFileField1TS()
    f=MEDCouplingFieldDouble(ON_CELLS) ; f.setName("VITESSE Z") ; f.setTime(ft,dt,it)
    f.setArray(arrs[its])
    f1ts0.setFieldProfile(f,mm,-1,pfl3)
    fmts0.pushBackTimeStep(f1ts0)
    pass
fs.pushField(fmts0)
fs.write(fname,0)
################### MED write is done -> Go to MEDReader
from paraview.simple import *

testMEDReader11_med = MEDReader( FileName=fname )

testMEDReader11_med.AllArrays = ['TS0/Maillage_THYC/ComSup0/ENERGIE RECUE@@][@@P0', 'TS0/Maillage_THYC/ComSup0/ENTHALPIE@@][@@P0', 'TS0/Maillage_THYC/ComSup0/PRESSION@@][@@P0', 'TS0/Maillage_THYC/ComSup0/TEMPERATURE@@][@@P0']

RenderView1 = GetRenderView()

DataRepresentation1 = Show()
DataRepresentation1.EdgeColor = [0.0, 0.0, 0.5000076295109483]
DataRepresentation1.SelectionCellFieldDataArrayName = 'ENERGIE RECUE'
DataRepresentation1.ScalarOpacityUnitDistance = 0.38412557692355614
DataRepresentation1.ExtractedBlockIndex = 1
DataRepresentation1.ScaleFactor = 0.16128

a1_ENTHALPIE_PVLookupTable = GetLookupTableForArray( "ENTHALPIE", 1, RGBPoints=[1278022.919558529, 0.23, 0.299, 0.754, 1278022.9209713081, 0.865, 0.865, 0.865, 1278022.9223840872, 0.706, 0.016, 0.15], VectorMode='Magnitude', NanColor=[0.25, 0.0, 0.0], ColorSpace='Diverging', ScalarRangeInitialized=1.0 )

a1_ENTHALPIE_PiecewiseFunction = CreatePiecewiseFunction( Points=[1278022.919558529, 0.0, 0.5, 0.0, 1278022.9223840872, 1.0, 0.5, 0.0] )

DataRepresentation1.Representation = 'Wireframe'
DataRepresentation1.ScalarOpacityFunction = a1_ENTHALPIE_PiecewiseFunction
DataRepresentation1.ColorArrayName = ('CELLS', 'ENTHALPIE')
DataRepresentation1.LookupTable = a1_ENTHALPIE_PVLookupTable

testMEDReader11_med = MEDReader( FileName=fname )

a1_ENTHALPIE_PVLookupTable.ScalarOpacityFunction = a1_ENTHALPIE_PiecewiseFunction

testMEDReader11_med.AllArrays = ['TS0/Maillage_THYC/ComSup1/VITESSE X@@][@@P0']

SetActiveSource(testMEDReader11_med)
DataRepresentation2 = Show()
DataRepresentation2.EdgeColor = [0.0, 0.0, 0.5000076295109483]
DataRepresentation2.SelectionCellFieldDataArrayName = 'VITESSE X'
DataRepresentation2.ScalarOpacityUnitDistance = 0.3674028970987523
DataRepresentation2.ExtractedBlockIndex = 1
DataRepresentation2.ScaleFactor = 0.16128

a1_VITESSEX_PVLookupTable = GetLookupTableForArray( "VITESSE X", 1, RGBPoints=[0.0, 0.23, 0.299, 0.754, 5e-17, 0.865, 0.865, 0.865, 1e-16, 0.706, 0.016, 0.15], VectorMode='Magnitude', NanColor=[0.25, 0.0, 0.0], ColorSpace='Diverging', ScalarRangeInitialized=1.0 )

a1_VITESSEX_PiecewiseFunction = CreatePiecewiseFunction( Points=[0.0, 0.0, 0.5, 0.0, 1e-16, 1.0, 0.5, 0.0] )

DataRepresentation2.ScalarOpacityFunction = a1_VITESSEX_PiecewiseFunction
DataRepresentation2.ColorArrayName = ('CELLS', 'VITESSE X')
DataRepresentation2.LookupTable = a1_VITESSEX_PVLookupTable

a1_VITESSEX_PVLookupTable.RGBPoints = [-0.04176214531137861, 0.23, 0.299, 0.754, 0.35689831830849095, 0.865, 0.865, 0.865, 0.7555587819283606, 0.706, 0.016, 0.15]
a1_VITESSEX_PVLookupTable.ScalarOpacityFunction = a1_VITESSEX_PiecewiseFunction

a1_VITESSEX_PiecewiseFunction.Points = [-0.04176214531137861, 0.0, 0.5, 0.0, 0.7555587819283606, 1.0, 0.5, 0.0]

RenderView1.CenterOfRotation = [2.4192, 2.4192, 4.32745]
RenderView1.CameraViewUp = [-0.09460871052363676, 0.6302516648802655, 0.7706049771502312]
RenderView1.CameraPosition = [4.325977740713708, -0.6239049541402536, 7.050401199739401]
RenderView1.CameraFocalPoint = [2.4191999999999996, 2.4191999999999996, 4.32745]
RenderView1.ViewTime = 2.0

RenderView1.ViewSize =[300,300]
Render()

# compare with baseline image
import os
import sys
try:
  baselineIndex = sys.argv.index('-B')+1
  baselinePath = sys.argv[baselineIndex]
except:
  print "Could not get baseline directory. Test failed."
  exit(1)
baseline_file = os.path.join(baselinePath, "testMEDReader11.png")
import vtk.test.Testing
vtk.test.Testing.VTK_TEMP_DIR = vtk.util.misc.vtkGetTempDir()
vtk.test.Testing.compareImage(GetActiveView().GetRenderWindow(), baseline_file,
                                                            threshold=25)
vtk.test.Testing.interact()
