# - Config file for the SalomeLIGHT package
# It defines the following variables. 
# Specific to the pacakge SalomeLIGHT itself:
#  SALOMELIGHT_ROOT_DIR_EXP - the root path of the installation providing this CMake file
#

###############################################################
# Copyright (C) 2013-2016  OPEN CASCADE
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
#

### Initialisation performed by CONFIGURE_PACKAGE_CONFIG_FILE:

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was SalomeLIGHTConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# Load the dependencies for the libraries of SalomeLIGHT 
# (contains definitions for IMPORTED targets). This is only 
# imported if we are not built as a subproject (in this case targets are already there)
IF(NOT TARGET LIGHT AND NOT SalomeLIGHT_BINARY_DIR)
  INCLUDE("${PACKAGE_PREFIX_DIR}/adm_local/cmake_files/SalomeLIGHTTargets.cmake")
ENDIF()   

# Package root dir:
SET_AND_CHECK(LIGHT_ROOT_DIR_EXP "${PACKAGE_PREFIX_DIR}")

# Include directories
SET_AND_CHECK(LIGHT_INCLUDE_DIRS "${LIGHT_ROOT_DIR_EXP}/include/salome")
SET(LIGHT_INCLUDE_DIRS "${LIGHT_INCLUDE_DIRS};P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/python-2.7.10/include;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtCore;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/.//mkspecs/win32-msvc2010;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtGui;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtWidgets;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtNetwork;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtXml;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtOpenGL;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtPrintSupport;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtHelp;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtTest;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtSql;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtSensors;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtPositioning;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtQuick;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtQml;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtMultimedia;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtMultimediaWidgets;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtWebChannel;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtUiTools;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/occt-7.1.0p1/inc;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/freetype-2.4.11/include;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/paraview-5.1.2-35c5231cb6/include/paraview-5.1;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/freetype-2.4.11//include;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/zlib-1.2.5//include;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/gl2ps-1.3.9-svn-20160620//include;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/python-2.7.10//include")
SET(LIGHT_DEFINITIONS "-DSINGLE_DESKTOP;-DWITH_SALOMEDS_OBSERVER")

# Package specific environment variables
SET(SalomeLIGHT_EXTRA_ENV LD_LIBRARY_PATH;PATH;PYTHONPATH;PV_PLUGIN_PATH)
SET(SalomeLIGHT_EXTRA_ENV_LD_LIBRARY_PATH P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/LIBBATCH/RELEASE/LIBBATCH_INSTALL/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/python-2.7.10/libs;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/pthreads-2.9.1/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/libxml2-2.9.0/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/hdf5-1.8.14/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/boost-1.52.0/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/omniorb-4.1.6/lib/x86_win32;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/cppunit-1.12.1/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/graphviz-2.38.0/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/KERNEL/RELEASE/KERNEL_INSTALL/lib/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/sip-4.18/lib/python2.7/site-packages;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/occt-7.1.0p1/win64/vc10/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/pyqt-5.6.0/PyQt5;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/paraview-5.1.2-35c5231cb6/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/freetype-2.4.11/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/zlib-1.2.5/dll;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/gl2ps-1.3.9-svn-20160620/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/paraview-5.1.2-35c5231cb6/lib/paraview-5.1;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qwt-6.1.2/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/GUI/RELEASE/GUI_INSTALL/lib/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/GUI/RELEASE/GUI_INSTALL/lib/paraview;${PACKAGE_PREFIX_DIR}/lib/salome)
SET(SalomeLIGHT_EXTRA_ENV_PATH P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/python-2.7.10;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/swig-2.0.9/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/doxygen-1.8.3.1/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/graphviz-2.38.0/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/sphinx-1.3.1/Scripts;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/sip-4.18/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/pyqt-5.6.0/bin)
SET(SalomeLIGHT_EXTRA_ENV_PYTHONPATH P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/python-2.7.10/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/omniorb-4.1.6/lib/x86_win32;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/omniorb-4.1.6/lib/python;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/sphinx-1.3.1/lib/site-packages;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/KERNEL/RELEASE/KERNEL_INSTALL/bin/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/KERNEL/RELEASE/KERNEL_INSTALL/lib/python2.7/site-packages/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/sip-4.18/lib/python2.7/site-packages;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/pyqt-5.6.0/PyQt5;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/paraview-5.1.2-35c5231cb6/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/freetype-2.4.11/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/zlib-1.2.5/dll;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/gl2ps-1.3.9-svn-20160620/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/python-2.7.10/libs;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/paraview-5.1.2-35c5231cb6/lib/paraview-5.1;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/GUI/RELEASE/GUI_INSTALL/bin/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/GUI/RELEASE/GUI_INSTALL/lib/python2.7/site-packages/salome;${PACKAGE_PREFIX_DIR}/bin/salome)
SET(SalomeLIGHT_EXTRA_ENV_PV_PLUGIN_PATH P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/paraview-5.1.2-35c5231cb6/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/freetype-2.4.11/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/zlib-1.2.5/dll;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/gl2ps-1.3.9-svn-20160620/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/python-2.7.10/libs;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/paraview-5.1.2-35c5231cb6/lib/paraview-5.1)

#### Now the specificities

# Options exported by the package:
SET(SALOME_LIGHT_BUILD_TESTS ON)
#SET(SALOME_LIGHT_BUILD_DOC   )

# Level 1 prerequisites:
SET_AND_CHECK(GUI_ROOT_DIR_EXP "P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/GUI/RELEASE/GUI_INSTALL")

# For all prerequisites, load the corresponding targets if the package was used
# in CONFIG mode. This ensures dependent projects link correctly
# without having to set LD_LIBRARY_PATH:
SET(_PREREQ_SalomeLIGHT )
SET(_PREREQ_SalomeLIGHT_CONFIG_DIR )
SET(_PREREQ_SalomeLIGHT_COMPONENTS "")
LIST(LENGTH _PREREQ_SalomeLIGHT_CONFIG_DIR _list_len_SalomeLIGHT)
IF(NOT _list_len_SalomeLIGHT EQUAL 0)
  # Another CMake stupidity - FOREACH(... RANGE r) generates r+1 numbers ...
  MATH(EXPR _range_SalomeLIGHT "${_list_len_SalomeLIGHT}-1")
  FOREACH(_p_SalomeLIGHT RANGE ${_range_SalomeLIGHT})
    LIST(GET _PREREQ_SalomeLIGHT            ${_p_SalomeLIGHT} _pkg_SalomeLIGHT    )
    LIST(GET _PREREQ_SalomeLIGHT_CONFIG_DIR ${_p_SalomeLIGHT} _pkg_dir_SalomeLIGHT)
    LIST(GET _PREREQ_SalomeLIGHT_COMPONENTS ${_p_SalomeLIGHT} _pkg_compo_SalomeLIGHT)
    IF(NOT OMIT_DETECT_PACKAGE_${_pkg_SalomeLIGHT})
      MESSAGE(STATUS "===> Reloading targets from ${_pkg_SalomeLIGHT} ...")
      IF(NOT _pkg_compo_SalomeLIGHT)
        FIND_PACKAGE(${_pkg_SalomeLIGHT} REQUIRED NO_MODULE
            PATHS "${_pkg_dir_SalomeLIGHT}"
            NO_DEFAULT_PATH)
      ELSE()
        STRING(REPLACE "," ";" _compo_lst_SalomeLIGHT "${_pkg_compo_SalomeLIGHT}")
        MESSAGE(STATUS "===> (components: ${_pkg_compo_SalomeLIGHT})")
        FIND_PACKAGE(${_pkg_SalomeLIGHT} REQUIRED NO_MODULE
            COMPONENTS ${_compo_lst_SalomeLIGHT}
            PATHS "${_pkg_dir_SalomeLIGHT}"
            NO_DEFAULT_PATH)
      ENDIF()
    ENDIF()
  ENDFOREACH()
ENDIF()

# Installation directories
SET(SALOME_INSTALL_BINS "bin/salome")
SET(SALOME_INSTALL_LIBS "lib/salome")
SET(SALOME_INSTALL_HEADERS "include/salome")
SET(SALOME_INSTALL_SCRIPT_SCRIPTS "bin/salome")
SET(SALOME_INSTALL_SCRIPT_DATA "bin/salome")
SET(SALOME_INSTALL_SCRIPT_PYTHON "bin/salome")
SET(SALOME_INSTALL_APPLISKEL_SCRIPTS "bin/salome/appliskel")
SET(SALOME_INSTALL_APPLISKEL_PYTHON "bin/salome/appliskel") 
SET(SALOME_INSTALL_CMAKE_LOCAL "adm_local/cmake_files")
SET(SALOME_INSTALL_PYTHON "lib/python2.7/site-packages/salome")
SET(SALOME_INSTALL_PYTHON_SHARED "lib/python2.7/site-packages/salome/shared_modules")
SET(SALOME_INSTALL_RES "share/salome/resources")
SET(SALOME_INSTALL_DOC "share/doc/salome")
SET(SALOME_INSTALL_AMCONFIG_LOCAL "adm_local/unix")

# Include GUI targets if they were not already loaded:
IF(NOT (TARGET Event)) 
  INCLUDE("${GUI_ROOT_DIR_EXP}/${SALOME_INSTALL_CMAKE}/SalomeGUITargets.cmake")
ENDIF()

# Exposed LIGHT targets:
SET(LIGHT_LIGHT LIGHT)
