// Copyright (C) 2007-2015  CEA/DEN, EDF R&D, OPEN CASCADE
//
// Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
// CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
// See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
/*
 * FactBatchManager.hxx : 
 *
 * Auteur : Ivan DUTKA-MALEN - EDF R&D
 * Date   : Septembre 2004
 * Projet : SALOME 2
 *
 */

#ifndef _FACTBATCHMANAGER_H_
#define _FACTBATCHMANAGER_H_

#include <string>

#include "Defines.hxx"
#include "CommunicationProtocol.hxx"

namespace Batch {
  
  class BatchManager;

  class BATCH_EXPORT FactBatchManager
  {
  public:
    // Constructeur et destructeur
    FactBatchManager(const std::string & type);
    virtual ~FactBatchManager();

    virtual Batch::BatchManager * operator() (const char * hostname,
                                              const char * username = "",
                                              CommunicationProtocolType protocolType = SSH,
                                              const char * mpi = "nompi") const = 0;
    const std::string & getType() const;
    std::string __repr__() const;

  protected:
    std::string type;

  };

}

#endif
