#!/bin/bash
# Copyright (C) 2009-2016  CEA/DEN, EDF R&D
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
#

usage()
{
        echo "Start JobManager GUI outside SALOME GUI"
        echo ""
        echo "Usage: $(basename $0) -a APPLIPATH [ -h ]"
        echo ""
        echo "  -a APPLIPATH       : Application Path where SALOME is launched "
        echo "  -h                 : Print this message"
        echo ""
}

while getopts 'a:h' OPTION
  do
    case $OPTION in
      a)APPLIPATH="$OPTARG" ;;
      h|?) usage
          exit 1 ;;
    esac
  done

if test "x${APPLIPATH}" == "x"; then
  usage
  exit 1
fi

JOBMANAGER_INSTALL_DIR=/bin

${APPLIPATH}/runSession ${JOBMANAGER_INSTALL_DIR}/jobmanager_gui
