# -*- coding: utf-8 -*-

# This test is a known failure for MeshGems <= 2.4-5 (but must not crash Salome)

import sys
import salome

salome.salome_init()
theStudy = salome.myStudy

###
### GEOM component
###

import GEOM
from salome.geom import geomBuilder
import math
import SALOMEDS


geompy = geomBuilder.New(theStudy)

O = geompy.MakeVertex(0, 0, 0)
OX = geompy.MakeVectorDXDYDZ(1, 0, 0)
OY = geompy.MakeVectorDXDYDZ(0, 1, 0)
OZ = geompy.MakeVectorDXDYDZ(0, 0, 1)
Cylinder_1 = geompy.MakeCylinderRH(0.5, 5)
Cylinder_2 = geompy.MakeCylinderRH(0.3, 3)
Rotation_1 = geompy.MakeRotation(Cylinder_2, OY, -90*math.pi/180.0)
Translation_1 = geompy.MakeTranslation(Rotation_1, 0, 0, 1.5)
piquage = geompy.MakeFuseList([Cylinder_1, Translation_1], True, True)
[Outlet] = geompy.SubShapes(piquage, [15])
[Inlet_z,Inlet_x] = geompy.SubShapes(piquage, [3, 22])
[corner] = geompy.SubShapes(piquage, [14])
geomObj_1 = geompy.MakeVertex(0, 0, 0)
geomObj_2 = geompy.MakeVectorDXDYDZ(1, 0, 0)
geomObj_3 = geompy.MakeVectorDXDYDZ(0, 1, 0)
geomObj_4 = geompy.MakeVectorDXDYDZ(0, 0, 1)
Wall = geompy.CreateGroup(piquage, geompy.ShapeType["FACE"])
geompy.UnionIDs(Wall, [7, 17])
geompy.addToStudy( O, 'O' )
geompy.addToStudy( OX, 'OX' )
geompy.addToStudy( OY, 'OY' )
geompy.addToStudy( OZ, 'OZ' )
geompy.addToStudy( Cylinder_1, 'Cylinder_1' )
geompy.addToStudy( Cylinder_2, 'Cylinder_2' )
geompy.addToStudy( Rotation_1, 'Rotation_1' )
geompy.addToStudy( Translation_1, 'Translation_1' )
geompy.addToStudy( piquage, 'piquage' )
geompy.addToStudyInFather( piquage, Inlet_x, 'Inlet_x' )
geompy.addToStudyInFather( piquage, Outlet, 'Outlet' )
geompy.addToStudyInFather( piquage, Wall, 'Wall' )
geompy.addToStudyInFather( piquage, Inlet_z, 'Inlet_z' )
geompy.addToStudyInFather( piquage, corner, 'corner' )

geom_groups = [Inlet_x, Inlet_z, Outlet, Wall]
d_geom_groups = {}

###
### SMESH component
###

import  SMESH, SALOMEDS
from salome.smesh import smeshBuilder

from salome.StdMeshers import StdMeshersBuilder
from salome.HYBRIDPlugin import HYBRIDPluginBuilder

smesh = smeshBuilder.New(theStudy)

# Viscous layers with imprinting (hexa core)
# ==========================================

Mesh_4 = smesh.Mesh(piquage, "Mesh_with_imprinting_hexa_core")

NETGEN_2D_1_1 = Mesh_4.Triangle(algo=smeshBuilder.NETGEN_1D2D)
NETGEN_2D_Parameters = NETGEN_2D_1_1.Parameters()

NETGEN_2D_Parameters.SetMinSize( 0.01 )
NETGEN_2D_Parameters.SetLocalSizeOnShape(corner, 0.01)
NETGEN_2D_Parameters.SetFineness( 5 )
NETGEN_2D_Parameters.SetGrowthRate( 0.1 )
NETGEN_2D_Parameters.SetNbSegPerEdge( 2 )
NETGEN_2D_Parameters.SetNbSegPerRadius( 3 )

MG_Hybrid_4 = Mesh_4.Tetrahedron(algo=smeshBuilder.HYBRID)
MG_Hybrid_Parameters_4 = MG_Hybrid_4.Parameters()
MG_Hybrid_Parameters_4.SetLayersOnAllWrap( 0 )
MG_Hybrid_Parameters_4.SetElementGeneration( HYBRIDPluginBuilder.Generation_Hexa_Dominant )
MG_Hybrid_Parameters_4.SetHeightFirstLayer( 0.01 )
MG_Hybrid_Parameters_4.SetBoundaryLayersProgression( 1.1 )
MG_Hybrid_Parameters_4.SetNbOfBoundaryLayers( 3 )
MG_Hybrid_Parameters_4.SetFacesWithLayers( [ 7, 17 ] )
MG_Hybrid_Parameters_4.SetFacesWithImprinting( [ 22, 15, 3 ] )

isDone = Mesh_4.Compute()

if not isDone:
  raise Exception("Error when computing Mesh_with_imprinting_hexa_core")

assert Mesh_4.NbQuadrangles() > 0

d_groups_4 = {}
d_geom_groups = {}

for geom_group in geom_groups:
  name = geom_group.GetName()
  gr = Mesh_4.Group(geom_group)
  d_groups_4[name] = gr
  d_geom_groups[name] = geom_group

# Compare whole mesh volume
mesh_4_volume = Mesh_4.GetVolume()
shape_volume = geompy.BasicProperties(piquage)[2]
volume_error_4 = abs(shape_volume-mesh_4_volume)/shape_volume

assert volume_error_4 < 0.015

# Check viscous layers with imprinting
faces_imprinted = ["Inlet_x", "Inlet_z", "Outlet"]

for name in faces_imprinted:
  gr_4 = d_groups_4[name]
  #assert gr_1.Size() > 0
  assert gr_4.Size() > 0
  # Nb of quadrangles is in 7th index of mesh info
  assert gr_4.GetMeshInfo()[7] > 0

  # Compare mesh group and geom group
  geom_area = geompy.BasicProperties(d_geom_groups[name])[1]
  area_error_1 = abs(geom_area-smesh.GetArea(gr_4))/geom_area
  assert area_error_1 < 0.025


if salome.sg.hasDesktop():
  salome.sg.updateObjBrowser(1)
