# -*- coding: utf-8 -*-

import sys
import salome

salome.salome_init()
theStudy = salome.myStudy

###
### GEOM component
###

import GEOM
from salome.geom import geomBuilder
import math
import SALOMEDS


geompy = geomBuilder.New(theStudy)

O = geompy.MakeVertex(0, 0, 0)
OX = geompy.MakeVectorDXDYDZ(1, 0, 0)
OY = geompy.MakeVectorDXDYDZ(0, 1, 0)
OZ = geompy.MakeVectorDXDYDZ(0, 0, 1)
Cylinder_1 = geompy.MakeCylinderRH(0.5, 5)
Cylinder_2 = geompy.MakeCylinderRH(0.3, 3)
Rotation_1 = geompy.MakeRotation(Cylinder_2, OY, -90*math.pi/180.0)
Translation_1 = geompy.MakeTranslation(Rotation_1, 0, 0, 1.5)
piquage = geompy.MakeFuseList([Cylinder_1, Translation_1], True, True)
[Outlet] = geompy.SubShapes(piquage, [15])
[Inlet_z,Inlet_x] = geompy.SubShapes(piquage, [3, 22])
[corner] = geompy.SubShapes(piquage, [14])
geomObj_1 = geompy.MakeVertex(0, 0, 0)
geomObj_2 = geompy.MakeVectorDXDYDZ(1, 0, 0)
geomObj_3 = geompy.MakeVectorDXDYDZ(0, 1, 0)
geomObj_4 = geompy.MakeVectorDXDYDZ(0, 0, 1)
Wall = geompy.CreateGroup(piquage, geompy.ShapeType["FACE"])
geompy.UnionIDs(Wall, [7, 17])
geompy.addToStudy( O, 'O' )
geompy.addToStudy( OX, 'OX' )
geompy.addToStudy( OY, 'OY' )
geompy.addToStudy( OZ, 'OZ' )
geompy.addToStudy( Cylinder_1, 'Cylinder_1' )
geompy.addToStudy( Cylinder_2, 'Cylinder_2' )
geompy.addToStudy( Rotation_1, 'Rotation_1' )
geompy.addToStudy( Translation_1, 'Translation_1' )
geompy.addToStudy( piquage, 'piquage' )
geompy.addToStudyInFather( piquage, Inlet_x, 'Inlet_x' )
geompy.addToStudyInFather( piquage, Outlet, 'Outlet' )
geompy.addToStudyInFather( piquage, Wall, 'Wall' )
geompy.addToStudyInFather( piquage, Inlet_z, 'Inlet_z' )
geompy.addToStudyInFather( piquage, corner, 'corner' )

geom_groups = [Inlet_x, Inlet_z, Outlet, Wall]
d_geom_groups = {}

###
### SMESH component
###

import  SMESH, SALOMEDS
from salome.smesh import smeshBuilder

from salome.StdMeshers import StdMeshersBuilder
from salome.HYBRIDPlugin import HYBRIDPluginBuilder

smesh = smeshBuilder.New(theStudy)


# Viscous layers without imprinting
# =================================

Mesh_1 = smesh.Mesh(piquage, "Mesh_without_imprinting")
NETGEN_2D = Mesh_1.Triangle(algo=smeshBuilder.NETGEN_1D2D)
NETGEN_2D_Parameters = NETGEN_2D.Parameters()

NETGEN_2D_Parameters.SetMinSize( 0.01 )
NETGEN_2D_Parameters.SetLocalSizeOnShape(corner, 0.01)
NETGEN_2D_Parameters.SetFineness( 5 )
NETGEN_2D_Parameters.SetGrowthRate( 0.1 )
NETGEN_2D_Parameters.SetNbSegPerEdge( 2 )
NETGEN_2D_Parameters.SetNbSegPerRadius( 3 )

MG_Hybrid = Mesh_1.Tetrahedron(algo=smeshBuilder.HYBRID)
MG_Hybrid_Parameters_1 = MG_Hybrid.Parameters()
MG_Hybrid_Parameters_1.SetLayersOnAllWrap( 0 )
MG_Hybrid_Parameters_1.SetElementGeneration( HYBRIDPluginBuilder.Generation_Tetra_Dominant )
MG_Hybrid_Parameters_1.SetHeightFirstLayer( 0.01 )
MG_Hybrid_Parameters_1.SetBoundaryLayersProgression( 1.1 )
MG_Hybrid_Parameters_1.SetNbOfBoundaryLayers( 3 )
MG_Hybrid_Parameters_1.SetFacesWithLayers( [ 7, 17 ] )


isDone = Mesh_1.Compute()

if not isDone:
  raise Exception("Error when computing Mesh_without_imprinting")

d_groups_1 = {}

for geom_group in geom_groups:
  name = geom_group.GetName()
  gr = Mesh_1.Group(geom_group)
  d_groups_1[name] = gr
  d_geom_groups[name] = geom_group

assert Mesh_1.NbQuadrangles() == 0

shape_volume = geompy.BasicProperties(piquage)[2]

# Compare whole mesh volume
volume_error_1 = abs(shape_volume-Mesh_1.GetVolume())/shape_volume

assert volume_error_1 < 0.015

# Viscous layers with imprinting
# ==============================

Mesh_2 = smesh.Mesh(piquage, "Mesh_with_imprinting")

NETGEN_2D_1_1 = Mesh_2.Triangle(algo=smeshBuilder.NETGEN_1D2D)
status = Mesh_2.AddHypothesis(NETGEN_2D_Parameters)

MG_Hybrid_2 = Mesh_2.Tetrahedron(algo=smeshBuilder.HYBRID)
MG_Hybrid_Parameters_2 = MG_Hybrid_2.Parameters()
MG_Hybrid_Parameters_2.SetLayersOnAllWrap( 0 )
MG_Hybrid_Parameters_2.SetElementGeneration( HYBRIDPluginBuilder.Generation_Tetra_Dominant )
MG_Hybrid_Parameters_2.SetHeightFirstLayer( 0.01 )
MG_Hybrid_Parameters_2.SetBoundaryLayersProgression( 1.1 )
MG_Hybrid_Parameters_2.SetNbOfBoundaryLayers( 3 )
MG_Hybrid_Parameters_2.SetFacesWithLayers( [ 7, 17 ] )
MG_Hybrid_Parameters_2.SetFacesWithImprinting( [ 22, 15, 3 ] )

isDone = Mesh_2.Compute()

if not isDone:
  raise Exception("Error when computing Mesh_with_imprinting")

assert Mesh_2.NbQuadrangles() > 0

d_groups_2 = {}

for geom_group in geom_groups:
  name = geom_group.GetName()
  gr = Mesh_2.Group(geom_group)
  d_groups_2[name] = gr

faces_imprinted = ["Inlet_x", "Inlet_z", "Outlet"]

# Check viscous layers with imprinting
for name in faces_imprinted:
  geom_area = geompy.BasicProperties(d_geom_groups[name])[1]
  gr_1 = d_groups_1[name]
  gr_2 = d_groups_2[name]
  #assert gr_1.Size() > 0
  assert gr_2.Size() > 0
  # Nb of quadrangles is in 7th index of mesh info
  assert gr_2.GetMeshInfo()[7] > 0

  # Compare mesh group and geom group
  area_error_1 = abs(geom_area-smesh.GetArea(gr_2))/geom_area
  assert area_error_1 < 0.025
  # Compare mesh group with imprinting and mesh group without imprinting
  area_error_2 = abs(smesh.GetArea(gr_1)-smesh.GetArea(gr_2))/smesh.GetArea(gr_1)
  assert area_error_2 < 1e-10

# Compare whole mesh volume
mesh_2_volume = Mesh_2.GetVolume()
volume_error_2 = abs(shape_volume-mesh_2_volume)/shape_volume

assert volume_error_2 < 0.015

# Viscous layers with imprinting set by groups
# ============================================

Mesh_3 = smesh.Mesh(piquage, "Mesh_with_imprinting_set_by_groups")

NETGEN_2D_1_1 = Mesh_3.Triangle(algo=smeshBuilder.NETGEN_1D2D)
status = Mesh_3.AddHypothesis(NETGEN_2D_Parameters)

MG_Hybrid_3 = Mesh_3.Tetrahedron(algo=smeshBuilder.HYBRID)
MG_Hybrid_Parameters_3 = MG_Hybrid_3.Parameters()
MG_Hybrid_Parameters_3.SetLayersOnAllWrap( 0 )
MG_Hybrid_Parameters_3.SetElementGeneration( HYBRIDPluginBuilder.Generation_Tetra_Dominant )
MG_Hybrid_Parameters_3.SetHeightFirstLayer( 0.01 )
MG_Hybrid_Parameters_3.SetBoundaryLayersProgression( 1.1 )
MG_Hybrid_Parameters_3.SetNbOfBoundaryLayers( 3 )
MG_Hybrid_3.SetFacesWithLayers( Wall )
MG_Hybrid_3.SetFacesWithImprinting( [ Inlet_x, Inlet_z, Outlet ] )

isDone = Mesh_3.Compute()

if not isDone:
  raise Exception("Error when computing Mesh_with_imprinting_set_by_groups")

d_groups_3 = {}

for geom_group in geom_groups:
  name = geom_group.GetName()
  gr = Mesh_3.Group(geom_group)
  d_groups_3[name] = gr

# Compare whole mesh volume
mesh_3_volume = Mesh_3.GetVolume()
volume_error_3 = abs(mesh_2_volume-mesh_3_volume)/mesh_2_volume

assert abs(mesh_3_volume-mesh_2_volume)/mesh_2_volume < 1e-10

# Check viscous layers with imprinting
for name in faces_imprinted:
  gr_2 = d_groups_2[name]
  gr_3 = d_groups_3[name]
  assert gr_3.Size() > 0
  # Nb of quadrangles is in 7th index of mesh info
  assert gr_2.GetMeshInfo()[7] == gr_3.GetMeshInfo()[7]

  # Compare mesh group with imprinting set by ids and mesh group with imprinting set by geom group
  area_error_3 = abs(smesh.GetArea(gr_2)-smesh.GetArea(gr_3))/smesh.GetArea(gr_2)
  assert area_error_3 < 1e-10

if salome.sg.hasDesktop():
  salome.sg.updateObjBrowser(1)
