# -*- coding: utf-8 -*-


import sys
import salome

salome.salome_init()
theStudy = salome.myStudy

###
### GEOM component
###

import GEOM
from salome.geom import geomBuilder
import math
import SALOMEDS


geompy = geomBuilder.New(theStudy)

O = geompy.MakeVertex(0, 0, 0)
OX = geompy.MakeVectorDXDYDZ(1, 0, 0)
OY = geompy.MakeVectorDXDYDZ(0, 1, 0)
OZ = geompy.MakeVectorDXDYDZ(0, 0, 1)
Cylinder_1 = geompy.MakeCylinderRH(100, 300)
geompy.addToStudy( O, 'O' )
geompy.addToStudy( OX, 'OX' )
geompy.addToStudy( OY, 'OY' )
geompy.addToStudy( OZ, 'OZ' )
geompy.addToStudy( Cylinder_1, 'Cylinder_1' )

###
### SMESH component
###

import  SMESH, SALOMEDS
from salome.smesh import smeshBuilder

from salome.HYBRIDPlugin import HYBRIDPluginBuilder

smesh = smeshBuilder.New(theStudy)

# Hybrid mesh with hexa dominant core
# ===================================

Mesh_1 = smesh.Mesh(Cylinder_1)

MG_CADSurf = Mesh_1.Triangle(algo=smeshBuilder.MG_CADSurf)

MG_Hybrid = Mesh_1.Tetrahedron(algo=smeshBuilder.HYBRID)
MG_Hybrid_Parameters_1 = MG_Hybrid.Parameters()
MG_Hybrid_Parameters_1.SetElementGeneration( HYBRIDPluginBuilder.Generation_Hexa_Dominant )
MG_Hybrid_Parameters_1.SetHeightFirstLayer( 1 )
MG_Hybrid_Parameters_1.SetNbOfBoundaryLayers( 3 )

isDone = Mesh_1.Compute()

nb_hexas_1 = Mesh_1.NbHexas()

# check that hexaedra have been genereted
assert nb_hexas_1 > 0

# Hybrid mesh with cartesian core
# ===============================

Mesh_2 = smesh.Mesh(Cylinder_1)

MG_CADSurf_1 = Mesh_2.Triangle(algo=smeshBuilder.MG_CADSurf)

MG_Hybrid_1 = Mesh_2.Tetrahedron(algo=smeshBuilder.HYBRID)
MG_Hybrid_Parameters_2 = MG_Hybrid_1.Parameters()
MG_Hybrid_Parameters_2.SetElementGeneration( HYBRIDPluginBuilder.Generation_Cartesian_Core )
MG_Hybrid_Parameters_2.SetHeightFirstLayer( 1 )
MG_Hybrid_Parameters_2.SetNbOfBoundaryLayers( 3 )

isDone = Mesh_2.Compute()

nb_hexas_2 = Mesh_2.NbHexas()

# check that hexaedra have been genereted
assert nb_hexas_2 > 0


# Hybrid mesh with cartesian core with fine core elements size
# ============================================================

Mesh_3 = smesh.Mesh(Cylinder_1)

MG_CADSurf_1 = Mesh_3.Triangle(algo=smeshBuilder.MG_CADSurf)

MG_Hybrid_1 = Mesh_3.Tetrahedron(algo=smeshBuilder.HYBRID)
MG_Hybrid_Parameters_3 = MG_Hybrid_1.Parameters()
MG_Hybrid_Parameters_3.SetElementGeneration( HYBRIDPluginBuilder.Generation_Cartesian_Core )
MG_Hybrid_Parameters_3.SetHeightFirstLayer( 1 )
MG_Hybrid_Parameters_3.SetNbOfBoundaryLayers( 3 )
MG_Hybrid_Parameters_3.SetCoreSize( 10 )

isDone = Mesh_3.Compute()

nb_hexas_3 = Mesh_3.NbHexas()

# check that more hexaedra have been genereted
assert nb_hexas_3 > nb_hexas_2

if salome.sg.hasDesktop():
  salome.sg.updateObjBrowser(True)
