# Copyright (C) 2013-2016  CEA/DEN, EDF R&D
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
#

# - Config file for the SalomeHexoticPLUGIN package
# It defines the following variables. 
# Specific to the pacakge SalomeHexoticPLUGIN itself:
#  SALOMEHEXOTICPLUGIN_ROOT_DIR_EXP - the root path of the installation providing this CMake file
#

### Initialisation performed by CONFIGURE_PACKAGE_CONFIG_FILE:

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was SalomeHexoticPLUGINConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# Load the dependencies for the libraries of SalomeHexoticPLUGIN 
# (contains definitions for IMPORTED targets). This is only 
# imported if we are not built as a subproject (in this case targets are already there)
IF(NOT TARGET HexoticEngine AND NOT SalomeHexoticPLUGIN_BINARY_DIR)
  INCLUDE("${PACKAGE_PREFIX_DIR}/adm_local/cmake_files/SalomeHexoticPLUGINTargets.cmake")
ENDIF()

# Package root dir:
SET_AND_CHECK(HexoticPLUGIN_ROOT_DIR_EXP "${PACKAGE_PREFIX_DIR}")

# Include directories
SET_AND_CHECK(HexoticPLUGIN_INCLUDE_DIRS "${HexoticPLUGIN_ROOT_DIR_EXP}/include/salome")
SET(HexoticPLUGIN_INCLUDE_DIRS "${HexoticPLUGIN_INCLUDE_DIRS};P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/python-2.7.10/include;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/boost-1.52.0/include/boost-1_52;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/omniorb-4.1.6/include;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtCore;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/.//mkspecs/win32-msvc2010;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtGui;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtWidgets;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtNetwork;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtXml;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtOpenGL;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtPrintSupport;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtHelp;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtTest;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtSql;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtSensors;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtPositioning;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtQuick;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtQml;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtMultimedia;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtMultimediaWidgets;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtWebChannel;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/include/QtUiTools;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/occt-7.1.0p1/inc;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/freetype-2.4.11/include;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/paraview-5.1.2-35c5231cb6/include/paraview-5.1;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/freetype-2.4.11//include;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/zlib-1.2.5//include;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/gl2ps-1.3.9-svn-20160620//include;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/python-2.7.10//include")
SET(HexoticPLUGIN_DEFINITIONS "-DSINGLE_DESKTOP;-DWITH_SALOMEDS_OBSERVER;-DWITH_OPENCV;-DWITH_VTK")

# Package specific environment variables
SET(SalomeHexoticPLUGIN_EXTRA_ENV LD_LIBRARY_PATH;PATH;PYTHONPATH;PV_PLUGIN_PATH)
SET(SalomeHexoticPLUGIN_EXTRA_ENV_LD_LIBRARY_PATH P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/LIBBATCH/RELEASE/LIBBATCH_INSTALL/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/python-2.7.10/libs;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/pthreads-2.9.1/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/libxml2-2.9.0/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/hdf5-1.8.14/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/boost-1.52.0/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/omniorb-4.1.6/lib/x86_win32;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/cppunit-1.12.1/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/graphviz-2.38.0/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/KERNEL/RELEASE/KERNEL_INSTALL/lib/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/sip-4.18/lib/python2.7/site-packages;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/occt-7.1.0p1/win64/vc10/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qt-5.6.1/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/pyqt-5.6.0/PyQt5;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/paraview-5.1.2-35c5231cb6/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/freetype-2.4.11/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/zlib-1.2.5/dll;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/gl2ps-1.3.9-svn-20160620/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/paraview-5.1.2-35c5231cb6/lib/paraview-5.1;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/qwt-6.1.2/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/GUI/RELEASE/GUI_INSTALL/lib/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/GUI/RELEASE/GUI_INSTALL/lib/paraview;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/opencv-2.4.6.1/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/GEOM/RELEASE/GEOM_INSTALL/lib/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/cgnslib-3.1.3/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/SMESH/RELEASE/SMESH_INSTALL/lib/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/meshgems-2.4-5/Products/lib/Win7_64_VC10;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/BLSURFPLUGIN/RELEASE/BLSURFPLUGIN_INSTALL/lib/salome;${PACKAGE_PREFIX_DIR}/lib/salome)
SET(SalomeHexoticPLUGIN_EXTRA_ENV_PATH P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/python-2.7.10;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/swig-2.0.9/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/doxygen-1.8.3.1/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/graphviz-2.38.0/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/sphinx-1.3.1/Scripts;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/sip-4.18/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/pyqt-5.6.0/bin)
SET(SalomeHexoticPLUGIN_EXTRA_ENV_PYTHONPATH P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/python-2.7.10/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/omniorb-4.1.6/lib/x86_win32;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/omniorb-4.1.6/lib/python;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/sphinx-1.3.1/lib/site-packages;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/KERNEL/RELEASE/KERNEL_INSTALL/bin/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/KERNEL/RELEASE/KERNEL_INSTALL/lib/python2.7/site-packages/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/sip-4.18/lib/python2.7/site-packages;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/pyqt-5.6.0/PyQt5;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/paraview-5.1.2-35c5231cb6/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/freetype-2.4.11/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/zlib-1.2.5/dll;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/gl2ps-1.3.9-svn-20160620/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/python-2.7.10/libs;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/paraview-5.1.2-35c5231cb6/lib/paraview-5.1;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/GUI/RELEASE/GUI_INSTALL/bin/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/GUI/RELEASE/GUI_INSTALL/lib/python2.7/site-packages/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/GEOM/RELEASE/GEOM_INSTALL/bin/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/GEOM/RELEASE/GEOM_INSTALL/lib/python2.7/site-packages/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/GEOM/RELEASE/GEOM_INSTALL/lib/python2.7/site-packages/salome/shared_modules;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/SMESH/RELEASE/SMESH_INSTALL/bin/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/SMESH/RELEASE/SMESH_INSTALL/lib/python2.7/site-packages/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/SMESH/RELEASE/SMESH_INSTALL/lib/python2.7/site-packages/salome/shared_modules;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/BLSURFPLUGIN/RELEASE/BLSURFPLUGIN_INSTALL/bin/salome;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/MODULES/BLSURFPLUGIN/RELEASE/BLSURFPLUGIN_INSTALL/lib/python2.7/site-packages/salome;${PACKAGE_PREFIX_DIR}/bin/salome;${PACKAGE_PREFIX_DIR}/lib/python2.7/site-packages/salome)
SET(SalomeHexoticPLUGIN_EXTRA_ENV_PV_PLUGIN_PATH P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/paraview-5.1.2-35c5231cb6/bin;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/freetype-2.4.11/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/zlib-1.2.5/dll;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/gl2ps-1.3.9-svn-20160620/lib;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/python-2.7.10/libs;P:/salome meca-windows/SALOME-8.3.0-WIN64 WIN64 meca-windows/SALOME-8.3.0-WIN64 Windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64 meca-windows/SALOME-8.3.0-WIN64/PRODUCTS/paraview-5.1.2-35c5231cb6/lib/paraview-5.1)

#### Now the specificities

# Options exported by the package:
SET(SALOME_HexoticPLUGIN_BUILD_TESTS ON)
SET(SALOME_HexoticPLUGIN_BUILD_DOC   ON)

# Advanced options
SET(SALOME_HexoticPLUGIN_BUILD_GUI ON)
SET(SALOME_HEXOTICPLUGIN_USE_BLSURFPLUGIN )

# Level 1 prerequisites:
IF(SALOME_HEXOTICPLUGIN_USE_BLSURFPLUGIN)
 SET_AND_CHECK(BLSURFPLUGIN_ROOT_DIR_EXP "")
 LIST(APPEND HexoticPLUGIN_DEFINITIONS "-DWITH_BLSURFPLUGIN")
ELSE(SALOME_HEXOTICPLUGIN_USE_BLSURFPLUGIN)
  SET_AND_CHECK(SMESH_ROOT_DIR_EXP "")
IF(SALOME_HEXOTICPLUGIN_USE_BLSURFPLUGIN)

# For all prerequisites, load the corresponding targets if the package was used
# in CONFIG mode. This ensures dependent projects link correctly
# without having to set LD_LIBRARY_PATH:
SET(_PREREQ_SalomeHexoticPLUGIN )
SET(_PREREQ_SalomeHexoticPLUGIN_CONFIG_DIR )
SET(_PREREQ_SalomeHexoticPLUGIN_COMPONENTS "")
LIST(LENGTH _PREREQ_SalomeHexoticPLUGIN_CONFIG_DIR _list_len_SalomeHexoticPLUGIN)
IF(NOT _list_len_SalomeHexoticPLUGIN EQUAL 0)
  # Another CMake stupidity - FOREACH(... RANGE r) generates r+1 numbers ...
  MATH(EXPR _range_SalomeHexoticPLUGIN "${_list_len_SalomeHexoticPLUGIN}-1")
  FOREACH(_p_SalomeHexoticPLUGIN RANGE ${_range_SalomeHexoticPLUGIN})
    LIST(GET _PREREQ_SalomeHexoticPLUGIN            ${_p_SalomeHexoticPLUGIN} _pkg_SalomeHexoticPLUGIN    )
    LIST(GET _PREREQ_SalomeHexoticPLUGIN_CONFIG_DIR ${_p_SalomeHexoticPLUGIN} _pkg_dir_SalomeHexoticPLUGIN)
    LIST(GET _PREREQ_SalomeHexoticPLUGIN_COMPONENTS ${_p_SalomeHexoticPLUGIN} _pkg_compo_SalomeHexoticPLUGIN)
    IF(NOT OMIT_DETECT_PACKAGE_${_pkg_SalomeHexoticPLUGIN})
      MESSAGE(STATUS "===> Reloading targets from ${_pkg_SalomeHexoticPLUGIN} ...")
      IF(NOT _pkg_compo_SalomeHexoticPLUGIN)
        FIND_PACKAGE(${_pkg_SalomeHexoticPLUGIN} REQUIRED NO_MODULE
            PATHS "${_pkg_dir_SalomeHexoticPLUGIN}"
            NO_DEFAULT_PATH)
      ELSE()
        STRING(REPLACE "," ";" _compo_lst_SalomeHexoticPLUGIN "${_pkg_compo_SalomeHexoticPLUGIN}")
        MESSAGE(STATUS "===> (components: ${_pkg_compo_SalomeHexoticPLUGIN})")
        FIND_PACKAGE(${_pkg_SalomeHexoticPLUGIN} REQUIRED NO_MODULE
            COMPONENTS ${_compo_lst_SalomeHexoticPLUGIN}
            PATHS "${_pkg_dir_SalomeHexoticPLUGIN}"
            NO_DEFAULT_PATH)
      ENDIF()
    ENDIF()
  ENDFOREACH()
ENDIF()

# Installation directories
SET(SALOME_INSTALL_BINS "bin/salome")
SET(SALOME_INSTALL_LIBS "lib/salome")
SET(SALOME_INSTALL_IDLS "idl/salome")
SET(SALOME_INSTALL_HEADERS "include/salome")
SET(SALOME_INSTALL_SCRIPT_SCRIPTS "bin/salome")
SET(SALOME_INSTALL_SCRIPT_DATA "bin/salome")
SET(SALOME_INSTALL_SCRIPT_PYTHON "bin/salome")
SET(SALOME_INSTALL_APPLISKEL_SCRIPTS "bin/salome/appliskel")
SET(SALOME_INSTALL_APPLISKEL_PYTHON "bin/salome/appliskel") 
SET(SALOME_INSTALL_CMAKE_LOCAL "adm_local/cmake_files")
SET(SALOME_INSTALL_PYTHON "lib/python2.7/site-packages/salome")
SET(SALOME_INSTALL_PYTHON_SHARED "lib/python2.7/site-packages/salome/shared_modules")
SET(SALOME_INSTALL_RES "share/salome/resources")
SET(SALOME_INSTALL_DOC "share/doc/salome")
SET(SALOME_INSTALL_AMCONFIG_LOCAL "adm_local/unix")

# Include SMESH or BLSURFPLUGIN targets if they were not already loaded:
IF(SALOME_HEXOTICPLUGIN_USE_BLSURFPLUGIN)
  IF(NOT (TARGET BLSURFEngine))
    INCLUDE("${BLSURFPLUGIN_ROOT_DIR_EXP}/${SALOME_INSTALL_CMAKE}/SalomeBLSURFPLUGINTargets.cmake")
  ENDIF()
ELSE(SALOME_HEXOTICPLUGIN_USE_BLSURFPLUGIN)
  IF(NOT (TARGET SMESHEngine))
    INCLUDE("${SMESH_ROOT_DIR_EXP}/${SALOME_INSTALL_CMAKE}/SalomeSMESHTargets.cmake")
  ENDIF()
ENDIF(SALOME_HEXOTICPLUGIN_USE_BLSURFPLUGIN)

# Exposed HexoticPLUGIN targets:
SET(HexoticPLUGIN_HexoticEngine HexoticEngine)
SET(HexoticPLUGIN_HexoticPluginGUI HexoticPluginGUI)
SET(HexoticPLUGIN_SalomeIDLHexoticPLUGIN SalomeIDLHexoticPLUGIN)
