// Copyright (C) 2007-2016  CEA/DEN, EDF R&D, OPEN CASCADE
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
// See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//

#ifndef GEOM_SMARTPTR_H 
#define GEOM_SMARTPTR_H 
 
#include <vtkSmartPointer.h> 
 
template <class T>
class GEOM_SmartPtr: public vtkSmartPointer<T>
{
public:
  GEOM_SmartPtr() {}
  GEOM_SmartPtr(T* r, bool theIsOwner = false): vtkSmartPointer<T>(r) { 
    if(r && theIsOwner) 
      r->Delete();
  }
  GEOM_SmartPtr& operator()(T* r, bool theIsOwner = false){ 
    vtkSmartPointer<T>::operator=(r); 
    if(r && theIsOwner) 
      r->Delete();
    return *this;
  }
  GEOM_SmartPtr& operator=(T* r){ vtkSmartPointer<T>::operator=(r); return *this;}
  T* Get() const { return this->GetPointer();} 
}; 
 
class GEOM_DeviceActor; 
typedef GEOM_SmartPtr<GEOM_DeviceActor> PDeviceActor; 
 
class vtkPolyDataMapper; 
typedef GEOM_SmartPtr<vtkPolyDataMapper> PPolyDataMapper;

class GEOM_PainterPolyDataMapper;
typedef GEOM_SmartPtr<GEOM_PainterPolyDataMapper> PPolyGeomPainterDataMapper;
 
 
#endif //GEOM_SMARTPTR_H 
