// Copyright (C) 2007-2016  CEA/DEN, EDF R&D, OPEN CASCADE
//
// Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
// CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
// See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//

//  SuperVisionTest AddComponent : example of component that adds two numbers
//  File   : Adder_Impl.hxx
//  Author : Jean Rahuel, CEA
//  Module : SuperVisionTest
//  $Header:
//
#ifndef _ADDITION_ADDER_IMPL_HXX_
#define _ADDITION_ADDER_IMPL_HXX_

#include "AdditionComponent.hxx"
#include <iostream>
#include <SALOMEconfig.h>
#include CORBA_SERVER_HEADER(AdditionComponent)
#include CORBA_SERVER_HEADER(SALOME_Component)
#include "SALOME_Component_i.hxx"

class ADDITIONCOMPONENTENGINE_EXPORT Adder_Impl :  public POA_AdditionComponent::Adder ,
                                                   public Engines_Component_i {
  public:
    Adder_Impl() ;
    Adder_Impl( CORBA::ORB_ptr orb ,
	        PortableServer::POA_ptr poa ,
	        PortableServer::ObjectId * contId , 
	        const char *instanceName ,
                const char *interfaceName , 
                const char * graphName ,
                const char * nodeName );

    virtual ~Adder_Impl();

    virtual char* getVersion();

    virtual void destroy() ;

    virtual CORBA::Double Add( CORBA::Double x , CORBA::Double y , CORBA::Double & z ) ;

    virtual CORBA::Double AddWithoutSleep( CORBA::Double x , CORBA::Double y , CORBA::Double & z ) ;

    virtual CORBA::Double AddAndCompare( CORBA::Double x , CORBA::Double y ,
                                         AdditionComponent::Adder_ptr anOtherAdder ,
                                         CORBA::Double & z ) ;

    virtual void SetLastResult( CORBA::Double z ) ;

    virtual void LastResult( CORBA::Double & z ) ;

    virtual Engines::EngineComponent_ptr LccAdditionInterface( char * aContainer ,
                                                               char * aComponentName ) ;

  private:

    double LastAddition ;

};

#endif
