# -*- coding: utf-8 -*-

# Copyright 2016-2017 EDF R&D
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 3 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, you may download a copy of license
# from https://www.gnu.org/licenses/gpl-3.0.

"""
Widgets
-------

The package implements specific widgets for AsterStudy application.
"""

from __future__ import unicode_literals

from .aboutdlg import AboutDlg
from .auxiliary import HLine
from .catalogsview import CatalogsView
from .categoryview import CategoryView
from .conceptseditor import ConceptsEditor
from .dialog import Dialog, TestnameDialog
from .elidedbutton import ElidedButton
from .elidedlabel import ElidedLabel
from .filterpanel import FilterPanel, FilterWidget
from .fontwidget import FontWidget
from .mainwindow import MainWindow
from .messagebox import MessageBox
from .popup_frame import PopupFrame
from .searchwidget import SearchWidget
from .shrinkingcombobox import ShrinkingComboBox
from .tabwidget import TabWidget
from .texteditor import TextEditor
from .treewidget import TreeDelegate, TreeWidget
