# -*- coding: utf-8 -*-

# Copyright 2016 EDF R&D
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 3 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, you may download a copy of license
# from https://www.gnu.org/licenses/gpl-3.0.

"""
Remote filesystems
------------------

The module implements an utility for automatically mount remote filesystems
at startup and unmount them at closure.

"""

from __future__ import print_function, unicode_literals

from ..common import is_localhost, translate
from ..common.remote_utils import unmount_all
from ..datamodel.engine import serverinfos_factory


# Run in a QThread does not work probably because of the Gio loop.
class MountWorker(object):
    """Class that manages the mounting points."""

    @staticmethod
    def mount():
        """Mount remote filesystems."""
        # mount remote filesystems
        infos = serverinfos_factory()
        for sname in infos.available_servers:
            if not is_localhost(sname):
                print(translate("AsterStudy",
                                "Mounting filesystems for {0}..."
                                .format(sname)))
                infos.mount_filesystem(sname)

    @staticmethod
    def unmount():
        """Unount remote filesystems."""
        unmount_all()
