# -*- coding: utf-8 -*-

# Copyright 2016-2018 EDF R&D
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 3 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, you may download a copy of license
# from https://www.gnu.org/licenses/gpl-3.0.

"""
Generic action
--------------

The module implements generic action class for AsterStudy application.

For more details, see *Action* class.

"""

from __future__ import unicode_literals

from PyQt5 import Qt as Q

from ...common import update_visibility

__all__ = ["Action"]

# note: the following pragma is added to prevent pylint complaining
#       about functions that follow Qt naming conventions;
#       it should go after all global functions
# pragma pylint: disable=invalid-name


class Action(Q.QAction):
    """
    Generic action class that automatically updates visibility of
    toolbars and menus where it is inserted.
    """

    def __init__(self, text, parent):
        """
        Create action.

        Arguments:
            text (str): Action's text.
            parent (QObject): Parent object.
        """
        super(Action, self).__init__(text, parent)
        self.changed.connect(self._changed)

    @Q.pyqtSlot()
    def _changed(self):
        """
        Called when action is changed.

        Updates related widgets.
        """
        for widget in self.associatedWidgets():
            update_visibility(widget)
