# -*- coding: utf-8 -*-

# Copyright 2016 EDF R&D
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 3 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, you may download a copy of license
# from https://www.gnu.org/licenses/gpl-3.0.

"""Implementation of data model for AsterStudy application."""

from __future__ import unicode_literals

import logging

from .abstract_data_model import AbstractDataModel, Node
from .aster_syntax import IDS, get_cata_typeid, is_unit_valid
from .catalogs import CATA
from .command import CO, KeysMixing
from .comm2study import comm2study
from .engine import Engine, init_default_engine
from .file_descriptors import Info
from .general import FileAttr, Validity, ConversionLevel
from .general import CataMixing, UIDMixing
from .history import History
from .study2comm import study2comm
from .study2code import study2code
from .sync import synchronize
from .undo_redo import UndoRedo

LOGGER = logging.getLogger('dicttoxml')
LOGGER.setLevel(logging.WARNING)
