# -*- coding: utf-8 -*-

# Copyright 2016-2018 EDF R&D
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 3 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, you may download a copy of license
# from https://www.gnu.org/licenses/gpl-3.0.

"""
ASTERSTUDY enviroment
---------------------

Set-up additional environment for ASTERSTUDY SALOME module.

"""

from __future__ import unicode_literals

import os
import sys

# pragma pylint: disable=import-error
from setenv import add_path, get_lib_dir

# pragma pylint: disable=unused-argument
def set_env(args):
    """
    Set up environment.

    Arguments:
        args: launch parameters (dictionary)
    """
    root_dir = os.getenv("ASTERSTUDY_ROOT_DIR")
    python_version = "python%d.%d" % sys.version_info[0:2]
    add_path(os.path.join(root_dir, get_lib_dir(), python_version,
                          "site-packages"), "PYTHONPATH")
